/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class RFCraftingRecipe {
    private final CraftingContainer inv = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

        public boolean m_6875_(@Nonnull Player playerIn) {
            return false;
        }

        public ItemStack m_7648_(Player player, int slot) {
            return ItemStack.f_41583_;
        }
    }, 3, 3);
    private ItemStack result = ItemStack.f_41583_;
    private boolean recipePresent = false;
    private Optional<CraftingRecipe> recipe = Optional.empty();
    private boolean keepOne = false;
    private CraftMode craftMode = CraftMode.EXT;

    public static Optional<CraftingRecipe> findRecipe(Level world, CraftingContainer inv) {
        return world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)inv, world);
    }

    public void readFromNBT(CompoundTag tagCompound) {
        ListTag nbtTagList = tagCompound.m_128437_("Items", 10);
        for (int i = 0; i < nbtTagList.size(); ++i) {
            CompoundTag CompoundNBT = nbtTagList.m_128728_(i);
            this.inv.m_6836_(i, ItemStack.m_41712_((CompoundTag)CompoundNBT));
        }
        CompoundTag resultCompound = tagCompound.m_128469_("Result");
        this.result = ItemStack.m_41712_((CompoundTag)resultCompound);
        this.keepOne = tagCompound.m_128471_("Keep");
        this.craftMode = CraftMode.values()[tagCompound.m_128445_("Int")];
        this.recipePresent = false;
    }

    public void writeToNBT(CompoundTag tagCompound) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inv.m_8020_(i);
            CompoundTag CompoundNBT = new CompoundTag();
            if (!stack.m_41619_()) {
                stack.m_41739_(CompoundNBT);
            }
            nbtTagList.add((Object)CompoundNBT);
        }
        CompoundTag resultCompound = new CompoundTag();
        if (!this.result.m_41619_()) {
            this.result.m_41739_(resultCompound);
        }
        tagCompound.m_128365_("Result", (Tag)resultCompound);
        tagCompound.m_128365_("Items", (Tag)nbtTagList);
        tagCompound.m_128379_("Keep", this.keepOne);
        tagCompound.m_128344_("Int", (byte)this.craftMode.ordinal());
    }

    public void setRecipe(ItemStack[] items, ItemStack result) {
        for (int i = 0; i < 9; ++i) {
            this.inv.m_6836_(i, items[i]);
        }
        this.result = result;
        this.recipePresent = false;
    }

    public CraftingContainer getInventory() {
        return this.inv;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public Optional<CraftingRecipe> getCachedRecipe(Level world) {
        if (!this.recipePresent) {
            this.recipePresent = true;
            this.recipe = RFCraftingRecipe.findRecipe(world, this.inv);
        }
        return this.recipe;
    }

    public boolean isKeepOne() {
        return this.keepOne;
    }

    public void setKeepOne(boolean keepOne) {
        this.keepOne = keepOne;
    }

    public CraftMode getCraftMode() {
        return this.craftMode;
    }

    public void setCraftMode(CraftMode craftMode) {
        this.craftMode = craftMode;
    }

    public static enum CraftMode {
        EXT("Ext"),
        INT("Int"),
        EXTC("ExtC");

        private final String description;

        private CraftMode(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

