/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.container;

import de.srendi.advancedperipherals.client.ClientUUIDCache;
import de.srendi.advancedperipherals.common.blocks.blockentities.InventoryManagerEntity;
import de.srendi.advancedperipherals.common.container.InventoryManagerContainer;
import de.srendi.advancedperipherals.common.container.base.BaseScreen;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class InventoryManagerScreen
extends BaseScreen<InventoryManagerContainer> {
    private final InventoryManagerContainer container;

    public InventoryManagerScreen(InventoryManagerContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.container = screenContainer;
    }

    @Override
    public int getSizeX() {
        return 174;
    }

    @Override
    public int getSizeY() {
        return 165;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("advancedperipherals", "textures/gui/inventory_manager_gui.png");
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        InventoryManagerEntity blockEntity = (InventoryManagerEntity)this.container.getTileEntity();
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        UUID owner = blockEntity.getOwner();
        Object textToDraw = "No Owner";
        if (owner != null) {
            String username = ClientUUIDCache.getUsername(owner, minecraft.f_91074_.m_20148_());
            if (username == null) {
                username = owner.toString();
            }
            textToDraw = "Current Owner: " + username;
        }
        guiGraphics.m_280056_(font, (String)textToDraw, this.getGuiLeft() + 79 + 8 - font.m_92895_((String)textToDraw) / 2, this.getGuiTop() + 29 + 24, 0x404040, false);
    }
}

