/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.blocks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.information.IPowerInformation;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.module.DefaultModuleSupport;
import mcjty.lib.api.module.IModuleSupport;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.NamedEnum;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.environmental.EnvModuleProvider;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalConfiguration;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.environmental.modules.EnvironmentModule;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public class EnvironmentalControllerTileEntity
extends TickingTileEntity {
    public static final String COMPONENT_NAME = "environmental_controller";
    public static final int ENV_MODULES = 7;
    public static final int SLOT_MODULES = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(7).box(SlotDefinition.specific(s -> s.m_41720_() instanceof EnvModuleProvider).in().out(), 0, 7, 8, 1, 7).playerSlots(27, 142));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> stack.m_41720_() instanceof EnvModuleProvider).onUpdate((slot, stack) -> {
        this.environmentModules = null;
    }).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)EnvironmentalConfiguration.ENVIRONMENTAL_MAXENERGY.get()).intValue(), (long)((Integer)EnvironmentalConfiguration.ENVIRONMENTAL_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusableHandler = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.POWER_INFO)
    private final IPowerInformation powerInfoHandler = this.createPowerInfo();
    @Cap(type=CapType.MODULE)
    private final IModuleSupport moduleSupportHandler = new DefaultModuleSupport(0, 6){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.m_41720_() instanceof EnvModuleProvider;
        }
    };
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Environmental Controller").containerSupplier(DefaultContainerProvider.container(EnvironmentalModule.CONTAINER_ENVIRONENTAL_CONTROLLER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    private List<EnvironmentModule> environmentModules = null;
    public Set<String> players = new HashSet<String>();
    private int totalRfPerTick = 0;
    @GuiValue
    private EnvironmentalMode mode = EnvironmentalMode.MODE_BLACKLIST;
    private int radius = 50;
    @GuiValue
    public static final Value<?, ?> VALUE_RADIUS = Value.create((String)"radius", (Type)Type.INTEGER, EnvironmentalControllerTileEntity::getRadius, EnvironmentalControllerTileEntity::setRadius);
    @GuiValue
    private int miny = 30;
    @GuiValue
    private int maxy = 70;
    private int volume = -1;
    private boolean active = false;
    private int powerTimeout = 0;
    @ServerCommand
    public static final Command<?> CMD_RSMODE = Command.create((String)"env.setRsMode", (te, player, params) -> te.setRSMode(RedstoneMode.values()[(Integer)params.get(ImageChoiceLabel.PARAM_CHOICE_IDX)]));
    public static final Key<Integer> PARAM_MIN = new Key("min", Type.INTEGER);
    public static final Key<Integer> PARAM_MAX = new Key("max", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_SETBOUNDS = Command.create((String)"env.setBounds", (te, player, params) -> {
        te.setMiny((Integer)params.get(PARAM_MIN));
        te.setMaxy((Integer)params.get(PARAM_MAX));
    });
    public static final Key<Integer> PARAM_MODE = new Key("mode", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_SETMODE = Command.create((String)"env.setBlacklist", (te, player, params) -> te.setMode(EnvironmentalMode.values()[(Integer)params.get(PARAM_MODE)]));
    public static final Key<String> PARAM_NAME = new Key("name", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_ADDPLAYER = Command.create((String)"env.addPlayer", (te, player, params) -> te.addPlayer((String)params.get(PARAM_NAME)));
    @ServerCommand
    public static final Command<?> CMD_DELPLAYER = Command.create((String)"env.delPlayer", (te, player, params) -> te.delPlayer((String)params.get(PARAM_NAME)));
    @ServerCommand(type=String.class)
    public static final ListCommand<?, ?> CMD_GETPLAYERS = ListCommand.create((String)"rftoolsutility.env.getPlayers", (te, player, params) -> te.getPlayersAsList(), (te, player, params, list) -> {
        te.players = new HashSet<String>(list);
    });

    public EnvironmentalControllerTileEntity(BlockPos pos, BlockState state) {
        super(EnvironmentalModule.TYPE_ENVIRONENTAL_CONTROLLER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(BlockBehaviour.Properties.m_284310_().m_60978_(2.0f).m_60918_(SoundType.f_56743_).m_60953_(value -> 13)).tileEntitySupplier(EnvironmentalControllerTileEntity::new).topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsutility:machines/environmental")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public EnvironmentalMode getMode() {
        return this.mode;
    }

    public void setMode(EnvironmentalMode mode) {
        this.mode = mode;
        this.m_6596_();
    }

    private float getPowerMultiplier() {
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case EnvironmentalMode.MODE_BLACKLIST, EnvironmentalMode.MODE_WHITELIST -> 1.0f;
            case EnvironmentalMode.MODE_HOSTILE, EnvironmentalMode.MODE_PASSIVE, EnvironmentalMode.MODE_MOBS, EnvironmentalMode.MODE_ALL -> (float)((Double)EnvironmentalConfiguration.mobsPowerMultiplier.get()).doubleValue();
        };
    }

    public boolean isEntityAffected(Entity entity) {
        switch (this.mode) {
            case MODE_BLACKLIST: {
                if (entity instanceof Player) {
                    return this.isPlayerAffected((Player)entity);
                }
                return false;
            }
            case MODE_WHITELIST: {
                if (entity instanceof Player) {
                    return this.isPlayerAffected((Player)entity);
                }
                return false;
            }
            case MODE_HOSTILE: {
                return entity instanceof Enemy;
            }
            case MODE_PASSIVE: {
                return entity instanceof Mob && !(entity instanceof Enemy);
            }
            case MODE_MOBS: {
                return entity instanceof Mob;
            }
            case MODE_ALL: {
                if (entity instanceof Player) {
                    return this.isPlayerAffected((Player)entity);
                }
                return true;
            }
        }
        return false;
    }

    public boolean isPlayerAffected(Player player) {
        if (this.mode == EnvironmentalMode.MODE_WHITELIST) {
            return this.players.contains(player.m_7755_().getString());
        }
        if (this.mode == EnvironmentalMode.MODE_BLACKLIST) {
            return !this.players.contains(player.m_7755_().getString());
        }
        return this.mode == EnvironmentalMode.MODE_ALL;
    }

    private List<String> getPlayersAsList() {
        return new ArrayList<String>(this.players);
    }

    private void addPlayer(String player) {
        if (!this.players.contains(player)) {
            this.players.add(player);
            this.m_6596_();
        }
    }

    private void delPlayer(String player) {
        if (this.players.contains(player)) {
            this.players.remove(player);
            this.m_6596_();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public int getTotalRfPerTick() {
        if (this.environmentModules == null) {
            this.getEnvironmentModules();
        }
        float factor = this.infusableHandler.getInfusedFactor();
        int rfNeeded = (int)((float)this.totalRfPerTick * this.getPowerMultiplier() * (4.0f - factor) / 4.0f);
        if (this.environmentModules.isEmpty()) {
            return rfNeeded;
        }
        if (rfNeeded < (Integer)EnvironmentalConfiguration.MIN_USAGE.get()) {
            rfNeeded = (Integer)EnvironmentalConfiguration.MIN_USAGE.get();
        }
        return rfNeeded;
    }

    public int getVolume() {
        if (this.volume == -1) {
            this.volume = (int)((double)(this.radius * this.radius) * Math.PI * (double)(this.maxy - this.miny + 1));
        }
        return this.volume;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.m_6596_();
        this.volume = -1;
        this.environmentModules = null;
    }

    public int getMiny() {
        return this.miny;
    }

    public void setMiny(int miny) {
        if (miny == Integer.MIN_VALUE) {
            return;
        }
        this.miny = miny;
        this.m_6596_();
        this.volume = -1;
        this.environmentModules = null;
    }

    public int getMaxy() {
        return this.maxy;
    }

    public void setMaxy(int maxy) {
        if (maxy == Integer.MIN_VALUE) {
            return;
        }
        this.maxy = maxy;
        this.volume = -1;
        this.environmentModules = null;
        this.m_6596_();
    }

    protected void tickServer() {
        if (this.powerTimeout > 0) {
            --this.powerTimeout;
            return;
        }
        long rf = this.energyStorage.getEnergyStored();
        if (!this.isMachineEnabled()) {
            rf = 0L;
        }
        this.getEnvironmentModules();
        int rfNeeded = this.getTotalRfPerTick();
        if ((long)rfNeeded > rf || this.environmentModules.isEmpty()) {
            this.deactivate();
            this.powerTimeout = 20;
        } else {
            this.energyStorage.consumeEnergy((long)rfNeeded);
            for (EnvironmentModule module : this.environmentModules) {
                module.activate(true);
                module.tick(this.f_58857_, this.m_58899_(), this.radius, this.miny, this.maxy, this);
            }
            if (!this.active) {
                this.active = true;
                this.markDirtyClient();
            }
        }
    }

    public void deactivate() {
        for (EnvironmentModule module : this.environmentModules) {
            module.activate(false);
        }
        if (this.active) {
            this.active = false;
            this.markDirtyClient();
        }
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            this.powerTimeout = 0;
        }
        super.setPowerInput(powered);
    }

    public List<EnvironmentModule> getEnvironmentModules() {
        if (this.environmentModules == null) {
            int volume = this.getVolume();
            this.totalRfPerTick = 0;
            this.environmentModules = new ArrayList<EnvironmentModule>();
            for (int i = 0; i < this.items.getSlots(); ++i) {
                Item item;
                ItemStack itemStack = this.items.getStackInSlot(i);
                if (itemStack.m_41619_() || !((item = itemStack.m_41720_()) instanceof EnvModuleProvider)) continue;
                EnvModuleProvider moduleProvider = (EnvModuleProvider)item;
                Supplier<? extends EnvironmentModule> supplier = moduleProvider.getServerEnvironmentModule();
                EnvironmentModule environmentModule = supplier.get();
                this.environmentModules.add(environmentModule);
                this.totalRfPerTick += (int)(environmentModule.getRfPerTick() * (float)volume);
            }
        }
        return this.environmentModules;
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.totalRfPerTick = tagCompound.m_128451_("rfPerTick");
        this.active = tagCompound.m_128471_("active");
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.radius = info.m_128451_("radius");
        this.miny = info.m_128451_("miny");
        this.maxy = info.m_128451_("maxy");
        this.volume = -1;
        if (info.m_128441_("whitelist")) {
            boolean wl = info.m_128471_("whitelist");
            this.mode = wl ? EnvironmentalMode.MODE_WHITELIST : EnvironmentalMode.MODE_BLACKLIST;
        } else {
            int m = info.m_128451_("mode");
            this.mode = EnvironmentalMode.values()[m];
        }
        this.players.clear();
        ListTag playerList = info.m_128437_("players", 8);
        if (!playerList.isEmpty()) {
            for (int i = 0; i < playerList.size(); ++i) {
                String player = playerList.m_128778_(i);
                this.players.add(player);
            }
        }
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.active = tagCompound.m_128471_("active");
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        tagCompound.m_128379_("active", this.active);
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128405_("rfPerTick", this.totalRfPerTick);
        tagCompound.m_128379_("active", this.active);
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("radius", this.radius);
        info.m_128405_("miny", this.miny);
        info.m_128405_("maxy", this.maxy);
        info.m_128405_("mode", this.mode.ordinal());
        ListTag playerTagList = new ListTag();
        for (String player : this.players) {
            playerTagList.add((Object)StringTag.m_129297_((String)player));
        }
        info.m_128365_("players", (Tag)playerTagList);
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
        this.deactivate();
    }

    @Nonnull
    private IPowerInformation createPowerInfo() {
        return new IPowerInformation(){

            public long getEnergyDiffPerTick() {
                return EnvironmentalControllerTileEntity.this.isActive() ? (long)(-EnvironmentalControllerTileEntity.this.getTotalRfPerTick()) : 0L;
            }

            public String getEnergyUnitName() {
                return "RF";
            }

            public boolean isMachineActive() {
                return EnvironmentalControllerTileEntity.this.isActive();
            }

            public boolean isMachineRunning() {
                return EnvironmentalControllerTileEntity.this.isActive();
            }

            public String getMachineStatus() {
                return EnvironmentalControllerTileEntity.this.isActive() ? "active" : "idle";
            }
        };
    }

    public static enum EnvironmentalMode implements NamedEnum<EnvironmentalMode>
    {
        MODE_BLACKLIST("blacklist"),
        MODE_WHITELIST("whitelist"),
        MODE_HOSTILE("hostile"),
        MODE_PASSIVE("passive"),
        MODE_MOBS("mobs"),
        MODE_ALL("all");

        private final String name;

        private EnvironmentalMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String[] getDescription() {
            return new String[]{this.name};
        }
    }
}

