/*
 * Decompiled with CFR 0.152.
 */
package dhyces.waxablecoral;

import dhyces.waxablecoral.ForgeWaxableCoralClient;
import dhyces.waxablecoral.Register;
import dhyces.waxablecoral.WaxableCoral;
import dhyces.waxablecoral.WaxableCoralAPI;
import dhyces.waxablecoral.integration.Compats;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.DeferredRegister;

@Mod(value="waxablecoral")
public class ForgeWaxableCoral {
    public static final DeferredRegister<Block> BLOCK_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256747_, (String)"waxablecoral");
    public static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)"waxablecoral");
    public static final TagKey<Item> HONEYCOMBS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "honeycombs"));

    public ForgeWaxableCoral() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCK_REGISTER.register(modBus);
        ITEM_REGISTER.register(modBus);
        WaxableCoral.init();
        if (FMLLoader.getDist().isClient()) {
            ForgeWaxableCoralClient.init(modBus);
        }
        modBus.addListener(this::onCommonLoad);
        modBus.addListener(this::addTabs);
        MinecraftForge.EVENT_BUS.addListener(this::onBlockRightClick);
        MinecraftForge.EVENT_BUS.addListener(this::onAxeWaxOffUsed);
        Compats.init(modBus);
    }

    private void onCommonLoad(FMLCommonSetupEvent event) {
        event.enqueueWork(WaxableCoralAPI::fillWaxingMap);
    }

    private void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        Block waxed;
        BlockPos waxingPos = event.getHitVec().m_82425_();
        BlockState state = event.getLevel().m_8055_(waxingPos);
        ItemStack usedStack = event.getItemStack();
        Level level = event.getLevel();
        if (usedStack.m_204117_(HONEYCOMBS) && (waxed = WaxableCoralAPI.getWaxed(state.m_60734_())) != null) {
            BlockState waxedState = waxed.m_152465_(state);
            level.m_7731_(waxingPos, waxedState, 11);
            if (!event.getEntity().m_150110_().f_35937_) {
                usedStack.m_41774_(1);
            }
            event.getEntity().m_36246_(Stats.f_12982_.m_12902_((Object)usedStack.m_41720_()));
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, waxingPos, usedStack);
            }
            level.m_220407_(GameEvent.f_157792_, waxingPos, GameEvent.Context.m_223719_((Entity)event.getEntity(), (BlockState)waxedState));
            level.m_5898_(event.getEntity(), 3003, waxingPos, 0);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    private void onAxeWaxOffUsed(BlockEvent.BlockToolModificationEvent event) {
        BlockState state;
        Block unwaxed;
        if (event.getToolAction().equals(ToolActions.AXE_WAX_OFF) && (unwaxed = WaxableCoralAPI.getUnwaxed((state = event.getLevel().m_8055_(event.getContext().m_8083_())).m_60734_())) != null) {
            event.setFinalState(unwaxed.m_152465_(state));
            event.getLevel().m_186460_(event.getPos(), unwaxed, 60 + event.getLevel().m_213780_().m_188503_(40));
        }
    }

    private void addTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256776_) {
            MutableHashedLinkedMap tabItems = event.getEntries();
            ForgeWaxableCoral.putBeforeFullVis((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)tabItems, Items.f_41902_, Register.WAXED_TUBE_CORAL_BLOCK);
            ForgeWaxableCoral.putBeforeFullVis((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)tabItems, Items.f_41902_, Register.WAXED_BRAIN_CORAL_BLOCK);
            ForgeWaxableCoral.putBeforeFullVis((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)tabItems, Items.f_41902_, Register.WAXED_BUBBLE_CORAL_BLOCK);
            ForgeWaxableCoral.putBeforeFullVis((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)tabItems, Items.f_41902_, Register.WAXED_FIRE_CORAL_BLOCK);
            ForgeWaxableCoral.putBeforeFullVis((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)tabItems, Items.f_41902_, Register.WAXED_HORN_CORAL_BLOCK);
            ForgeWaxableCoral.putBeforeFullVis((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)tabItems, Items.f_41902_, Register.WAXED_TUBE_CORAL);
            ForgeWaxableCoral.putBeforeFullVis((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)tabItems, Items.f_41902_, Register.WAXED_BRAIN_CORAL);
            ForgeWaxableCoral.putBeforeFullVis((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)tabItems, Items.f_41902_, Register.WAXED_BUBBLE_CORAL);
            ForgeWaxableCoral.putBeforeFullVis((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)tabItems, Items.f_41902_, Register.WAXED_FIRE_CORAL);
            ForgeWaxableCoral.putBeforeFullVis((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)tabItems, Items.f_41902_, Register.WAXED_HORN_CORAL);
            ForgeWaxableCoral.putBeforeFullVis((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)tabItems, Items.f_41902_, Register.WAXED_TUBE_CORAL_FAN);
            ForgeWaxableCoral.putBeforeFullVis((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)tabItems, Items.f_41902_, Register.WAXED_BRAIN_CORAL_FAN);
            ForgeWaxableCoral.putBeforeFullVis((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)tabItems, Items.f_41902_, Register.WAXED_BUBBLE_CORAL_FAN);
            ForgeWaxableCoral.putBeforeFullVis((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)tabItems, Items.f_41902_, Register.WAXED_FIRE_CORAL_FAN);
            ForgeWaxableCoral.putBeforeFullVis((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)tabItems, Items.f_41902_, Register.WAXED_HORN_CORAL_FAN);
        }
    }

    private static void putBeforeFullVis(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> tabItems, Item item, Supplier<? extends Block> regObj) {
        tabItems.putBefore((Object)item.m_7968_(), (Object)regObj.get().m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }
}

