/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity.shot;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import reliquary.init.ModEntities;
import reliquary.reference.Settings;
import reliquary.util.RegistryHelper;
import reliquary.util.potions.XRPotionHelper;

public abstract class ShotEntityBase
extends Projectile {
    private static final EntityDataAccessor<Byte> CRITICAL = SynchedEntityData.m_135353_(ShotEntityBase.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(ShotEntityBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private List<MobEffectInstance> potionEffects = Collections.emptyList();
    protected int ticksInAir = 0;
    private int ricochetCounter = 0;
    private boolean scheduledForDeath = false;

    protected <T extends ShotEntityBase> ShotEntityBase(EntityType<T> entityType, Level world) {
        super(entityType, world);
    }

    protected <T extends ShotEntityBase> ShotEntityBase(EntityType<T> entityType, Level world, Player player, InteractionHand hand) {
        this(entityType, world);
        this.m_5602_((Entity)player);
        this.m_7678_(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
        this.m_6034_(this.m_20185_() - (double)(Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * (float)(hand == InteractionHand.MAIN_HAND ? 1 : -1) * 0.16f), this.m_20186_() - 0.2, this.m_20189_() - (double)(Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * (float)(hand == InteractionHand.MAIN_HAND ? 1 : -1) * 0.16f));
    }

    protected Optional<Player> getShooterPlayer() {
        return Optional.ofNullable((Player)this.m_19749_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CRITICAL, (Object)0);
        this.f_19804_.m_135372_(COLOR, (Object)0);
    }

    public ShotEntityBase addPotionEffects(List<MobEffectInstance> effects) {
        if (!effects.isEmpty()) {
            this.potionEffects = effects;
            this.f_19804_.m_135381_(COLOR, (Object)PotionUtils.m_43564_(effects));
        }
        return this;
    }

    public void m_6686_(double motionX, double motionY, double motionZ, float velocity, float inaccuracy) {
        float var9 = (float)Math.sqrt(motionX * motionX + motionY * motionY + motionZ * motionZ);
        motionX /= (double)var9;
        motionY /= (double)var9;
        motionZ /= (double)var9;
        motionX += this.f_19796_.m_188583_() * 0.0075 * (double)inaccuracy;
        motionY += this.f_19796_.m_188583_() * 0.0075 * (double)inaccuracy;
        motionZ += this.f_19796_.m_188583_() * 0.0075 * (double)inaccuracy;
        this.m_20334_(motionX *= (double)velocity, motionY *= (double)velocity, motionZ *= (double)velocity);
        float var10 = (float)Math.sqrt(motionX * motionX + motionZ * motionZ);
        this.m_146922_((float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI));
        this.m_146926_((float)(Math.atan2(motionY, var10) * 180.0 / Math.PI));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.m_6034_(x, y, z);
        this.m_19915_(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6001_(double motionX, double motionY, double motionZ) {
        this.m_20334_(motionX, motionY, motionZ);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            float var7 = (float)Math.sqrt(motionX * motionX + motionZ * motionZ);
            this.m_146922_((float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI));
            this.m_146926_((float)(Math.atan2(motionY, var7) * 180.0 / Math.PI));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
            this.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.ticksInAir > 200) {
            this.m_146870_();
        }
        if (this.m_9236_().f_46443_) {
            this.spawnPotionParticles();
        }
        Vec3 motionVec = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            float pythingy = (float)Math.sqrt(motionVec.m_7096_() * motionVec.m_7096_() + motionVec.m_7094_() * motionVec.m_7094_());
            this.m_146922_((float)(Math.atan2(motionVec.m_7096_(), motionVec.m_7094_()) * 180.0 / Math.PI));
            this.m_146926_((float)(Math.atan2(motionVec.m_7098_(), pythingy) * 180.0 / Math.PI));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        ++this.ticksInAir;
        if (this.ticksInAir == 2) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + this.smallGauss(0.1), this.m_20186_() + this.smallGauss(0.1), this.m_20189_() + this.smallGauss(0.1), 0.0, 0.0, 0.0);
            for (int particles = 0; particles < 3; ++particles) {
                this.doFiringEffects();
            }
        } else {
            this.doFlightEffects();
        }
        Vec3 posVector = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Vec3 approachVector = new Vec3(this.m_20185_() + motionVec.m_7096_(), this.m_20186_() + motionVec.m_7098_(), this.m_20189_() + motionVec.m_7094_());
        BlockHitResult objectStruckByVector = this.m_9236_().m_45547_(new ClipContext(posVector, approachVector, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        Entity hitEntity = this.getHitEntity(motionVec, posVector, approachVector);
        if (hitEntity != null) {
            objectStruckByVector = new EntityHitResult(hitEntity);
        }
        if (objectStruckByVector != null) {
            this.applyPotionEffects((HitResult)objectStruckByVector);
            this.m_6532_((HitResult)objectStruckByVector);
        }
        if (this.scheduledForDeath) {
            this.m_146870_();
        }
        Vec3 newPos = this.m_20182_().m_82549_(this.m_20184_());
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
    }

    @Nullable
    private Entity getHitEntity(Vec3 motionVec, Vec3 posVector, Vec3 approachVector) {
        Entity hitEntity = null;
        List struckEntitiesInAABB = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82369_(motionVec).m_82377_(1.0, 1.0, 1.0));
        double var7 = 0.0;
        for (Entity struckEntity : struckEntitiesInAABB) {
            double var14;
            if (!struckEntity.m_6087_() || struckEntity == this.m_19749_() && this.ticksInAir < 5) continue;
            float var11 = 0.5f;
            AABB var12 = struckEntity.m_20191_().m_82377_((double)var11, (double)var11, (double)var11);
            Optional hitResult = var12.m_82371_(posVector, approachVector);
            if (!hitResult.isPresent() || !((var14 = posVector.m_82554_((Vec3)hitResult.get())) < var7) && var7 != 0.0) continue;
            hitEntity = struckEntity;
            var7 = var14;
        }
        return hitEntity;
    }

    private void spawnPotionParticles() {
        int color = this.getColor();
        if (color != 0) {
            double d0 = (double)(color >> 16 & 0xFF) / 255.0;
            double d1 = (double)(color >> 8 & 0xFF) / 255.0;
            double d2 = (double)(color & 0xFF) / 255.0;
            for (int j = 0; j < 2; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    private void applyPotionEffects(HitResult objectStruckByVector) {
        EntityHitResult entityStruckResult;
        Entity entity;
        if (objectStruckByVector.m_6662_() == HitResult.Type.ENTITY && (entity = (entityStruckResult = (EntityHitResult)objectStruckByVector).m_82443_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.potionEffects != null && !this.potionEffects.isEmpty()) {
                XRPotionHelper.applyEffectsToEntity(this.potionEffects, (Entity)this, this.m_19749_(), living);
            }
        }
    }

    protected void m_7378_(CompoundTag compound) {
        this.potionEffects = XRPotionHelper.getPotionEffectsFromCompoundTag(compound);
    }

    protected void m_7380_(CompoundTag compound) {
        XRPotionHelper.addPotionEffectsToCompoundTag(compound, this.potionEffects);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = 64.0;
        return distance < d0 * d0;
    }

    public boolean m_6097_() {
        return false;
    }

    int d3() {
        return this.f_19796_.m_188503_(3) + 1;
    }

    int d6() {
        return this.f_19796_.m_188503_(6) + 1;
    }

    int d12() {
        return this.f_19796_.m_188503_(12) + 1;
    }

    void doDamage(LivingEntity e) {
        e.m_6469_(this.getDamageSource(e), (e instanceof Player ? 0.5f : 1.0f) * this.adjustDamageForPotionShots(this.getDamageOfShot(e)));
    }

    protected DamageSource getDamageSource(LivingEntity livingEntity) {
        return livingEntity.m_269291_().m_268998_(ModEntities.BULLET_DAMAGE_TYPE, this.m_19749_(), (Entity)this);
    }

    private float adjustDamageForPotionShots(int damageOfShot) {
        return this.potionEffects != null && !this.potionEffects.isEmpty() ? 4.0f : (float)damageOfShot;
    }

    protected void spawnMotionBasedParticle(ParticleOptions particleData) {
        this.spawnMotionBasedParticle(particleData, this.m_20186_());
    }

    protected void spawnMotionBasedParticle(ParticleOptions particleData, double y) {
        Vec3 motion = this.m_20184_();
        this.m_9236_().m_7106_(particleData, this.m_20185_(), y, this.m_20189_(), this.gaussian(motion.m_7096_()), this.gaussian(motion.m_7098_()), this.gaussian(motion.m_7094_()));
    }

    protected void groundImpact(Direction sideHit) {
        this.ricochet(sideHit);
    }

    protected double smallGauss(double d) {
        return ((double)this.m_9236_().f_46441_.m_188501_() - 0.5) * d;
    }

    double posGauss(double d) {
        return (double)this.f_19796_.m_188501_() * 0.5 * d;
    }

    double gaussian(double d) {
        return d + d * (((double)this.f_19796_.m_188501_() - 0.5) / 4.0);
    }

    double lowGauss(double d) {
        return d - d * ((double)(this.f_19796_.m_188501_() / 4.0f) + 0.5);
    }

    private void ricochet(Direction sideHit) {
        switch (sideHit) {
            case DOWN: 
            case UP: {
                this.m_20256_(this.m_20184_().m_82542_(1.0, -1.0, 1.0));
                break;
            }
            case WEST: 
            case EAST: {
                this.m_20256_(this.m_20184_().m_82542_(-1.0, 1.0, 1.0));
                break;
            }
            case SOUTH: 
            case NORTH: {
                this.m_20256_(this.m_20184_().m_82542_(1.0, 1.0, -1.0));
                break;
            }
        }
        ++this.ricochetCounter;
        if (this.ricochetCounter > this.getRicochetMax()) {
            this.doBurstEffect(sideHit);
            this.scheduledForDeath = true;
            block11: for (int particles = 0; particles < 4; ++particles) {
                switch (sideHit) {
                    case DOWN: {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.gaussian(0.1), -this.gaussian(0.1), this.gaussian(0.1));
                        continue block11;
                    }
                    case UP: 
                    case EAST: 
                    case SOUTH: {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                        continue block11;
                    }
                    case NORTH: {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.gaussian(0.1), this.gaussian(0.1), -this.gaussian(0.1));
                        continue block11;
                    }
                    case WEST: {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), -this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                        continue block11;
                    }
                }
            }
        }
    }

    void seekTarget() {
        Entity closestTarget = null;
        HashSet huntableEntitiesBlacklist = new HashSet((Collection)Settings.COMMON.items.seekerShot.huntableEntitiesBlacklist.get());
        List targetsList = this.m_9236_().m_6249_((Entity)this, new AABB(this.m_20185_() - 5.0, this.m_20186_() - 5.0, this.m_20189_() - 5.0, this.m_20185_() + 5.0, this.m_20186_() + 5.0, this.m_20189_() + 5.0), Mob.class::isInstance);
        Iterator iTarget = targetsList.iterator();
        double closestDistance = Double.MAX_VALUE;
        while (iTarget.hasNext()) {
            LivingEntity living;
            Entity currentTarget = (Entity)iTarget.next();
            String entityName = RegistryHelper.getRegistryName(currentTarget).toString();
            if (huntableEntitiesBlacklist.contains(entityName) || currentTarget == this.m_19749_() || !currentTarget.m_6084_() || currentTarget instanceof LivingEntity && (living = (LivingEntity)currentTarget).m_21223_() <= 0.0f || !((double)this.m_20270_(currentTarget) < closestDistance)) continue;
            closestDistance = this.m_20270_(currentTarget);
            closestTarget = currentTarget;
        }
        if (closestTarget != null && this.m_19749_() != null) {
            double x = closestTarget.m_20191_().f_82288_ + closestTarget.m_20191_().f_82291_;
            x /= 2.0;
            double y = closestTarget.m_20191_().f_82289_ + closestTarget.m_20191_().f_82292_;
            double z = closestTarget.m_20191_().f_82290_ + closestTarget.m_20191_().f_82293_;
            double trueX = this.m_20191_().f_82288_ + this.m_20191_().f_82291_;
            double trueY = this.m_20191_().f_82289_ + this.m_20191_().f_82292_;
            double trueZ = this.m_20191_().f_82290_ + this.m_20191_().f_82293_;
            Vec3 seekVector = new Vec3(x - (trueX /= 2.0), (y /= 2.0) - (trueY /= 2.0), (z /= 2.0) - (trueZ /= 2.0));
            seekVector = seekVector.m_82541_();
            this.m_20256_(seekVector.m_82542_(0.4, 0.4, 0.4));
            if (this.m_9236_().f_46443_) {
                this.m_6001_(this.m_20184_().m_7096_(), this.m_20184_().m_7098_(), this.m_20184_().m_7094_());
            }
        }
    }

    abstract int getRicochetMax();

    abstract int getDamageOfShot(LivingEntity var1);

    protected void onImpact(LivingEntity entityLiving) {
        if (!this.m_9236_().f_46443_) {
            if (entityLiving != this.m_19749_() || this.ticksInAir > 3) {
                this.doDamage(entityLiving);
            }
            this.spawnHitParticles(8);
            this.scheduledForDeath = true;
        }
    }

    protected void m_6532_(HitResult result) {
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)result).m_82443_();
            if (entity == this.m_19749_() || !(entity instanceof LivingEntity)) {
                return;
            }
            this.onImpact((LivingEntity)entity);
        } else if (result.m_6662_() == HitResult.Type.BLOCK) {
            this.groundImpact(((BlockHitResult)result).m_82434_());
        }
    }

    abstract void doBurstEffect(Direction var1);

    abstract void doFiringEffects();

    abstract void doFlightEffects();

    abstract void spawnHitParticles(int var1);

    public abstract ResourceLocation getShotTexture();

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

