/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.recipe;

import cofh.lib.api.fluid.IFluidStackHolder;
import cofh.lib.api.inventory.IItemStackHolder;
import cofh.lib.util.crafting.ComparableItemStack;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.CatalyzedRecipeManager;
import cofh.thermal.lib.util.managers.IRecipeManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.ThermalCatalyst;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import cofh.thermal.lib.util.recipes.internal.BaseMachineCatalyst;
import cofh.thermal.lib.util.recipes.internal.BaseMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.CatalyzedMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.DisenchantMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.IRecipeCatalyst;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mrthomas20121.thermal_extra.init.ThermalExtraRecipeTypes;
import mrthomas20121.thermal_extra.recipe.NitraticIgniterCatalyst;
import mrthomas20121.thermal_extra.recipe.NitraticIgniterRecipe;
import mrthomas20121.thermal_extra.util.CompoundMapWrapper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;

public class NitraticIgniterRecipeManager
extends AbstractManager
implements IRecipeManager,
CatalyzedRecipeManager {
    private static final NitraticIgniterRecipeManager INSTANCE = new NitraticIgniterRecipeManager();
    protected static final int DEFAULT_ENERGY = 3200;
    protected Map<CompoundMapWrapper, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected Map<ComparableItemStack, IRecipeCatalyst> catalystMap = new Object2ObjectOpenHashMap();
    protected Set<ComparableItemStack> validItems = new ObjectOpenHashSet();
    protected int maxInputItems = 3;
    protected int maxOutputItems = 4;
    protected int maxOutputFluids = 0;

    public static NitraticIgniterRecipeManager instance() {
        return INSTANCE;
    }

    private NitraticIgniterRecipeManager() {
        super(3200);
    }

    public void addRecipe(ThermalRecipe recipe, BaseMachineRecipe.RecipeType type) {
        switch (recipe.getInputItems().size()) {
            case 1: {
                for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).m_43908_()) {
                    this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.singletonList(firstInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids(), type);
                }
                break;
            }
            case 2: {
                for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).m_43908_()) {
                    for (ItemStack secondInput : ((Ingredient)recipe.getInputItems().get(1)).m_43908_()) {
                        this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(firstInput, secondInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids(), type);
                    }
                }
                break;
            }
            case 3: {
                for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).m_43908_()) {
                    for (ItemStack secondInput : ((Ingredient)recipe.getInputItems().get(1)).m_43908_()) {
                        for (ItemStack thirdInput : ((Ingredient)recipe.getInputItems().get(2)).m_43908_()) {
                            this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(firstInput, secondInput, thirdInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids(), type);
                        }
                    }
                }
                break;
            }
        }
    }

    public boolean validItem(ItemStack item) {
        return this.validItems.contains(NitraticIgniterRecipeManager.makeNBTComparable((ItemStack)item)) || this.validItems.contains(NitraticIgniterRecipeManager.makeComparable((ItemStack)item));
    }

    protected void clear() {
        this.recipeMap.clear();
        this.catalystMap.clear();
        this.validItems.clear();
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackHolder> inputSlots, List<? extends IFluidStackHolder> inputTanks) {
        if (inputSlots.isEmpty()) {
            return null;
        }
        ArrayList<ComparableItemStack> convertedItems = new ArrayList<ComparableItemStack>(this.maxInputItems);
        for (int i = 0; i < this.maxInputItems; ++i) {
            if (inputSlots.get(i).isEmpty()) continue;
            ComparableItemStack compStack = NitraticIgniterRecipeManager.makeNBTComparable((ItemStack)inputSlots.get(i).getItemStack());
            convertedItems.add(compStack);
        }
        if (convertedItems.isEmpty()) {
            return null;
        }
        IMachineRecipe ret = this.recipeMap.get(CompoundMapWrapper.of(convertedItems));
        if (ret == null) {
            convertedItems.clear();
            for (int i = 0; i < this.maxInputItems; ++i) {
                if (inputSlots.get(i).isEmpty()) continue;
                ComparableItemStack compStack = NitraticIgniterRecipeManager.makeComparable((ItemStack)inputSlots.get(i).getItemStack());
                convertedItems.add(compStack);
            }
            if (convertedItems.isEmpty()) {
                return null;
            }
            ret = this.recipeMap.get(CompoundMapWrapper.of(convertedItems));
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    protected IMachineRecipe addRecipe(int energy, float experience, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids, BaseMachineRecipe.RecipeType type) {
        void var10_16;
        if (inputItems.isEmpty() || outputItems.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        for (ItemStack itemStack : inputItems) {
            if (!itemStack.m_41619_()) continue;
            return null;
        }
        for (ItemStack itemStack : outputItems) {
            if (!itemStack.m_41619_()) continue;
            return null;
        }
        ArrayList<ComparableItemStack> convertedItems = new ArrayList<ComparableItemStack>(inputItems.size());
        for (ItemStack stack : inputItems) {
            if (inputItems.isEmpty()) continue;
            ComparableItemStack compStack = type == BaseMachineRecipe.RecipeType.DISENCHANT ? NitraticIgniterRecipeManager.makeComparable((ItemStack)stack) : NitraticIgniterRecipeManager.makeNBTComparable((ItemStack)stack);
            this.validItems.add(compStack);
            convertedItems.add(compStack);
        }
        energy = (int)((float)energy * this.getDefaultScale());
        if (type == BaseMachineRecipe.RecipeType.DISENCHANT) {
            DisenchantMachineRecipe disenchantMachineRecipe = new DisenchantMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        } else {
            InternalNitraticIgniterRecipe internalNitraticIgniterRecipe = new InternalNitraticIgniterRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        }
        this.recipeMap.put(CompoundMapWrapper.of(convertedItems), (IMachineRecipe)var10_16);
        return var10_16;
    }

    public List<ItemStack> getCatalysts() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(this.catalystMap.size());
        this.catalystMap.keySet().forEach(stack -> ret.add(stack.toItemStack()));
        return ret;
    }

    public IRecipeCatalyst getCatalyst(IItemStackHolder input) {
        return this.catalystMap.get(NitraticIgniterRecipeManager.makeNBTComparable((ItemStack)input.getItemStack()));
    }

    public IRecipeCatalyst getCatalyst(ItemStack input) {
        return this.catalystMap.get(NitraticIgniterRecipeManager.makeNBTComparable((ItemStack)input));
    }

    public void addCatalyst(ThermalCatalyst catalyst) {
        for (ItemStack ingredient : catalyst.getIngredient().m_43908_()) {
            this.addCatalyst(ingredient, catalyst.getPrimaryMod(), catalyst.getSecondaryMod(), catalyst.getEnergyMod(), catalyst.getMinChance(), catalyst.getUseChance());
        }
    }

    public IRecipeCatalyst addCatalyst(ItemStack input, float primaryMod, float secondaryMod, float energyMod, float minChance, float useChance) {
        if (input == null || input.m_41619_()) {
            return null;
        }
        BaseMachineCatalyst catalyst = new BaseMachineCatalyst(primaryMod, secondaryMod, energyMod, minChance, useChance);
        this.catalystMap.put(NitraticIgniterRecipeManager.makeNBTComparable((ItemStack)input), (IRecipeCatalyst)catalyst);
        return catalyst;
    }

    public boolean validCatalyst(ItemStack input) {
        return this.getCatalyst(input) != null;
    }

    public IRecipeCatalyst removeCatalyst(ItemStack input) {
        return this.catalystMap.remove(NitraticIgniterRecipeManager.makeNBTComparable((ItemStack)input));
    }

    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    public void refresh(RecipeManager recipeManager) {
        this.clear();
        List recipes = recipeManager.m_44013_((RecipeType)ThermalExtraRecipeTypes.NITRATIC_IGNITER.get());
        for (NitraticIgniterRecipe entry : recipes) {
            this.addRecipe(entry, BaseMachineRecipe.RecipeType.CATALYZED);
        }
        List catalysts = recipeManager.m_44013_((RecipeType)ThermalExtraRecipeTypes.NITRATIC_IGNITER_CATALYST.get());
        for (NitraticIgniterCatalyst entry : catalysts) {
            this.addCatalyst(entry);
        }
    }

    protected static class InternalNitraticIgniterRecipe
    extends CatalyzedMachineRecipe {
        public InternalNitraticIgniterRecipe(int energy, float experience, @Nullable List<ItemStack> inputItems, @Nullable List<FluidStack> inputFluids, @Nullable List<ItemStack> outputItems, @Nullable List<Float> chance, @Nullable List<FluidStack> outputFluids) {
            super(3, energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        }

        public IRecipeCatalyst getCatalyst(ItemStack input) {
            return NitraticIgniterRecipeManager.instance().getCatalyst(input);
        }
    }
}

