/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.recipe;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.fluid.IFluidStackHolder;
import cofh.lib.api.inventory.IItemStackHolder;
import cofh.lib.common.fluid.FluidIngredient;
import cofh.lib.common.fluid.FluidStackHolder;
import cofh.lib.util.crafting.ComparableItemStack;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.IRecipeManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.SimpleMachineRecipe;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mrthomas20121.thermal_extra.init.ThermalExtraRecipeTypes;
import mrthomas20121.thermal_extra.recipe.AdvancedRefineryRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class AdvancedRefineryRecipeManager
extends AbstractManager
implements IRecipeManager {
    private static final AdvancedRefineryRecipeManager INSTANCE = new AdvancedRefineryRecipeManager();
    protected static final int DEFAULT_ENERGY = 6000;
    protected Map<Integer, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected Set<Fluid> validFluids = new ObjectOpenHashSet();
    protected Set<ComparableItemStack> validItems = new ObjectOpenHashSet();
    protected int maxOutputItems = 3;
    protected int maxOutputFluids = 3;

    public static AdvancedRefineryRecipeManager instance() {
        return INSTANCE;
    }

    private AdvancedRefineryRecipeManager() {
        super(6000);
    }

    protected void clear() {
        this.recipeMap.clear();
        this.validFluids.clear();
        this.validItems.clear();
    }

    public boolean validRecipe(FluidStack input) {
        return this.getRecipe(input) != null;
    }

    protected IMachineRecipe getRecipe(FluidStack input) {
        return this.getRecipe(Collections.emptyList(), Collections.singletonList(new FluidStackHolder(input)));
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackHolder> inputSlots, List<? extends IFluidStackHolder> inputTanks) {
        if (inputTanks.isEmpty() || inputTanks.get(0).isEmpty()) {
            return null;
        }
        FluidStack inputFluid = inputTanks.get(0).getFluidStack();
        return this.recipeMap.get(FluidHelper.fluidHashcode((FluidStack)inputFluid));
    }

    public void addRecipe(ThermalRecipe recipe) {
        if (recipe.getInputFluids().isEmpty()) {
            return;
        }
        for (FluidStack fluidInput : ((FluidIngredient)recipe.getInputFluids().get(0)).getFluids()) {
            this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.emptyList(), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
        }
    }

    protected IMachineRecipe addRecipe(int energy, float experience, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputFluids.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        FluidStack input = inputFluids.get(0);
        if (input.isEmpty()) {
            return null;
        }
        for (ItemStack itemStack : outputItems) {
            if (!itemStack.m_41619_()) continue;
            return null;
        }
        for (FluidStack fluidStack : outputFluids) {
            if (!fluidStack.isEmpty()) continue;
            return null;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        SimpleMachineRecipe recipe = new SimpleMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put(FluidHelper.fluidHashcode((FluidStack)input), (IMachineRecipe)recipe);
        return recipe;
    }

    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    public void refresh(RecipeManager recipeManager) {
        this.clear();
        List recipes = recipeManager.m_44013_((RecipeType)ThermalExtraRecipeTypes.ADVANCED_REFINERY.get());
        for (AdvancedRefineryRecipe entry : recipes) {
            this.addRecipe(entry);
        }
    }
}

