/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra;

import mrthomas20121.thermal_extra.init.ThermalExtraItems;
import mrthomas20121.thermal_extra.init.ThermalExtraTags;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="thermal_extra")
public class CommonEvents {
    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ThermalExtraItems::augmentFlags);
    }

    @SubscribeEvent
    public static void visibilityEvent(LivingEvent.LivingVisibilityEvent event) {
        Entity lookingEntity = event.getLookingEntity();
        if (lookingEntity == null) {
            return;
        }
        if (CommonEvents.isFullArmor(ThermalExtraTags.Items.TWINITE_ARMOR, event.getEntity()) && lookingEntity.m_6095_().equals(EntityType.f_20551_)) {
            event.modifyVisibility((double)0.2f);
        }
    }

    @SubscribeEvent
    public static void criticalHit(CriticalHitEvent event) {
        Player player;
        if (!event.isCanceled() && (player = event.getEntity()).m_21205_().m_204117_(ThermalExtraTags.Items.DRAGONSTEEL_TOOLS) && event.isVanillaCritical() && player.m_9236_().m_213780_().m_188501_() <= 0.3f) {
            event.setDamageModifier(2.0f);
        }
    }

    @SubscribeEvent
    public static void enderPearlEvent(EntityTeleportEvent.EnderPearl event) {
        if (CommonEvents.isFullArmor(ThermalExtraTags.Items.ENDERIUM_ARMOR, (LivingEntity)event.getPlayer())) {
            event.setAttackDamage(0.0f);
        }
    }

    @SubscribeEvent
    public static void takeDamage(LivingHurtEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && CommonEvents.isFullArmor(ThermalExtraTags.Items.SHELLITE_ARMOR, (LivingEntity)(player = (Player)livingEntity)) && event.getSource().m_269533_(DamageTypeTags.f_268549_)) {
            event.setAmount(event.getAmount() * 0.2f);
        } else {
            livingEntity = event.getSource().m_7640_();
            if (livingEntity instanceof LivingEntity) {
                LivingEntity living = livingEntity;
                LivingEntity target = event.getEntity();
                if (living.m_21093_(stack -> stack.m_204117_(ThermalExtraTags.Items.ENDERIUM_TOOLS)) && CommonEvents.isInTag(target.m_6095_(), ThermalExtraTags.EntityTypes.ENDER_MOBS)) {
                    event.setAmount(event.getAmount() * 1.5f);
                }
            }
        }
    }

    private static boolean isInTag(EntityType<?> entityType, TagKey<EntityType<?>> tag) {
        return ForgeRegistries.ENTITY_TYPES.tags().getTag(tag).contains(entityType);
    }

    private static String getEntityName(EntityType<?> entityType) {
        ResourceLocation loc = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        if (loc != null) {
            return loc.m_135815_();
        }
        return "empty";
    }

    private static boolean isFullArmor(TagKey<Item> armor, LivingEntity entity) {
        boolean bool = true;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.equals((Object)EquipmentSlot.MAINHAND) || slot.equals((Object)EquipmentSlot.OFFHAND)) continue;
            if (!entity.m_6844_(slot).m_204117_(armor)) {
                bool = false;
            }
            if (!bool) break;
        }
        return bool;
    }
}

