/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.colored_water.recipe;

import com.cozary.colored_water.items.ModItems;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class ContainerCraftingRecipe
extends ShapelessRecipe {
    public static final Map<Item, Item> HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET = Map.ofEntries(Map.entry(Items.f_151055_, Items.f_42446_), Map.entry(Items.f_151057_, Items.f_42446_), Map.entry(Items.f_42458_, Items.f_42446_), Map.entry(Items.f_42456_, Items.f_42446_), Map.entry(Items.f_42457_, Items.f_42446_), Map.entry(Items.f_42459_, Items.f_42446_), Map.entry(Items.f_42718_, Items.f_42399_), Map.entry(Items.f_42400_, Items.f_42399_), Map.entry(Items.f_42699_, Items.f_42399_), Map.entry(Items.f_42734_, Items.f_42399_), Map.entry(Items.f_42589_, Items.f_42590_), Map.entry(Items.f_42736_, Items.f_42590_), Map.entry(Items.f_42739_, Items.f_42590_), Map.entry(Items.f_42612_, Items.f_42590_));
    private final String group;
    private final ItemStack recipeOutput;
    private final NonNullList<Ingredient> recipeItems;

    public ContainerCraftingRecipe(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        super(idIn, groupIn, CraftingBookCategory.MISC, recipeOutputIn, recipeItemsIn);
        this.group = groupIn;
        this.recipeOutput = recipeOutputIn;
        this.recipeItems = recipeItemsIn;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModItems.CONTAINER_CRAFTING_RECIPE.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public static class Serializer
    implements RecipeSerializer<ContainerCraftingRecipe> {
        private static NonNullList<Ingredient> getIngredients(JsonArray jsonElements) {
            NonNullList defaultedList = NonNullList.m_122779_();
            for (int i = 0; i < jsonElements.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonElements.get(i));
                if (ingredient.m_43947_()) continue;
                defaultedList.add((Object)ingredient);
            }
            return defaultedList;
        }

        public ContainerCraftingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> DefaultedList = Serializer.getIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (DefaultedList.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new ContainerCraftingRecipe(recipeId, s, itemstack, DefaultedList);
        }

        public ContainerCraftingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String s = buffer.m_130136_(Short.MAX_VALUE);
            int i = buffer.m_130242_();
            NonNullList defaultedList = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < defaultedList.size(); ++j) {
                defaultedList.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack itemstack = buffer.m_130267_();
            return new ContainerCraftingRecipe(recipeId, s, itemstack, (NonNullList<Ingredient>)defaultedList);
        }

        public void toNetwork(FriendlyByteBuf buffer, ContainerCraftingRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.recipeOutput);
        }
    }
}

