/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.grid.energy;

import cofh.lib.common.energy.IRedstoneFluxStorage;
import cofh.thermal.dynamics.api.grid.IGridType;
import cofh.thermal.dynamics.api.helper.GridHelper;
import cofh.thermal.dynamics.grid.Grid;
import cofh.thermal.dynamics.grid.energy.EnergyGridNode;
import cofh.thermal.dynamics.grid.energy.GridEnergyStorage;
import cofh.thermal.dynamics.init.registries.TDynGrids;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class EnergyGrid
extends Grid<EnergyGrid, EnergyGridNode>
implements IRedstoneFluxStorage {
    protected static final long MIN_CAPACITY = 10000L;
    protected static final long NODE_CAPACITY = 400L;
    protected final GridEnergyStorage storage = new GridEnergyStorage(400L);
    protected LazyOptional<?> energyCap = LazyOptional.empty();
    protected EnergyGridNode[] distArray = new EnergyGridNode[0];
    protected int distIndex = 0;

    public EnergyGrid(UUID id, Level world) {
        super((IGridType)TDynGrids.ENERGY_GRID.get(), id, world);
    }

    @Override
    public EnergyGridNode newNode() {
        return new EnergyGridNode(this);
    }

    @Override
    public void tick() {
        int i;
        this.storage.tick();
        if (this.distArray.length != this.getNodes().size()) {
            this.distArray = this.getNodes().values().toArray(new EnergyGridNode[0]);
        }
        int curIndex = this.distIndex;
        if (this.distIndex >= this.distArray.length) {
            this.distIndex = 0;
        }
        for (i = this.distIndex; i < this.distArray.length; ++i) {
            if (!this.rrNodeTick(curIndex, i)) continue;
            this.storage.postTick();
            return;
        }
        for (i = 0; i < this.distIndex; ++i) {
            if (!this.rrNodeTick(curIndex, i)) continue;
            this.storage.postTick();
            return;
        }
        ++this.distIndex;
        this.storage.postTick();
    }

    private boolean rrNodeTick(int curIndex, int i) {
        if (!this.distArray[i].isLoaded()) {
            return false;
        }
        this.distArray[i].distributionTick();
        if (this.getEnergy() <= 0L) {
            this.distIndex = i + 1;
            if (curIndex == this.distIndex) {
                --this.distIndex;
            }
            return true;
        }
        return false;
    }

    @Override
    public void onModified() {
        this.distArray = new EnergyGridNode[0];
        this.storage.setBaseCapacity(Math.max(10000L, (long)this.getNodes().size() * 400L));
        super.onModified();
    }

    @Override
    public void onMerge(EnergyGrid from) {
        this.storage.setBaseCapacity(Math.max(10000L, (long)this.getNodes().size() * 400L));
        this.storage.setCapacity(this.getCapacity() + from.getCapacity());
        this.storage.setEnergy(this.storage.getEnergy() + from.getEnergy());
        this.refreshCapabilities();
        from.refreshCapabilities();
    }

    @Override
    public void onSplit(List<EnergyGrid> others) {
        int totalNodes = 0;
        for (EnergyGrid grid : others) {
            int gridNodes = grid.getNodes().size();
            totalNodes += grid.getNodes().size();
            grid.setBaseCapacity(Math.max(10000L, (long)gridNodes * 400L));
            grid.setCapacity(this.getCapacity());
            grid.refreshCapabilities();
        }
        this.refreshCapabilities();
        if (this.getEnergy() <= 0L) {
            return;
        }
        long energyPerNode = this.getEnergy() / (long)totalNodes;
        long remEnergy = this.getEnergy() % (long)totalNodes;
        for (EnergyGrid grid : others) {
            int gridNodes = grid.getNodes().size();
            grid.setEnergy(energyPerNode * (long)gridNodes);
        }
        others.get(0).setEnergy(others.get(0).getEnergy() + remEnergy);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        this.storage.write(tag);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.storage.deserializeNBT(nbt);
    }

    @Override
    public boolean canConnectOnSide(BlockEntity tile, @Nullable Direction dir) {
        if (GridHelper.getGridHost(tile) != null) {
            return false;
        }
        if (dir != null) {
            return tile.getCapability(ThermalEnergyHelper.getBaseEnergySystem(), dir).isPresent();
        }
        return false;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == ThermalEnergyHelper.getBaseEnergySystem()) {
            if (!this.energyCap.isPresent()) {
                this.energyCap = LazyOptional.of(() -> this.storage);
            }
            return this.energyCap.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public void refreshCapabilities() {
        this.energyCap.invalidate();
    }

    public long getCapacity() {
        return this.storage.getCapacity();
    }

    public long getEnergy() {
        return this.storage.getEnergy();
    }

    public void setBaseCapacity(long capacity) {
        this.storage.setBaseCapacity(capacity);
    }

    public void setCapacity(long capacity) {
        this.storage.setCapacity(capacity);
    }

    public void setEnergy(long energy) {
        this.storage.setEnergy(energy);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.storage.canExtract();
    }

    public boolean canReceive() {
        return this.storage.canReceive();
    }
}

