/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.attachment;

import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.attachment.EmptyAttachment;
import cofh.thermal.dynamics.attachment.EnergyLimiterAttachment;
import cofh.thermal.dynamics.attachment.FluidFilterAttachment;
import cofh.thermal.dynamics.attachment.FluidServoAttachment;
import cofh.thermal.dynamics.attachment.FluidTurboServoAttachment;
import cofh.thermal.dynamics.attachment.IAttachment;
import cofh.thermal.dynamics.attachment.IAttachmentFactory;
import cofh.thermal.dynamics.init.registries.TDynGrids;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class AttachmentRegistry {
    public static final IAttachmentFactory<IAttachment> FILTER_FACTORY = (nbt, duct, side) -> {
        if (duct.getGridType() == TDynGrids.FLUID_GRID.get()) {
            return new FluidFilterAttachment(duct, side).read(nbt);
        }
        return EmptyAttachment.INSTANCE;
    };
    public static final IAttachmentFactory<IAttachment> SERVO_FACTORY = (nbt, duct, side) -> {
        if (duct.getGridType() == TDynGrids.FLUID_GRID.get()) {
            return new FluidServoAttachment(duct, side).read(nbt);
        }
        return EmptyAttachment.INSTANCE;
    };
    public static final IAttachmentFactory<IAttachment> TURBO_SERVO_FACTORY = (nbt, duct, side) -> {
        if (duct.getGridType() == TDynGrids.FLUID_GRID.get()) {
            return new FluidTurboServoAttachment(duct, side).read(nbt);
        }
        return EmptyAttachment.INSTANCE;
    };
    protected static final Map<String, IAttachmentFactory<? extends IAttachment>> ATTACHMENT_FACTORY_MAP = new Object2ObjectOpenHashMap();

    public static boolean registerAttachmentFactory(String type, IAttachmentFactory<?> factory) {
        if (type == null || type.isEmpty() || factory == null) {
            return false;
        }
        ATTACHMENT_FACTORY_MAP.put(type, factory);
        return true;
    }

    public static IAttachment getAttachment(String type, CompoundTag nbt, IDuct<?, ?> duct, Direction side) {
        if (ATTACHMENT_FACTORY_MAP.containsKey(type)) {
            return ATTACHMENT_FACTORY_MAP.get(type).createAttachment(nbt, duct, side);
        }
        return EmptyAttachment.INSTANCE;
    }

    static {
        AttachmentRegistry.registerAttachmentFactory("energy_limiter", EnergyLimiterAttachment.FACTORY);
        AttachmentRegistry.registerAttachmentFactory("filter", FILTER_FACTORY);
        AttachmentRegistry.registerAttachmentFactory("servo", SERVO_FACTORY);
        AttachmentRegistry.registerAttachmentFactory("turbo_servo", TURBO_SERVO_FACTORY);
    }
}

