/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;

public class FilteredIngredientCollectionIterator<T, M>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final IIngredientMatcher<T, M> matcher;
    private final T instance;
    private final M matchCondition;
    private T next;

    public FilteredIngredientCollectionIterator(Iterable<T> iterable, IIngredientMatcher<T, M> matcher, T instance, M matchCondition) {
        this(iterable.iterator(), matcher, instance, matchCondition);
    }

    public FilteredIngredientCollectionIterator(Iterator<T> iterator, IIngredientMatcher<T, M> matcher, T instance, M matchCondition) {
        this.iterator = iterator;
        this.matcher = matcher;
        this.instance = instance;
        this.matchCondition = matchCondition;
        this.next = null;
    }

    protected T findNext() {
        while (this.iterator.hasNext()) {
            T next = this.iterator.next();
            if (!this.matcher.matches(this.instance, next, this.matchCondition)) continue;
            return next;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.next = this.findNext();
        }
        return this.next != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Tried reading a finished FilteredIngredientCollectionIterator");
        }
        T next = this.next;
        this.next = null;
        return next;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

