/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;

public class ManagedString
extends AbstractManagedData<String> {
    private String value;
    protected Function<String, String> validator = null;

    public ManagedString(String name, String defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
    }

    public ManagedString(String name, DataFlags ... flags) {
        this(name, "", flags);
    }

    public String set(String value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            String prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public String get() {
        return this.value;
    }

    public ManagedString setValidator(Function<String, String> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeString(this.value);
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readString();
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundTag compound) {
        compound.m_128359_(this.name, this.value);
    }

    @Override
    public void fromNBT(CompoundTag compound) {
        this.value = compound.m_128461_(this.name);
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }
}

