/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.handlers;

import com.brandon3055.brandonscore.handlers.IProcess;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.covers1624.quack.util.CrashLock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;

public class ProcessHandler {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    private static List<IProcess> processes = new ArrayList<IProcess>();
    private static List<IProcess> newProcesses = new ArrayList<IProcess>();

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.addListener(ProcessHandler::onServerTick);
        MinecraftForge.EVENT_BUS.addListener(ProcessHandler::onServerStop);
    }

    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Iterator<IProcess> i = processes.iterator();
            while (i.hasNext()) {
                IProcess process = i.next();
                if (process.isDead()) {
                    i.remove();
                    continue;
                }
                process.updateProcess();
            }
            if (!newProcesses.isEmpty()) {
                processes.addAll(newProcesses);
                newProcesses.clear();
            }
        }
    }

    public static void clearHandler() {
        processes.clear();
        newProcesses.clear();
    }

    public static void addProcess(IProcess process) {
        newProcesses.add(process);
    }

    public static void onServerStop(ServerStoppedEvent event) {
        ProcessHandler.clearHandler();
    }
}

