/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.hud;

import codechicken.lib.gui.modular.lib.GuiRender;
import com.brandon3055.brandonscore.api.hud.AbstractHudElement;
import com.brandon3055.brandonscore.api.hud.IHudBlock;
import com.brandon3055.brandonscore.api.hud.IHudDisplay;
import com.brandon3055.brandonscore.api.hud.IHudItem;
import com.brandon3055.brandonscore.api.math.Vector2;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class HudDataElement
extends AbstractHudElement {
    private final boolean iHudItem;
    private final boolean iHudBlock;
    private IHudDisplay activeHud = null;
    private List<Component> displayList = new ArrayList<Component>();

    public HudDataElement(Vector2 defaultPos, boolean iHudItem, boolean iHudBlock) {
        super(defaultPos);
        this.iHudItem = iHudItem;
        this.iHudBlock = iHudBlock;
    }

    @Override
    public void tick(boolean configuring) {
        HitResult traceResult;
        this.activeHud = null;
        this.displayList.clear();
        this.width = 145.0;
        this.height = 30.0;
        if (!this.enabled) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (this.iHudBlock && (traceResult = Minecraft.m_91087_().f_91074_.m_19907_(5.0, 0.0f, false)) instanceof BlockHitResult && traceResult.m_6662_() != HitResult.Type.MISS) {
            BlockPos pos = ((BlockHitResult)traceResult).m_82425_();
            BlockState state = player.m_9236_().m_8055_(pos);
            BlockEntity tile = player.m_9236_().m_7702_(pos);
            if (state.m_60734_() instanceof IHudBlock) {
                this.activeHud = (IHudBlock)state.m_60734_();
            } else if (tile instanceof IHudBlock) {
                this.activeHud = (IHudBlock)tile;
            }
            if (this.activeHud != null && ((IHudBlock)this.activeHud).shouldDisplayHudText(player.m_9236_(), pos, (Player)player)) {
                ((IHudBlock)this.activeHud).generateHudText(player.m_9236_(), pos, (Player)player, this.displayList);
                if (this.displayList.isEmpty()) {
                    this.activeHud = null;
                }
            } else {
                this.activeHud = null;
            }
        }
        if (this.iHudItem && this.activeHud == null) {
            ItemStack stack = player.m_21205_();
            if (stack.m_41619_() || !(stack.m_41720_() instanceof IHudItem) || !((IHudItem)stack.m_41720_()).shouldDisplayHudText(stack, (Player)player)) {
                stack = player.m_21206_();
            }
            if (!stack.m_41619_() && stack.m_41720_() instanceof IHudItem) {
                this.activeHud = (IHudItem)stack.m_41720_();
                if (((IHudItem)this.activeHud).shouldDisplayHudText(stack, (Player)player)) {
                    ((IHudItem)this.activeHud).generateHudText(stack, (Player)player, this.displayList);
                    if (this.displayList.isEmpty()) {
                        this.activeHud = null;
                    }
                } else {
                    this.activeHud = null;
                }
            }
        }
        if (this.activeHud != null) {
            Minecraft mc = Minecraft.m_91087_();
            this.width = this.activeHud.computeHudWidth(mc, this.displayList);
            this.height = this.activeHud.computeHudHeight(mc, this.displayList);
        }
    }

    @Override
    public void render(GuiRender render, float partialTicks, boolean configuring) {
        if (!this.enabled || this.activeHud == null && !configuring) {
            return;
        }
        MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
        render.pose().m_85837_(this.xPos(), this.yPos(), 0.0);
        if (this.activeHud == null) {
            render.toolTipBackground(0.0, 0.0, this.width(), this.height());
            getter.m_109911_();
            return;
        }
        this.activeHud.renderHudBackground(render, this.width(), this.height(), this.displayList);
        getter.m_109911_();
        this.activeHud.renderHudContent(render, this.width(), this.height(), this.displayList);
    }
}

