/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client;

import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.utils.BCProfiler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.covers1624.quack.util.CrashLock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ProcessHandlerClient {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    private static List<IProcess> processes = new ArrayList<IProcess>();
    private static List<IProcess> newProcesses = new ArrayList<IProcess>();
    private static List<IProcess> persistentProcesses = new ArrayList<IProcess>();
    private static List<IProcess> newPersistentProcesses = new ArrayList<IProcess>();
    private static final Queue<Runnable> syncTasks = new ConcurrentLinkedQueue<Runnable>();

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.register((Object)new ProcessHandlerClient());
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            IProcess process;
            BCProfiler.TICK.start("process_handler");
            while (!syncTasks.isEmpty()) {
                syncTasks.poll().run();
            }
            Iterator<IProcess> i = processes.iterator();
            while (i.hasNext()) {
                process = i.next();
                if (process.isDead()) {
                    i.remove();
                    continue;
                }
                process.updateProcess();
            }
            if (!newProcesses.isEmpty()) {
                processes.addAll(newProcesses);
                newProcesses.clear();
            }
            i = persistentProcesses.iterator();
            while (i.hasNext()) {
                process = i.next();
                if (process.isDead()) {
                    i.remove();
                    continue;
                }
                process.updateProcess();
            }
            if (!newPersistentProcesses.isEmpty()) {
                persistentProcesses.addAll(newPersistentProcesses);
                newPersistentProcesses.clear();
            }
            BCProfiler.TICK.stop();
        }
    }

    @SubscribeEvent
    public void onWorldClose(LevelEvent.Unload event) {
        processes.clear();
        newProcesses.clear();
    }

    public static void addProcess(IProcess process) {
        newProcesses.add(process);
    }

    public static void addPersistentProcess(IProcess process) {
        newPersistentProcesses.add(process);
    }

    public static void syncTask(Runnable task) {
        syncTasks.add(task);
    }
}

