/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.commands.client;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.Optional;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.registries.ForgeRegistries;

public class DumpMissingEmc {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext context) {
        return Commands.m_82127_((String)"dumpmissingemc").executes(DumpMissingEmc::execute);
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) {
        ItemInfo itemInfo2;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        HashSet allItems = new HashSet(ForgeRegistries.ITEMS.getValues());
        allItems.remove(Items.f_41852_);
        HashSet<ItemInfo> missing = new HashSet<ItemInfo>();
        CreativeModeTab tab = CreativeModeTabRegistry.getTab((ResourceLocation)CreativeModeTabs.f_256750_.m_135782_());
        if (tab != null) {
            if (tab.m_261235_().isEmpty()) {
                DumpMissingEmc.initTab(tab);
            }
            for (ItemStack stack : tab.m_261235_()) {
                if (stack.m_41619_()) continue;
                itemInfo2 = ItemInfo.fromStack(stack);
                if (EMCHelper.getEmcValue(itemInfo2) == 0L) {
                    missing.add(itemInfo2);
                    continue;
                }
                allItems.remove(stack.m_41720_());
            }
        }
        for (Item item : allItems) {
            itemInfo2 = ItemInfo.fromItem((ItemLike)item);
            if (EMCHelper.getEmcValue(itemInfo2) != 0L) continue;
            missing.add(itemInfo2);
        }
        int missingCount = missing.size();
        if (missingCount == 0) {
            source.m_288197_(() -> PELang.DUMP_MISSING_EMC_NONE_MISSING.translate(new Object[0]), true);
        } else {
            if (missingCount == 1) {
                source.m_288197_(() -> PELang.DUMP_MISSING_EMC_ONE_MISSING.translate(new Object[0]), true);
            } else {
                source.m_288197_(() -> PELang.DUMP_MISSING_EMC_MULTIPLE_MISSING.translate(missingCount), true);
            }
            for (ItemInfo itemInfo2 : missing) {
                PECore.LOGGER.info(itemInfo2.toString());
            }
        }
        return missingCount;
    }

    private static void initTab(CreativeModeTab tab) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ != null) {
            FeatureFlagSet features = Optional.ofNullable(minecraft.f_91074_).map(p -> p.f_108617_.m_247016_()).orElse(FeatureFlags.f_244332_);
            boolean hasPermissions = (Boolean)minecraft.f_91066_.m_257871_().m_231551_() != false || minecraft.f_91074_ != null && minecraft.f_91074_.m_36337_();
            CreativeModeTab.ItemDisplayParameters displayParameters = new CreativeModeTab.ItemDisplayParameters(features, hasPermissions, (HolderLookup.Provider)minecraft.f_91073_.m_9598_());
            try {
                tab.m_269498_(displayParameters);
            }
            catch (LinkageError | RuntimeException throwable) {
                // empty catch block
            }
        }
    }
}

