/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.impl.capability.KnowledgeImpl;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class TransmutationOffline {
    private static final IKnowledgeProvider NOT_FOUND_PROVIDER = TransmutationOffline.immutableCopy(KnowledgeImpl.getDefault());
    private static final Map<UUID, IKnowledgeProvider> cachedKnowledgeProviders = new HashMap<UUID, IKnowledgeProvider>();

    public static void cleanAll() {
        cachedKnowledgeProviders.clear();
    }

    public static void clear(UUID playerUUID) {
        cachedKnowledgeProviders.remove(playerUUID);
    }

    static IKnowledgeProvider forPlayer(UUID playerUUID) {
        if (!cachedKnowledgeProviders.containsKey(playerUUID) && !TransmutationOffline.cacheOfflineData(playerUUID)) {
            cachedKnowledgeProviders.put(playerUUID, NOT_FOUND_PROVIDER);
        }
        return cachedKnowledgeProviders.get(playerUUID);
    }

    private static boolean cacheOfflineData(UUID playerUUID) {
        File player;
        Preconditions.checkState((Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER ? 1 : 0) != 0, (Object)"CRITICAL: Trying to read filesystem on client!!");
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        File playerData = server.m_129843_(LevelResource.f_78176_).toFile();
        if (playerData.exists() && (player = new File(playerData, playerUUID.toString() + ".dat")).exists() && player.isFile()) {
            boolean bl;
            FileInputStream in = new FileInputStream(player);
            try {
                CompoundTag playerDat = NbtIo.m_128939_((InputStream)in);
                CompoundTag knowledgeProvider = playerDat.m_128469_("ForgeCaps").m_128469_(KnowledgeImpl.Provider.NAME.toString());
                IKnowledgeProvider provider = KnowledgeImpl.getDefault();
                provider.deserializeNBT((Tag)knowledgeProvider);
                cachedKnowledgeProviders.put(playerUUID, TransmutationOffline.immutableCopy(provider));
                PECore.debugLog("Caching offline data for UUID: {}", playerUUID);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    PECore.LOGGER.warn("Failed to cache offline data for API calls for UUID: {}", (Object)playerUUID);
                }
            }
            in.close();
            return bl;
        }
        return false;
    }

    private static IKnowledgeProvider immutableCopy(final IKnowledgeProvider toCopy) {
        return new IKnowledgeProvider(){
            final Set<ItemInfo> immutableKnowledge;
            final IItemHandlerModifiable immutableInputLocks;
            {
                this.immutableKnowledge = ImmutableSet.copyOf(toCopy.getKnowledge());
                this.immutableInputLocks = ItemHelper.immutableCopy(toCopy.getInputAndLocks());
            }

            @Override
            public boolean hasFullKnowledge() {
                return toCopy.hasFullKnowledge();
            }

            @Override
            public void setFullKnowledge(boolean fullKnowledge) {
            }

            @Override
            public void clearKnowledge() {
            }

            @Override
            public boolean hasKnowledge(@NotNull ItemInfo info) {
                return toCopy.hasKnowledge(info);
            }

            @Override
            public boolean addKnowledge(@NotNull ItemInfo info) {
                return false;
            }

            @Override
            public boolean removeKnowledge(@NotNull ItemInfo info) {
                return false;
            }

            @Override
            @NotNull
            public Set<ItemInfo> getKnowledge() {
                return this.immutableKnowledge;
            }

            @Override
            @NotNull
            public IItemHandler getInputAndLocks() {
                return this.immutableInputLocks;
            }

            @Override
            public BigInteger getEmc() {
                return toCopy.getEmc();
            }

            @Override
            public void setEmc(BigInteger emc) {
            }

            @Override
            public void sync(@NotNull ServerPlayer player) {
                toCopy.sync(player);
            }

            @Override
            public void syncEmc(@NotNull ServerPlayer player) {
                toCopy.syncEmc(player);
            }

            @Override
            public void syncKnowledgeChange(@NotNull ServerPlayer player, ItemInfo change, boolean learned) {
                toCopy.syncKnowledgeChange(player, change, learned);
            }

            @Override
            public void syncInputAndLocks(@NotNull ServerPlayer player, List<Integer> slotsChanged, IKnowledgeProvider.TargetUpdateType updateTargets) {
                toCopy.syncInputAndLocks(player, slotsChanged, updateTargets);
            }

            @Override
            public void receiveInputsAndLocks(Map<Integer, ItemStack> changes) {
            }

            public CompoundTag serializeNBT() {
                return (CompoundTag)toCopy.serializeNBT();
            }

            public void deserializeNBT(CompoundTag nbt) {
            }
        };
    }
}

