/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.registration.impl;

import moze_intel.projecte.gameObjs.registration.WrappedDeferredRegister;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registration.impl.BlockRegistryObject;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BlockEntityTypeDeferredRegister
extends WrappedDeferredRegister<BlockEntityType<?>> {
    public BlockEntityTypeDeferredRegister(String modid) {
        super(ForgeRegistries.BLOCK_ENTITY_TYPES, modid);
    }

    public <BE extends BlockEntity> BlockEntityTypeBuilder<BE> builder(BlockRegistryObject<?, ?> block, BlockEntityType.BlockEntitySupplier<? extends BE> factory) {
        return new BlockEntityTypeBuilder<BE>(block, factory);
    }

    public class BlockEntityTypeBuilder<BE extends BlockEntity> {
        private final BlockRegistryObject<?, ?> block;
        private final BlockEntityType.BlockEntitySupplier<? extends BE> factory;
        @Nullable
        private BlockEntityTicker<BE> clientTicker;
        @Nullable
        private BlockEntityTicker<BE> serverTicker;

        private BlockEntityTypeBuilder(BlockRegistryObject<?, ?> block, BlockEntityType.BlockEntitySupplier<? extends BE> factory) {
            this.block = block;
            this.factory = factory;
        }

        public BlockEntityTypeBuilder<BE> clientTicker(BlockEntityTicker<BE> ticker) {
            if (this.clientTicker != null) {
                throw new IllegalStateException("Client ticker may only be set once.");
            }
            this.clientTicker = ticker;
            return this;
        }

        public BlockEntityTypeBuilder<BE> serverTicker(BlockEntityTicker<BE> ticker) {
            if (this.serverTicker != null) {
                throw new IllegalStateException("Server ticker may only be set once.");
            }
            this.serverTicker = ticker;
            return this;
        }

        public BlockEntityTypeBuilder<BE> commonTicker(BlockEntityTicker<BE> ticker) {
            return this.clientTicker(ticker).serverTicker(ticker);
        }

        public BlockEntityTypeRegistryObject<BE> build() {
            BlockEntityTypeRegistryObject<BE> registryObject = new BlockEntityTypeRegistryObject<BE>(null);
            registryObject.clientTicker(this.clientTicker).serverTicker(this.serverTicker);
            return (BlockEntityTypeRegistryObject)BlockEntityTypeDeferredRegister.this.register(this.block.getInternalRegistryName(), () -> {
                Block[] validBlocks;
                BlockRegistryObject<?, ?> patt2485$temp = this.block;
                if (patt2485$temp instanceof BlockRegistryObject.WallOrFloorBlockRegistryObject) {
                    BlockRegistryObject.WallOrFloorBlockRegistryObject wallOrFloorBlock = (BlockRegistryObject.WallOrFloorBlockRegistryObject)patt2485$temp;
                    validBlocks = new Block[]{this.block.getBlock(), wallOrFloorBlock.getWallBlock()};
                } else {
                    validBlocks = new Block[]{this.block.getBlock()};
                }
                return BlockEntityType.Builder.m_155273_(this.factory, (Block[])validBlocks).m_58966_(null);
            }, registryObject::setRegistryObject);
        }
    }
}

