/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.customRecipes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import moze_intel.projecte.gameObjs.items.PhilosophersStone;
import moze_intel.projecte.gameObjs.registries.PERecipeSerializers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class PhiloStoneSmeltingRecipe
extends CustomRecipe {
    public PhiloStoneSmeltingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level level) {
        return !this.getMatchingRecipes(inv, level).isEmpty();
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registryAccess) {
        Set<SmeltingRecipe> matchingRecipes = this.getMatchingRecipes(inv, (Level)ServerLifecycleHooks.getCurrentServer().m_129783_());
        if (matchingRecipes.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack output = ((SmeltingRecipe)matchingRecipes.stream().findFirst().get()).m_8043_(registryAccess).m_41777_();
        output.m_41764_(output.m_41613_() * 7);
        return output;
    }

    private Set<SmeltingRecipe> getMatchingRecipes(CraftingContainer inv, @NotNull Level level) {
        ArrayList<ItemStack> philoStones = new ArrayList<ItemStack>();
        ArrayList<ItemStack> coals = new ArrayList<ItemStack>();
        ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            allItems.add(stack);
            if (allItems.size() > 9) {
                return Collections.emptySet();
            }
            if (item instanceof PhilosophersStone) {
                philoStones.add(stack);
            }
            if (!stack.m_204117_(ItemTags.f_13160_)) continue;
            coals.add(stack);
        }
        if (allItems.size() == 9) {
            for (ItemStack philoStone : philoStones) {
                for (ItemStack coal : coals) {
                    if (philoStone == coal) continue;
                    HashSet<SmeltingRecipe> matchingRecipes = new HashSet<SmeltingRecipe>();
                    for (ItemStack stack : allItems) {
                        if (stack == philoStone || stack == coal) continue;
                        SimpleContainer furnaceInput = new SimpleContainer(new ItemStack[]{stack});
                        if (!(matchingRecipes.isEmpty() ? !matchingRecipes.addAll(level.m_7465_().m_44056_(RecipeType.f_44108_, (Container)furnaceInput, level)) : matchingRecipes.removeIf(recipe -> !recipe.m_5818_((Container)furnaceInput, level)) && matchingRecipes.isEmpty())) continue;
                        return Collections.emptySet();
                    }
                    if (matchingRecipes.isEmpty()) continue;
                    return matchingRecipes;
                }
            }
        }
        return Collections.emptySet();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 9;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)PERecipeSerializers.PHILO_STONE_SMELTING.get();
    }
}

