/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.nbt.processor;

import java.util.Map;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.nbt.INBTProcessor;
import moze_intel.projecte.api.nbt.NBTProcessor;
import moze_intel.projecte.utils.ItemInfoHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NBTProcessor
public class EnchantmentProcessor
implements INBTProcessor {
    private static final long ENCH_EMC_BONUS = 5000L;

    @Override
    public String getName() {
        return "EnchantmentProcessor";
    }

    @Override
    public String getDescription() {
        return "Increases the EMC value to take into account any enchantments on an item.";
    }

    @Override
    public boolean isAvailable() {
        return false;
    }

    @Override
    public boolean hasPersistentNBT() {
        return true;
    }

    @Override
    public boolean usePersistentNBT() {
        return false;
    }

    @Override
    public long recalculateEMC(@NotNull ItemInfo info, long currentEMC) throws ArithmeticException {
        Map<Enchantment, Integer> enchants = ItemInfoHelper.getEnchantments(info);
        for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
            int rarityWeight = entry.getKey().m_44699_().m_44716_();
            if (rarityWeight <= 0) continue;
            currentEMC = Math.addExact(currentEMC, Math.multiplyExact(5000L / (long)rarityWeight, (int)entry.getValue()));
        }
        return currentEMC;
    }

    @Override
    @Nullable
    public CompoundTag getPersistentNBT(@NotNull ItemInfo info) {
        CompoundTag tag = info.getNBT();
        if (tag == null) {
            return null;
        }
        String location = ItemInfoHelper.getEnchantTagLocation(info);
        if (!tag.m_128425_(location, 9)) {
            return null;
        }
        CompoundTag toReturn = new CompoundTag();
        ListTag enchantments = tag.m_128437_(location, 10);
        toReturn.m_128365_(location, (Tag)enchantments);
        return toReturn;
    }
}

