/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.customConversions.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversion;
import moze_intel.projecte.emc.mappers.customConversions.json.FixedValues;

public class FixedValuesDeserializer
implements JsonDeserializer<FixedValues> {
    public FixedValues deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        FixedValues fixed = new FixedValues();
        JsonObject o = json.getAsJsonObject();
        block10: for (Map.Entry entry : o.entrySet()) {
            String key;
            switch (key = (String)entry.getKey()) {
                case "before": {
                    fixed.setValueBefore = this.parseSetValueMap(((JsonElement)entry.getValue()).getAsJsonObject(), context);
                    continue block10;
                }
                case "after": {
                    fixed.setValueAfter = this.parseSetValueMap(((JsonElement)entry.getValue()).getAsJsonObject(), context);
                    continue block10;
                }
                case "conversion": {
                    fixed.conversion = (List)context.deserialize((JsonElement)((JsonElement)entry.getValue()).getAsJsonArray(), new TypeToken<List<CustomConversion>>(){}.getType());
                    continue block10;
                }
            }
            throw new JsonParseException(String.format("Can not parse \"%s\":%s in fixedValues", key, entry.getValue()));
        }
        return fixed;
    }

    private Map<NormalizedSimpleStack, Long> parseSetValueMap(JsonObject o, JsonDeserializationContext context) {
        HashMap<NormalizedSimpleStack, Long> out = new HashMap<NormalizedSimpleStack, Long>();
        for (Map.Entry entry : o.entrySet()) {
            JsonPrimitive primitive = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
            if (primitive.isNumber()) {
                long value = primitive.getAsLong();
                if (value < 1L) {
                    throw new JsonParseException("EMC value must be at least one.");
                }
                out.put((NormalizedSimpleStack)context.deserialize((JsonElement)new JsonPrimitive((String)entry.getKey()), NormalizedSimpleStack.class), value);
                continue;
            }
            if (primitive.isString() && primitive.getAsString().toLowerCase(Locale.ROOT).equals("free")) {
                out.put((NormalizedSimpleStack)context.deserialize((JsonElement)new JsonPrimitive((String)entry.getKey()), NormalizedSimpleStack.class), Long.MIN_VALUE);
                continue;
            }
            throw new JsonParseException("Could not parse " + o + " into 'free' or integer.");
        }
        return out;
    }
}

