/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyManagerWrapper;
import mekanism.common.lib.frequency.IdentitySerializer;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.network.BasePacketHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class FrequencyType<FREQ extends Frequency> {
    private static final Map<String, FrequencyType<?>> registryMap = new HashMap();
    public static final FrequencyType<TeleporterFrequency> TELEPORTER = FrequencyType.register("Teleporter", (key, uuid) -> new TeleporterFrequency((String)key, (UUID)uuid), TeleporterFrequency::new, FrequencyManagerWrapper.Type.PUBLIC_PRIVATE, IdentitySerializer.NAME);
    public static final FrequencyType<InventoryFrequency> INVENTORY = FrequencyType.register("Inventory", (key, uuid) -> new InventoryFrequency((String)key, (UUID)uuid), InventoryFrequency::new, FrequencyManagerWrapper.Type.PUBLIC_PRIVATE, IdentitySerializer.NAME);
    public static final FrequencyType<SecurityFrequency> SECURITY = FrequencyType.register("Security", (key, uuid) -> new SecurityFrequency((UUID)uuid), SecurityFrequency::new, FrequencyManagerWrapper.Type.PUBLIC_ONLY, IdentitySerializer.UUID);
    public static final FrequencyType<QIOFrequency> QIO = FrequencyType.register("QIO", (key, uuid) -> new QIOFrequency((String)key, (UUID)uuid), QIOFrequency::new, FrequencyManagerWrapper.Type.PUBLIC_PRIVATE, IdentitySerializer.NAME);
    private final String name;
    private final BiFunction<Object, UUID, FREQ> creationFunction;
    private final Supplier<FREQ> baseCreationFunction;
    private final IdentitySerializer identitySerializer;
    private final FrequencyManagerWrapper<FREQ> managerWrapper;

    public static void init() {
    }

    private static <FREQ extends Frequency> FrequencyType<FREQ> register(String name, BiFunction<Object, UUID, FREQ> creationFunction, Supplier<FREQ> baseCreationFunction, FrequencyManagerWrapper.Type managerType, IdentitySerializer identitySerializer) {
        FrequencyType<FREQ> type = new FrequencyType<FREQ>(name, creationFunction, baseCreationFunction, managerType, identitySerializer);
        registryMap.put(name, type);
        return type;
    }

    private FrequencyType(String name, BiFunction<Object, UUID, FREQ> creationFunction, Supplier<FREQ> baseCreationFunction, FrequencyManagerWrapper.Type managerType, IdentitySerializer identitySerializer) {
        this.name = name;
        this.creationFunction = creationFunction;
        this.baseCreationFunction = baseCreationFunction;
        this.managerWrapper = FrequencyManagerWrapper.create(this, managerType);
        this.identitySerializer = identitySerializer;
    }

    public String getName() {
        return this.name;
    }

    public FREQ create(CompoundTag tag) {
        Frequency freq = (Frequency)this.baseCreationFunction.get();
        freq.read(tag);
        return (FREQ)freq;
    }

    public FREQ create(Object key, UUID ownerUUID) {
        return (FREQ)((Frequency)this.creationFunction.apply(key, ownerUUID));
    }

    public FREQ create(FriendlyByteBuf packet) {
        Frequency freq = (Frequency)this.baseCreationFunction.get();
        freq.read(packet);
        return (FREQ)freq;
    }

    public FrequencyManagerWrapper<FREQ> getManagerWrapper() {
        return this.managerWrapper;
    }

    public FrequencyManager<FREQ> getManager(@Nullable UUID owner) {
        return owner == null ? this.getManagerWrapper().getPublicManager() : this.getManagerWrapper().getPrivateManager(owner);
    }

    @Nullable
    @Contract(value="null -> null")
    public FrequencyManager<FREQ> getFrequencyManager(@Nullable FREQ freq) {
        if (freq == null) {
            return null;
        }
        if (((Frequency)freq).isPublic()) {
            return this.getManagerWrapper().getPublicManager();
        }
        return this.getManagerWrapper().getPrivateManager(((Frequency)freq).getOwner());
    }

    public FrequencyManager<FREQ> getManager(Frequency.FrequencyIdentity identity, UUID owner) {
        return identity.isPublic() ? this.getManagerWrapper().getPublicManager() : this.getManagerWrapper().getPrivateManager(owner);
    }

    public FREQ getFrequency(Frequency.FrequencyIdentity identity, UUID owner) {
        return this.getManager(identity, owner).getFrequency(identity.key());
    }

    public IdentitySerializer getIdentitySerializer() {
        return this.identitySerializer;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.name);
    }

    public static <FREQ extends Frequency> FrequencyType<FREQ> load(FriendlyByteBuf buf) {
        return registryMap.get(BasePacketHandler.readString(buf));
    }

    public static <FREQ extends Frequency> FrequencyType<FREQ> load(CompoundTag tag) {
        return registryMap.get(tag.m_128461_("type"));
    }

    public static void clear() {
        registryMap.values().forEach(type -> type.managerWrapper.clear());
    }

    public String toString() {
        return this.name;
    }
}

