/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.IFluidHandlerSlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.inventory.slot.chemical.InfusionInventorySlot;
import mekanism.common.inventory.slot.chemical.MergedChemicalInventorySlot;
import mekanism.common.inventory.slot.chemical.PigmentInventorySlot;
import mekanism.common.inventory.slot.chemical.SlurryInventorySlot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HybridInventorySlot
extends MergedChemicalInventorySlot<MergedTank>
implements IFluidHandlerSlot {
    private boolean isDraining;
    private boolean isFilling;

    private static boolean hasCapability(@NotNull ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).isPresent() || stack.getCapability(Capabilities.GAS_HANDLER).isPresent() || stack.getCapability(Capabilities.INFUSION_HANDLER).isPresent() || stack.getCapability(Capabilities.PIGMENT_HANDLER).isPresent() || stack.getCapability(Capabilities.SLURRY_HANDLER).isPresent();
    }

    public static HybridInventorySlot inputOrDrain(MergedTank mergedTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(mergedTank, "Merged tank cannot be null");
        Predicate<@NotNull ItemStack> fluidInsertPredicate = FluidInventorySlot.getInputPredicate(mergedTank.getFluidTank());
        Predicate<@NotNull ItemStack> gasInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(mergedTank.getGasTank(), GasInventorySlot::getCapability);
        Predicate<@NotNull ItemStack> infusionInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(mergedTank.getInfusionTank(), InfusionInventorySlot::getCapability);
        Predicate<@NotNull ItemStack> pigmentInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(mergedTank.getPigmentTank(), PigmentInventorySlot::getCapability);
        Predicate<@NotNull ItemStack> slurryInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(mergedTank.getSlurryTank(), SlurryInventorySlot::getCapability);
        BiPredicate<@NotNull ItemStack, @NotNull AutomationType> insertPredicate = (stack, automationType) -> switch (mergedTank.getCurrentType()) {
            default -> throw new IncompatibleClassChangeError();
            case MergedTank.CurrentType.FLUID -> fluidInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.GAS -> gasInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.INFUSION -> infusionInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.PIGMENT -> pigmentInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.SLURRY -> slurryInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.EMPTY -> fluidInsertPredicate.test((ItemStack)stack) || gasInsertPredicate.test((ItemStack)stack) || infusionInsertPredicate.test((ItemStack)stack) || pigmentInsertPredicate.test((ItemStack)stack) || slurryInsertPredicate.test((ItemStack)stack);
        };
        return new HybridInventorySlot(mergedTank, (stack, automationType) -> automationType == AutomationType.MANUAL || !insertPredicate.test((ItemStack)stack, (AutomationType)((Object)automationType)), insertPredicate, HybridInventorySlot::hasCapability, listener, x, y);
    }

    public static HybridInventorySlot outputOrFill(MergedTank mergedTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(mergedTank, "Merged tank cannot be null");
        Predicate<@NotNull ItemStack> gasExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(mergedTank.getGasTank(), GasInventorySlot::getCapability);
        Predicate<@NotNull ItemStack> infusionExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(mergedTank.getInfusionTank(), InfusionInventorySlot::getCapability);
        Predicate<@NotNull ItemStack> pigmentExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(mergedTank.getPigmentTank(), PigmentInventorySlot::getCapability);
        Predicate<@NotNull ItemStack> slurryExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(mergedTank.getSlurryTank(), SlurryInventorySlot::getCapability);
        Predicate<@NotNull ItemStack> gasInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(mergedTank.getGasTank(), GasInventorySlot.getCapability(stack));
        Predicate<@NotNull ItemStack> infusionInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(mergedTank.getInfusionTank(), InfusionInventorySlot.getCapability(stack));
        Predicate<@NotNull ItemStack> pigmentInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(mergedTank.getPigmentTank(), PigmentInventorySlot.getCapability(stack));
        Predicate<@NotNull ItemStack> slurryInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(mergedTank.getSlurryTank(), SlurryInventorySlot.getCapability(stack));
        return new HybridInventorySlot(mergedTank, (stack, automationType) -> {
            if (automationType == AutomationType.MANUAL) {
                return true;
            }
            return switch (mergedTank.getCurrentType()) {
                default -> throw new IncompatibleClassChangeError();
                case MergedTank.CurrentType.FLUID -> true;
                case MergedTank.CurrentType.GAS -> gasExtractPredicate.test((ItemStack)stack);
                case MergedTank.CurrentType.INFUSION -> infusionExtractPredicate.test((ItemStack)stack);
                case MergedTank.CurrentType.PIGMENT -> pigmentExtractPredicate.test((ItemStack)stack);
                case MergedTank.CurrentType.SLURRY -> slurryExtractPredicate.test((ItemStack)stack);
                case MergedTank.CurrentType.EMPTY -> gasExtractPredicate.test((ItemStack)stack) && infusionExtractPredicate.test((ItemStack)stack) && pigmentExtractPredicate.test((ItemStack)stack) && slurryExtractPredicate.test((ItemStack)stack);
            };
        }, (stack, automationType) -> switch (mergedTank.getCurrentType()) {
            default -> throw new IncompatibleClassChangeError();
            case MergedTank.CurrentType.FLUID -> {
                if (automationType == AutomationType.INTERNAL) {
                    yield true;
                }
                yield false;
            }
            case MergedTank.CurrentType.GAS -> gasInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.INFUSION -> infusionInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.PIGMENT -> pigmentInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.SLURRY -> slurryInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.EMPTY -> automationType == AutomationType.INTERNAL && FluidUtil.getFluidHandler((ItemStack)stack).isPresent() ? true : gasInsertPredicate.test((ItemStack)stack) || infusionInsertPredicate.test((ItemStack)stack) || pigmentInsertPredicate.test((ItemStack)stack) || slurryInsertPredicate.test((ItemStack)stack);
        }, HybridInventorySlot::hasCapability, listener, x, y);
    }

    private HybridInventorySlot(MergedTank mergedTank, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super(mergedTank, canExtract, canInsert, validator, listener, x, y);
    }

    @Override
    public IExtendedFluidTank getFluidTank() {
        return ((MergedTank)this.mergedTank).getFluidTank();
    }

    @Override
    public boolean isDraining() {
        return this.isDraining;
    }

    @Override
    public boolean isFilling() {
        return this.isFilling;
    }

    @Override
    public void setDraining(boolean draining) {
        this.isDraining = draining;
    }

    @Override
    public void setFilling(boolean filling) {
        this.isFilling = filling;
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        if (this.isDraining) {
            nbt.m_128379_("draining", true);
        }
        if (this.isFilling) {
            nbt.m_128379_("filling", true);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(@NotNull CompoundTag nbt) {
        this.isDraining = nbt.m_128471_("draining");
        this.isFilling = nbt.m_128471_("filling");
        super.deserializeNBT(nbt);
    }
}

