/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlockTile;
import net.mehvahdjukaar.advframes.network.NetworkHandler;
import net.mehvahdjukaar.advframes.network.ServerBoundSetStatFramePacket;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.achievement.StatsUpdateListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class StatSelectScreen
extends Screen
implements StatsUpdateListener {
    private final StatFrameBlockTile tile;
    private static final Component PENDING_TEXT = Component.m_237115_((String)"multiplayer.downloadingStats");
    private static final ResourceLocation STATS_ICON_LOCATION = new ResourceLocation("textures/gui/container/stats_icons.png");
    private GeneralStatisticsList statsList;
    ItemStatisticsList itemStatsList;
    private MobsStatisticsList mobsStatsList;
    final StatsCounter stats;
    @Nullable
    private ObjectSelectionList<?> activeList;
    private boolean isLoading = true;

    public StatSelectScreen(StatFrameBlockTile tile, StatsCounter statsCounter) {
        super((Component)Component.m_237115_((String)"advancementframes.gui.statistics"));
        this.tile = tile;
        this.stats = statsCounter;
    }

    protected void m_7856_() {
        this.isLoading = true;
        this.f_96541_.m_91403_().m_104955_((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
    }

    public void initLists() {
        this.statsList = new GeneralStatisticsList(this.f_96541_);
        this.itemStatsList = new ItemStatisticsList(this.f_96541_);
        this.mobsStatsList = new MobsStatisticsList(this.f_96541_);
    }

    public void initButtons() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"stat.generalButton"), buttonx -> this.setActiveList(this.statsList)).m_252987_(this.f_96543_ / 2 - 120, this.f_96544_ - 52, 80, 20).m_253136_());
        Button button = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"stat.itemsButton"), buttonx -> this.setActiveList(this.itemStatsList)).m_252987_(this.f_96543_ / 2 - 40, this.f_96544_ - 52, 80, 20).m_253136_());
        Button button2 = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"stat.mobsButton"), buttonx -> this.setActiveList(this.mobsStatsList)).m_252987_(this.f_96543_ / 2 + 40, this.f_96544_ - 52, 80, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, buttonx -> this.f_96541_.m_91152_(null)).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 28, 200, 20).m_253136_());
        if (this.itemStatsList.m_6702_().isEmpty()) {
            button.f_93623_ = false;
        }
        if (this.mobsStatsList.m_6702_().isEmpty()) {
            button2.f_93623_ = false;
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        if (this.isLoading) {
            this.m_280273_(guiGraphics);
            guiGraphics.m_280653_(this.f_96547_, PENDING_TEXT, this.f_96543_ / 2, this.f_96544_ / 2, 0xFFFFFF);
            String var10002 = f_97124_[(int)(Util.m_137550_() / 150L % (long)f_97124_.length)];
            int midX = this.f_96543_ / 2;
            int mixY = this.f_96544_ / 2;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280137_(this.f_96547_, var10002, midX, mixY + 18, 0xFFFFFF);
        } else {
            this.getActiveList().m_88315_(guiGraphics, i, j, f);
            guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
            super.m_88315_(guiGraphics, i, j, f);
        }
    }

    public void m_7819_() {
        if (this.isLoading) {
            this.initLists();
            this.initButtons();
            this.setActiveList(this.statsList);
            this.isLoading = false;
        }
    }

    public boolean m_7043_() {
        return !this.isLoading;
    }

    @Nullable
    public ObjectSelectionList<?> getActiveList() {
        return this.activeList;
    }

    public void setActiveList(@Nullable ObjectSelectionList<?> activeList) {
        if (this.activeList != null) {
            this.m_169411_((GuiEventListener)this.activeList);
        }
        if (activeList != null) {
            this.m_7787_((GuiEventListener)activeList);
            this.activeList = activeList;
        }
    }

    static String getTranslationKey(Stat<ResourceLocation> stat) {
        String string = ((ResourceLocation)stat.m_12867_()).toString();
        return "stat." + string.replace(':', '.');
    }

    int getColumnX(int index) {
        return 115 + 40 * index;
    }

    void blitSlot(GuiGraphics guiGraphics, int i, int j, Item item) {
        this.blitSlotIcon(guiGraphics, i + 1, j + 1, 0, 0);
        guiGraphics.m_280203_(item.m_7968_(), i + 2, j + 2);
    }

    void blitSlotIcon(GuiGraphics guiGraphics, int i, int j, int k, int l) {
        guiGraphics.m_280398_(STATS_ICON_LOCATION, i, j, 0, (float)k, (float)l, 18, 18, 128, 128);
    }

    private <T> void selectStat(StatType<T> statType, T obj) {
        NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundSetStatFramePacket(this.tile.m_58899_(), statType, obj));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        this.m_7379_();
    }

    class GeneralStatisticsList
    extends ObjectSelectionList<Entry> {
        public GeneralStatisticsList(Minecraft minecraft) {
            super(minecraft, StatSelectScreen.this.f_96543_ - 8, StatSelectScreen.this.f_96544_, 32, StatSelectScreen.this.f_96544_ - 64, 10);
            ObjectArrayList objectArrayList = new ObjectArrayList(Stats.f_12988_.iterator());
            objectArrayList.sort(Comparator.comparing(statx -> I18n.m_118938_((String)StatSelectScreen.getTranslationKey((Stat<ResourceLocation>)statx), (Object[])new Object[0])));
            for (Stat stat : objectArrayList) {
                this.m_7085_((AbstractSelectionList.Entry)new Entry((Stat<ResourceLocation>)stat));
            }
            this.m_93488_(false);
            this.m_93496_(false);
        }

        protected void m_7733_(GuiGraphics guiGraphics) {
            StatSelectScreen.this.m_280273_(guiGraphics);
        }

        private class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final Stat<ResourceLocation> stat;
            private final Component statDisplay;

            Entry(Stat<ResourceLocation> stat) {
                this.stat = stat;
                this.statDisplay = Component.m_237115_((String)StatSelectScreen.getTranslationKey(stat));
            }

            private String getValueText() {
                return this.stat.m_12860_(StatSelectScreen.this.stats.m_13015_(this.stat));
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                guiGraphics.m_280430_(StatSelectScreen.this.f_96547_, this.statDisplay, left += 2, ++top, index % 2 == 0 ? 0xFFFFFF : 0x909090);
                String string = this.getValueText();
                guiGraphics.m_280488_(StatSelectScreen.this.f_96547_, string, left + width - StatSelectScreen.this.f_96547_.m_92895_(string), top, index % 2 == 0 ? 0xFFFFFF : 0x909090);
                if (isMouseOver) {
                    guiGraphics.m_285978_(RenderType.m_286086_(), left, top, left + width, top + height + 2, -2130706433, -2130706433, 0);
                }
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                StatSelectScreen.this.selectStat(this.stat.m_12859_(), (ResourceLocation)this.stat.m_12867_());
                return false;
            }

            public Component m_142172_() {
                return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{Component.m_237119_().m_7220_(this.statDisplay).m_7220_(CommonComponents.f_263701_).m_130946_(this.getValueText())});
            }
        }
    }

    class ItemStatisticsList
    extends ObjectSelectionList<ItemRow> {
        protected final List<StatType<Block>> blockColumns;
        protected final List<StatType<Item>> itemColumns;
        private final int[] iconOffsets;
        protected int headerPressed;
        protected final Comparator<ItemRow> itemStatSorter;
        @Nullable
        protected StatType<?> sortColumn;
        protected int sortOrder;

        public ItemStatisticsList(Minecraft minecraft) {
            boolean success;
            super(minecraft, StatSelectScreen.this.f_96543_, StatSelectScreen.this.f_96544_, 32, StatSelectScreen.this.f_96544_ - 64, 20);
            this.blockColumns = Lists.newArrayList();
            this.iconOffsets = new int[]{3, 4, 1, 2, 5, 6};
            this.headerPressed = -1;
            this.itemStatSorter = new ItemRowComparator();
            this.blockColumns.add((StatType<Block>)Stats.f_12949_);
            this.itemColumns = Lists.newArrayList((Object[])new StatType[]{Stats.f_12983_, Stats.f_12981_, Stats.f_12982_, Stats.f_12984_, Stats.f_12985_});
            this.m_93473_(true, 20);
            Set set = Sets.newIdentityHashSet();
            for (Item item : BuiltInRegistries.f_257033_) {
                success = false;
                for (StatType<Item> statType : this.itemColumns) {
                    if (!statType.m_12897_((Object)item) || StatSelectScreen.this.stats.m_13015_(statType.m_12902_((Object)item)) <= 0) continue;
                    success = true;
                }
                if (!success) continue;
                set.add(item);
            }
            for (Block block : BuiltInRegistries.f_256975_) {
                success = false;
                for (StatType<Item> statType : this.blockColumns) {
                    if (!statType.m_12897_((Object)block) || StatSelectScreen.this.stats.m_13015_(statType.m_12902_((Object)block)) <= 0) continue;
                    success = true;
                }
                if (!success) continue;
                set.add(block.m_5456_());
            }
            set.remove(Items.f_41852_);
            for (Item item : set) {
                this.m_7085_((AbstractSelectionList.Entry)new ItemRow(item));
            }
            this.m_93488_(false);
            this.m_93496_(false);
        }

        protected void m_7733_(GuiGraphics guiGraphics) {
            StatSelectScreen.this.m_280273_(guiGraphics);
        }

        protected void m_7415_(GuiGraphics guiGraphics, int i, int j) {
            int l;
            int k;
            if (!this.f_93386_.f_91067_.m_91560_()) {
                this.headerPressed = -1;
            }
            for (k = 0; k < this.iconOffsets.length; ++k) {
                StatSelectScreen.this.blitSlotIcon(guiGraphics, i + StatSelectScreen.this.getColumnX(k) - 18, j + 1, 0, this.headerPressed == k ? 0 : 18);
            }
            if (this.sortColumn != null) {
                k = StatSelectScreen.this.getColumnX(this.getColumnIndex(this.sortColumn)) - 36;
                l = this.sortOrder == 1 ? 2 : 1;
                StatSelectScreen.this.blitSlotIcon(guiGraphics, i + k, j + 1, 18 * l, 0);
            }
            for (k = 0; k < this.iconOffsets.length; ++k) {
                l = this.headerPressed == k ? 1 : 0;
                StatSelectScreen.this.blitSlotIcon(guiGraphics, i + StatSelectScreen.this.getColumnX(k) - 18 + l, j + 1 + l, 18 * this.iconOffsets[k], 18);
            }
        }

        public int m_5759_() {
            return 375;
        }

        protected int m_5756_() {
            return this.f_93388_ / 2 + 140;
        }

        protected void m_6205_(int mouseX, int mouseY) {
            this.headerPressed = -1;
            for (int i = 0; i < this.iconOffsets.length; ++i) {
                int j = mouseX - StatSelectScreen.this.getColumnX(i);
                if (j < -36 || j > 0) continue;
                this.headerPressed = i;
                break;
            }
            if (this.headerPressed >= 0) {
                this.sortByColumn(this.getColumn(this.headerPressed));
                this.f_93386_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            }
        }

        private StatType<?> getColumn(int index) {
            return index < this.blockColumns.size() ? this.blockColumns.get(index) : this.itemColumns.get(index - this.blockColumns.size());
        }

        private int getColumnIndex(StatType<?> statType) {
            int i = this.blockColumns.indexOf(statType);
            if (i >= 0) {
                return i;
            }
            int j = this.itemColumns.indexOf(statType);
            return j >= 0 ? j + this.blockColumns.size() : -1;
        }

        protected void m_7154_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (mouseY >= this.f_93390_ && mouseY < this.f_93391_) {
                ItemRow itemRow = (ItemRow)this.m_168795_();
                int k = (this.f_93388_ - this.m_5759_()) / 2;
                Component component = null;
                if (itemRow != null) {
                    if (mouseX < k + 44 || mouseX > k + 44 + 18) {
                        return;
                    }
                    Item item = itemRow.getItem();
                    component = item.m_41466_();
                } else {
                    int l = mouseX - k - 2;
                    for (int m = 0; m < this.iconOffsets.length; ++m) {
                        int n = StatSelectScreen.this.getColumnX(m);
                        if (l < n - 18 || l > n) continue;
                        component = this.getColumn(m).m_12905_();
                        break;
                    }
                }
                if (component != null) {
                    StatSelectScreen.this.m_257404_(component);
                }
            }
        }

        protected void sortByColumn(StatType<?> statType) {
            if (statType != this.sortColumn) {
                this.sortColumn = statType;
                this.sortOrder = -1;
            } else if (this.sortOrder == -1) {
                this.sortOrder = 1;
            } else {
                this.sortColumn = null;
                this.sortOrder = 0;
            }
            this.m_6702_().sort(this.itemStatSorter);
        }

        private class ItemRowComparator
        implements Comparator<ItemRow> {
            ItemRowComparator() {
            }

            @Override
            public int compare(ItemRow row1, ItemRow row2) {
                int j;
                int i;
                Item item = row1.getItem();
                Item item2 = row2.getItem();
                if (ItemStatisticsList.this.sortColumn == null) {
                    i = 0;
                    j = 0;
                } else if (ItemStatisticsList.this.blockColumns.contains(ItemStatisticsList.this.sortColumn)) {
                    int n;
                    BlockItem bi;
                    StatType<?> statType = ItemStatisticsList.this.sortColumn;
                    if (item instanceof BlockItem) {
                        bi = (BlockItem)item;
                        v0 = StatSelectScreen.this.stats.m_13017_(statType, (Object)bi.m_40614_());
                    } else {
                        v0 = i = -1;
                    }
                    if (item2 instanceof BlockItem) {
                        bi = (BlockItem)item2;
                        n = StatSelectScreen.this.stats.m_13017_(statType, (Object)bi.m_40614_());
                    } else {
                        n = -1;
                    }
                    j = n;
                } else {
                    StatType<?> statType = ItemStatisticsList.this.sortColumn;
                    i = StatSelectScreen.this.stats.m_13017_(statType, (Object)item);
                    j = StatSelectScreen.this.stats.m_13017_(statType, (Object)item2);
                }
                return i == j ? ItemStatisticsList.this.sortOrder * Integer.compare(Item.m_41393_((Item)item), Item.m_41393_((Item)item2)) : ItemStatisticsList.this.sortOrder * Integer.compare(i, j);
            }
        }

        private class ItemRow
        extends ObjectSelectionList.Entry<ItemRow> {
            private final Item item;
            private Stat<?> hovered = null;

            ItemRow(Item item) {
                this.item = item;
            }

            public Item getItem() {
                return this.item;
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                int p;
                StatSelectScreen.this.blitSlot(guiGraphics, left + 40, top, this.item);
                this.hovered = null;
                for (p = 0; p < StatSelectScreen.this.itemStatsList.blockColumns.size(); ++p) {
                    Stat stat;
                    Item item = this.item;
                    if (item instanceof BlockItem) {
                        BlockItem bi = (BlockItem)item;
                        stat = StatSelectScreen.this.itemStatsList.blockColumns.get(p).m_12902_((Object)bi.m_40614_());
                    } else {
                        stat = null;
                    }
                    this.renderStat(guiGraphics, stat, left + StatSelectScreen.this.getColumnX(p), top, index % 2 == 0, isMouseOver, mouseX);
                }
                for (p = 0; p < StatSelectScreen.this.itemStatsList.itemColumns.size(); ++p) {
                    this.renderStat(guiGraphics, StatSelectScreen.this.itemStatsList.itemColumns.get(p).m_12902_((Object)this.item), left + StatSelectScreen.this.getColumnX(p + StatSelectScreen.this.itemStatsList.blockColumns.size()), top, index % 2 == 0, isMouseOver, mouseX);
                }
            }

            protected void renderStat(GuiGraphics guiGraphics, @Nullable Stat<?> stat, int x, int y, boolean odd, boolean isMouseOver, int mouseX) {
                String string = stat == null ? "-" : stat.m_12860_(StatSelectScreen.this.stats.m_13015_(stat));
                guiGraphics.m_280488_(StatSelectScreen.this.f_96547_, string, x - StatSelectScreen.this.f_96547_.m_92895_(string), y + 5, odd ? 0xFFFFFF : 0x909090);
                int w = 18;
                if (stat != null && isMouseOver && mouseX >= x - w && mouseX < x) {
                    guiGraphics.m_285978_(RenderType.m_286086_(), x - w, y, x, y + w, -2130706433, -2130706433, 0);
                    this.hovered = stat;
                }
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.hovered != null) {
                    StatType type = this.hovered.m_12859_();
                    if (type.m_12893_() == BuiltInRegistries.f_256975_) {
                        StatSelectScreen.this.selectStat(type, ((BlockItem)this.item).m_40614_());
                    } else {
                        StatSelectScreen.this.selectStat(type, this.item);
                    }
                }
                return false;
            }

            @Nullable
            public Component m_142172_() {
                return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.item.m_41466_()});
            }
        }
    }

    class MobsStatisticsList
    extends ObjectSelectionList<MobRow> {
        public MobsStatisticsList(Minecraft minecraft) {
            super(minecraft, StatSelectScreen.this.f_96543_, StatSelectScreen.this.f_96544_, 32, StatSelectScreen.this.f_96544_ - 64, 32);
            for (EntityType entityType : BuiltInRegistries.f_256780_) {
                if (StatSelectScreen.this.stats.m_13015_(Stats.f_12986_.m_12902_((Object)entityType)) <= 0 && StatSelectScreen.this.stats.m_13015_(Stats.f_12987_.m_12902_((Object)entityType)) <= 0) continue;
                this.m_7085_((AbstractSelectionList.Entry)new MobRow(entityType));
            }
            this.m_93488_(false);
            this.m_93496_(false);
        }

        protected void m_7733_(GuiGraphics guiGraphics) {
            StatSelectScreen.this.m_280273_(guiGraphics);
        }

        private class MobRow
        extends ObjectSelectionList.Entry<MobRow> {
            private final Component mobName;
            private final Component kills;
            private final boolean hasKills;
            private final Component killedBy;
            private final boolean wasKilledBy;
            private final EntityType<?> entity;
            private int hovered = 0;

            public MobRow(EntityType<?> entityType) {
                this.entity = entityType;
                this.mobName = entityType.m_20676_();
                int entitiesKilled = StatSelectScreen.this.stats.m_13015_(Stats.f_12986_.m_12902_(entityType));
                if (entitiesKilled == 0) {
                    this.kills = Component.m_237110_((String)"stat_type.minecraft.killed.none", (Object[])new Object[]{this.mobName});
                    this.hasKills = false;
                } else {
                    this.kills = Component.m_237110_((String)"stat_type.minecraft.killed", (Object[])new Object[]{entitiesKilled, this.mobName});
                    this.hasKills = true;
                }
                int killedByEntities = StatSelectScreen.this.stats.m_13015_(Stats.f_12987_.m_12902_(entityType));
                if (killedByEntities == 0) {
                    this.killedBy = Component.m_237110_((String)"stat_type.minecraft.killed_by.none", (Object[])new Object[]{this.mobName});
                    this.wasKilledBy = false;
                } else {
                    this.killedBy = Component.m_237110_((String)"stat_type.minecraft.killed_by", (Object[])new Object[]{this.mobName, killedByEntities});
                    this.wasKilledBy = true;
                }
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
                this.hovered = 0;
                guiGraphics.m_280430_(StatSelectScreen.this.f_96547_, this.mobName, left + 2, top + 1, 0xFFFFFF);
                int stringX = left + 2 + 10;
                int stringY = top + 1 + 10;
                guiGraphics.m_280430_(StatSelectScreen.this.f_96547_, this.kills, stringX, stringY, this.hasKills ? 0x909090 : 0x606060);
                if (mouseY >= stringY && mouseY <= stringY + 9) {
                    this.hovered = 1;
                    guiGraphics.m_285978_(RenderType.m_286086_(), stringX, stringY, left + width - 12, stringY + 9, -2130706433, -2130706433, 0);
                }
                stringY = top + 1 + 20;
                guiGraphics.m_280430_(StatSelectScreen.this.f_96547_, this.killedBy, stringX, stringY, this.wasKilledBy ? 0x909090 : 0x606060);
                if (mouseY >= stringY && mouseY <= stringY + 9) {
                    this.hovered = 2;
                    guiGraphics.m_285978_(RenderType.m_286086_(), stringX, stringY, left + width - 12, stringY + 9, -2130706433, -2130706433, 0);
                }
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.hovered == 1) {
                    StatSelectScreen.this.selectStat(Stats.f_12986_, this.entity);
                } else if (this.hovered == 2) {
                    StatSelectScreen.this.selectStat(Stats.f_12987_, this.entity);
                }
                return false;
            }

            public Component m_142172_() {
                return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{CommonComponents.m_267603_((Component[])new Component[]{this.kills, this.killedBy})});
            }
        }
    }
}

