/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.blocks;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.mehvahdjukaar.advframes.AdvFrames;
import net.mehvahdjukaar.advframes.blocks.BaseFrameBlockTile;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class StatFrameBlockTile
extends BaseFrameBlockTile {
    @Nullable
    private Stat<?> stat = null;
    private int value = 0;
    private float fontScale = 1.0f;
    private List<FormattedCharSequence> cachedPageLines = Collections.emptyList();
    private boolean needsVisualRefresh = true;

    public StatFrameBlockTile(BlockPos pos, BlockState state) {
        super(AdvFrames.STAT_FRAME_TILE.get(), pos, state);
    }

    public <T> void setStat(StatType<T> stat, ResourceLocation objId, ServerPlayer player) {
        this.stat = stat.m_12902_(Objects.requireNonNull(stat.m_12893_().m_7745_(objId)));
        this.setOwner(new GameProfile(player.m_20148_(), null));
    }

    @Nullable
    public Stat<?> getStat() {
        return this.stat;
    }

    @Override
    protected void m_183515_(CompoundTag cmp) {
        super.m_183515_(cmp);
        if (this.stat != null) {
            cmp.m_128359_("Stat", BuiltInRegistries.f_256899_.m_7981_((Object)this.stat.m_12859_()).toString());
            cmp.m_128359_("StatKey", StatFrameBlockTile.getStatKey(this.stat).toString());
            cmp.m_128405_("Value", this.value);
        }
    }

    private static <T> ResourceLocation getStatKey(Stat<T> stat) {
        return stat.m_12859_().m_12893_().m_7981_(stat.m_12867_());
    }

    @Override
    public void m_142466_(CompoundTag cmp) {
        super.m_142466_(cmp);
        this.stat = null;
        if (cmp.m_128441_("Stat") && cmp.m_128441_("StatKey")) {
            ResourceLocation statValue = new ResourceLocation(cmp.m_128461_("StatKey"));
            StatType type = (StatType)BuiltInRegistries.f_256899_.m_7745_(new ResourceLocation(cmp.m_128461_("Stat")));
            this.stat = this.getInstance(statValue, type);
            this.value = cmp.m_128451_("Value");
        }
    }

    @Nullable
    private <T> Stat<T> getInstance(ResourceLocation id, StatType<T> type) {
        if (type == null) {
            return null;
        }
        Object value = type.m_12893_().m_7745_(id);
        if (value == null) {
            return null;
        }
        return type.m_12902_(value);
    }

    @Override
    @Nullable
    public Component getTitle() {
        return null;
    }

    @Override
    public ChatFormatting getTitleColor() {
        return ChatFormatting.WHITE;
    }

    @Override
    public boolean isEmpty() {
        return this.stat != null;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        if (this.stat != null) {
            return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        }
        return null;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StatFrameBlockTile tile) {
        if ((level.m_46467_() + 1L) % 100L == 0L) {
            tile.updateStatValue();
        }
    }

    public void updateStatValue() {
        ServerPlayer serverPlayer;
        ServerStatsCounter stats;
        int newValue;
        Player player;
        GameProfile owner = this.getOwner();
        if (this.stat != null && owner != null && (player = this.f_58857_.m_46003_(owner.getId())) instanceof ServerPlayer && (newValue = (stats = (serverPlayer = (ServerPlayer)player).m_8951_()).m_13015_(this.stat)) != this.value) {
            this.value = newValue;
            this.m_6596_();
            BlockState state = this.m_58900_();
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)StatFrameBlock.TRIGGERED, (Comparable)Boolean.valueOf(true)));
            this.f_58857_.m_186460_(this.f_58858_, state.m_60734_(), 2);
        }
    }

    public boolean needsVisualUpdate() {
        if (this.needsVisualRefresh) {
            this.needsVisualRefresh = false;
            return true;
        }
        return false;
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(float s) {
        this.fontScale = s;
    }

    public void setCachedPageLines(List<FormattedCharSequence> l) {
        this.cachedPageLines = l;
    }

    public List<FormattedCharSequence> getCachedLines() {
        return this.cachedPageLines;
    }

    public int getValue() {
        return this.value;
    }
}

