/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.supermartijn642.additionallanterns.LanternBlock;
import com.supermartijn642.additionallanterns.LanternMaterial;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;

public class VanillaLanternEvents {
    public static void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, false, VanillaLanternEvents::handleInteractWithLantern);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, false, VanillaLanternEvents::handleLanternPlacement);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, false, VanillaLanternEvents::handleLanternRedstone);
    }

    private static void handleInteractWithLantern(PlayerInteractEvent.RightClickBlock e) {
        BlockPos clickedPos;
        Level level = e.getLevel();
        BlockState oldState = level.m_8055_(clickedPos = e.getPos());
        if (oldState.m_60734_() == Blocks.f_50681_) {
            e.setCanceled(true);
            e.setCancellationResult(level.f_46443_ ? InteractionResult.SUCCESS : InteractionResult.CONSUME);
            if (!level.f_46443_) {
                BlockState newState = (BlockState)((BlockState)((BlockState)((BlockState)LanternMaterial.NORMAL.getLanternBlock().m_49966_().m_61124_((Property)LanternBlock.ON, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LanternBlock.REDSTONE, (Comparable)Boolean.valueOf(level.m_276867_(clickedPos)))).m_61124_((Property)LanternBlock.f_153459_, (Comparable)((Boolean)oldState.m_61143_((Property)BlockStateProperties.f_61435_)))).m_61124_((Property)LanternBlock.f_153460_, (Comparable)((Boolean)oldState.m_61143_((Property)BlockStateProperties.f_61362_)));
                level.m_7731_(clickedPos, newState, 3);
            }
        }
    }

    private static void handleLanternPlacement(BlockEvent.EntityPlaceEvent e) {
        LevelAccessor level = e.getLevel();
        if (!level.m_5776_()) {
            BlockState newState;
            BlockState oldState = e.getPlacedBlock();
            if (oldState.m_60734_() == LanternMaterial.NORMAL.getLanternBlock() && ((Boolean)oldState.m_61143_((Property)LanternBlock.ON)).booleanValue() && !((Boolean)oldState.m_61143_((Property)LanternBlock.REDSTONE)).booleanValue()) {
                newState = (BlockState)((BlockState)Blocks.f_50681_.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)((Boolean)oldState.m_61143_((Property)LanternBlock.f_153459_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)oldState.m_61143_((Property)LanternBlock.f_153460_)));
                level.m_7731_(e.getPos(), newState, 3);
            }
            if (oldState.m_60734_() == Blocks.f_50681_ && e.getLevel().m_276867_(e.getPos())) {
                newState = (BlockState)((BlockState)((BlockState)LanternMaterial.NORMAL.getLanternBlock().m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)((Boolean)oldState.m_61143_((Property)LanternBlock.f_153459_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)oldState.m_61143_((Property)LanternBlock.f_153460_)))).m_61124_((Property)LanternBlock.REDSTONE, (Comparable)Boolean.valueOf(true));
                level.m_7731_(e.getPos(), newState, 3);
            }
        }
    }

    private static void handleLanternRedstone(BlockEvent.NeighborNotifyEvent e) {
        LevelAccessor level = e.getLevel();
        BlockPos originatingPos = e.getPos();
        for (Direction direction : e.getNotifiedSides()) {
            BlockPos pos = originatingPos.m_121945_(direction);
            BlockState oldState = level.m_8055_(pos);
            if (oldState.m_60734_() != Blocks.f_50681_ || !(level instanceof Level) || !((Level)level).m_276867_(pos)) continue;
            BlockState newState = (BlockState)((BlockState)((BlockState)LanternMaterial.NORMAL.getLanternBlock().m_49966_().m_61124_((Property)LanternBlock.REDSTONE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LanternBlock.f_153459_, (Comparable)((Boolean)oldState.m_61143_((Property)BlockStateProperties.f_61435_)))).m_61124_((Property)LanternBlock.f_153460_, (Comparable)((Boolean)oldState.m_61143_((Property)BlockStateProperties.f_61362_)));
            level.m_7731_(pos, newState, 3);
        }
    }
}

