/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzStructures;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.worldgen.structures.OptimizedJigsawManager;
import com.telepathicgrunt.the_bumblezone.worldgen.structures.PollinatedStreamStructure;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class HoneyCaveRoomStructure
extends Structure {
    public static final Codec<HoneyCaveRoomStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PollinatedStreamStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, HoneyCaveRoomStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public HoneyCaveRoomStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    private static boolean validSpot(ChunkGenerator chunkGenerator, BlockPos centerPos, LevelHeightAccessor heightLimitView, RandomState randomState) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122190_((Vec3i)centerPos);
        NoiseColumn columnOfBlocks = chunkGenerator.m_214184_(mutable.m_123341_(), mutable.m_123343_(), heightLimitView, randomState);
        BlockState state = columnOfBlocks.m_183556_(mutable.m_123342_() + 2);
        BlockState aboveState = columnOfBlocks.m_183556_(mutable.m_123342_() + 17);
        return !state.m_60795_() && state.m_60819_().m_76178_() && !aboveState.m_60795_() && aboveState.m_60819_().m_76178_();
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        WorldgenRandom positionedRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(context.f_226627_() + (long)context.f_226628_().f_45578_ * ((long)context.f_226628_().f_45579_ * 17L)));
        int height = context.f_226622_().m_6337_() + 42 + positionedRandom.m_188503_(Math.max(context.f_226622_().m_6331_() - (context.f_226622_().m_6337_() + 92), 1));
        BlockPos centerPos = new BlockPos(context.f_226628_().m_45604_(), height, context.f_226628_().m_45605_());
        if (!HoneyCaveRoomStructure.validSpot(context.f_226622_(), centerPos, context.f_226629_(), context.f_226624_())) {
            return Optional.empty();
        }
        return OptimizedJigsawManager.assembleJigsawStructure(context, this.startPool, this.size, ((Registry)context.f_226621_().m_6632_(Registries.f_256944_).get()).m_7981_((Object)this), centerPos, false, this.projectStartToHeightmap, this.maxDistanceFromCenter, (structurePiecesBuilder, pieces) -> GeneralUtils.centerAllPieces(centerPos, pieces), false);
    }

    public StructureType<?> m_213658_() {
        return BzStructures.HONEY_CAVE_ROOM.get();
    }
}

