/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.forge;

import com.mojang.datafixers.util.Function6;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.blocks.EmptyHoneycombBrood;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.EntitySpawnEvent;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.DispenserBlockInvoker;
import com.telepathicgrunt.the_bumblezone.modcompat.BroodBlockModdedCompatDispenseBehavior;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.block.ExpansionBox;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.util.Lazy;

public class ProductiveBeesCompat
implements ModCompat {
    private static final Lazy<List<String>> SPIDER_DUNGEON_HONEYCOMBS = Lazy.of(() -> BeeReloadListener.INSTANCE.getData().entrySet().stream().filter(e -> {
        CompoundTag tag = (CompoundTag)e.getValue();
        int primary = tag.m_128451_("primaryColor");
        return BzModCompatibilityConfigs.allowedCombsForDungeons.contains(e.getKey()) && tag.m_128471_("createComb") && (ProductiveBeesCompat.colorsAreClose(GeneralUtils.colorToInt(106, 127, 0), primary, 150) || ProductiveBeesCompat.colorsAreClose(GeneralUtils.colorToInt(129, 198, 0), primary, 150) || ProductiveBeesCompat.colorsAreClose(GeneralUtils.colorToInt(34, 45, 0), primary, 150));
    }).map(Map.Entry::getKey).toList());
    private static final Lazy<List<String>> BEE_DUNGEON_HONEYCOMBS = Lazy.of(() -> BeeReloadListener.INSTANCE.getData().entrySet().stream().filter(e -> {
        CompoundTag tag = (CompoundTag)e.getValue();
        return BzModCompatibilityConfigs.allowedCombsForDungeons.contains(e.getKey()) && tag.m_128471_("createComb") && !((List)SPIDER_DUNGEON_HONEYCOMBS.get()).contains(e.getKey());
    }).map(Map.Entry::getKey).toList());
    private static final Lazy<List<String>> ALL_BEES = Lazy.of(() -> BeeReloadListener.INSTANCE.getData().keySet().stream().filter(e -> BzModCompatibilityConfigs.allowedBees.contains(e)).toList());
    public static final TagKey<Block> SOLITARY_OVERWORLD_NESTS_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("productivebees", "solitary_overworld_nests"));
    protected static Optional<Item> BEE_CAGE;
    protected static Optional<Item> STURDY_BEE_CAGE;

    public ProductiveBeesCompat() {
        BEE_CAGE = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation("productivebees", "bee_cage"));
        STURDY_BEE_CAGE = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation("productivebees", "sturdy_bee_cage"));
        if (BEE_CAGE.isPresent() && BzModCompatibilityConfigs.allowProductiveBeesBeeCageRevivingEmptyBroodBlock) {
            ProductiveBeesCompat.setupDispenserCompat(BEE_CAGE.get());
        }
        if (STURDY_BEE_CAGE.isPresent() && BzModCompatibilityConfigs.allowProductiveBeesBeeCageRevivingEmptyBroodBlock) {
            ProductiveBeesCompat.setupDispenserCompat(STURDY_BEE_CAGE.get());
        }
        ModChecker.productiveBeesPresent = true;
    }

    private static void setupDispenserCompat(Item containerItem) {
        BroodBlockModdedCompatDispenseBehavior newDispenseBehavior = new BroodBlockModdedCompatDispenseBehavior(((DispenserBlockInvoker)Blocks.f_50061_).bumblezone$invokeGetDispenseMethod(new ItemStack((ItemLike)containerItem)), (Function6<DispenseItemBehavior, BlockSource, ItemStack, ServerLevel, BlockPos, BlockState, ItemStack>)((Function6)(originalModdedDispenseBehavior, blockSource, itemStack, serverLevel, blockPos, blockState) -> {
            serverLevel.m_46597_(blockPos, (BlockState)((BlockState)BzBlocks.HONEYCOMB_BROOD.get().m_49966_().m_61124_((Property)HoneycombBrood.f_52588_, (Comparable)((Direction)blockState.m_61143_((Property)EmptyHoneycombBrood.f_52588_)))).m_61124_((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(ProductiveBeesCompat.isFilledBabyBeeCageItem(itemStack) ? 2 : 3)));
            boolean isSturdy = STURDY_BEE_CAGE.isPresent() && itemStack.m_150930_(STURDY_BEE_CAGE.get());
            itemStack.m_41774_(1);
            if (!itemStack.m_41619_()) {
                if (blockSource.m_8118_() instanceof DispenserBlockEntity) {
                    DispenserBlockEntity dispenser = (DispenserBlockEntity)blockSource.m_8118_();
                    ItemStack emptyCage = ItemStack.f_41583_;
                    if (isSturdy && STURDY_BEE_CAGE.isPresent()) {
                        emptyCage = new ItemStack((ItemLike)STURDY_BEE_CAGE.get());
                    } else if (BEE_CAGE.isPresent()) {
                        emptyCage = new ItemStack((ItemLike)BEE_CAGE.get());
                    }
                    if (!HopperBlockEntity.m_59326_(null, (Container)dispenser, (ItemStack)emptyCage, null).m_41619_()) {
                        BroodBlockModdedCompatDispenseBehavior.DEFAULT_DROP_ITEM_BEHAVIOR.m_6115_(blockSource, emptyCage);
                    }
                }
            } else if (isSturdy) {
                itemStack = new ItemStack((ItemLike)STURDY_BEE_CAGE.get());
            } else if (BEE_CAGE.isPresent()) {
                itemStack = new ItemStack((ItemLike)BEE_CAGE.get());
            }
            return itemStack;
        }));
        DispenserBlock.m_52672_((ItemLike)containerItem, (DispenseItemBehavior)newDispenseBehavior);
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.SPAWNS, new ModCompat.Type[]{ModCompat.Type.COMBS, ModCompat.Type.HIVE_TELEPORT, ModCompat.Type.COMB_ORE, ModCompat.Type.EMPTY_BROOD, ModCompat.Type.BEE_COLOR});
    }

    private static boolean colorsAreClose(int a, int z, int threshold) {
        int b;
        int g;
        int r = GeneralUtils.getRed(a) - GeneralUtils.getRed(z);
        return r * r + (g = GeneralUtils.getGreen(a) - GeneralUtils.getGreen(z)) * g + (b = GeneralUtils.getBlue(a) - GeneralUtils.getBlue(z)) * b <= threshold * threshold;
    }

    @Override
    public boolean isValidBeeHiveForTeleportation(BlockState state) {
        if (state.m_60734_() instanceof ExpansionBox && state.m_61143_((Property)AdvancedBeehive.EXPANDED) != VerticalHive.NONE) {
            return true;
        }
        if (state.m_204336_(SOLITARY_OVERWORLD_NESTS_TAG)) {
            return true;
        }
        return state.m_60734_() instanceof AdvancedBeehiveAbstract;
    }

    @Override
    public boolean onBeeSpawn(EntitySpawnEvent event, boolean isChild) {
        if (!BzModCompatibilityConfigs.spawnProductiveBeesBeesMob) {
            return false;
        }
        if ((double)event.entity().m_217043_().m_188501_() >= BzModCompatibilityConfigs.spawnrateOfProductiveBeesMobs) {
            return false;
        }
        if (event.spawnType() == MobSpawnType.DISPENSER && !BzModCompatibilityConfigs.allowProductiveBeesSpawnFromDispenserFedBroodBlock) {
            return false;
        }
        if (((List)ALL_BEES.get()).size() == 0) {
            return false;
        }
        Mob entity = event.entity();
        LevelAccessor world = event.level();
        ConfigurableBee productiveBeeEntity = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).m_20615_(entity.m_9236_());
        if (productiveBeeEntity == null) {
            return false;
        }
        productiveBeeEntity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), productiveBeeEntity.m_217043_().m_188501_() * 360.0f, 0.0f);
        productiveBeeEntity.m_6863_(isChild);
        CompoundTag newTag = new CompoundTag();
        newTag.m_128359_("type", (String)((List)ALL_BEES.get()).get(productiveBeeEntity.m_217043_().m_188503_(((List)ALL_BEES.get()).size())));
        productiveBeeEntity.m_6518_((ServerLevelAccessor)world, world.m_6436_(productiveBeeEntity.m_20183_()), event.spawnType(), null, newTag);
        productiveBeeEntity.setBeeType(newTag.m_128461_("type"));
        world.m_7967_((Entity)productiveBeeEntity);
        return true;
    }

    @Override
    public OptionalBoolean validateCombType(CompoundTag tag) {
        CompoundTag productiveBeesData;
        if (tag.m_128441_("type") && (productiveBeesData = (CompoundTag)BeeReloadListener.INSTANCE.getData().get(tag.m_128461_("type"))) != null && productiveBeesData.m_128471_("createComb")) {
            return OptionalBoolean.TRUE;
        }
        return OptionalBoolean.EMPTY;
    }

    @Override
    public boolean checkCombSpawn(BlockPos pos, RandomSource random, LevelReader level, boolean spiderDungeon) {
        if (spiderDungeon) {
            return (double)random.m_188501_() < BzModCompatibilityConfigs.PBOreHoneycombSpawnRateSpiderBeeDungeon;
        }
        return (double)random.m_188501_() < BzModCompatibilityConfigs.PBOreHoneycombSpawnRateBeeDungeon;
    }

    @Override
    public StructureTemplate.StructureBlockInfo getHoneycomb(BlockPos pos, RandomSource random, LevelReader level, boolean spiderDungeon) {
        if (spiderDungeon) {
            return ProductiveBeesCompat.PBGetRottenedHoneycomb(pos, random);
        }
        return ProductiveBeesCompat.PBGetRandomHoneycomb(pos, random);
    }

    public static StructureTemplate.StructureBlockInfo PBGetRottenedHoneycomb(BlockPos worldPos, RandomSource random) {
        if (!BzModCompatibilityConfigs.spawnProductiveBeesHoneycombVariants || ((List)SPIDER_DUNGEON_HONEYCOMBS.get()).size() == 0) {
            return null;
        }
        CompoundTag newTag = new CompoundTag();
        newTag.m_128359_("type", (String)((List)SPIDER_DUNGEON_HONEYCOMBS.get()).get(random.m_188503_(((List)SPIDER_DUNGEON_HONEYCOMBS.get()).size())));
        return new StructureTemplate.StructureBlockInfo(worldPos, ((Block)ModBlocks.CONFIGURABLE_COMB.get()).m_49966_(), newTag);
    }

    public static StructureTemplate.StructureBlockInfo PBGetRandomHoneycomb(BlockPos worldPos, RandomSource random) {
        if (!BzModCompatibilityConfigs.spawnProductiveBeesHoneycombVariants || ((List)BEE_DUNGEON_HONEYCOMBS.get()).size() == 0) {
            return null;
        }
        CompoundTag newTag = new CompoundTag();
        newTag.m_128359_("type", (String)((List)BEE_DUNGEON_HONEYCOMBS.get()).get(random.m_188503_(((List)BEE_DUNGEON_HONEYCOMBS.get()).size())));
        return new StructureTemplate.StructureBlockInfo(worldPos, ((Block)ModBlocks.CONFIGURABLE_COMB.get()).m_49966_(), newTag);
    }

    public static boolean isFilledBeeCageItem(ItemStack stack) {
        return (BEE_CAGE.isPresent() && stack.m_150930_(BEE_CAGE.get()) || STURDY_BEE_CAGE.isPresent() && stack.m_150930_(STURDY_BEE_CAGE.get())) && !stack.m_41619_() && stack.m_41782_() && stack.m_41784_().m_128441_("entity");
    }

    public static boolean isFilledBabyBeeCageItem(ItemStack stack) {
        return ProductiveBeesCompat.isFilledBeeCageItem(stack) && stack.m_41784_().m_128451_("Age") < 0;
    }

    @Override
    public InteractionResult onEmptyBroodInteract(ItemStack itemstack, Player playerEntity, InteractionHand playerHand) {
        if (!BzModCompatibilityConfigs.allowProductiveBeesBeeCageRevivingEmptyBroodBlock) {
            return InteractionResult.PASS;
        }
        if (ProductiveBeesCompat.isFilledBeeCageItem(itemstack) && !playerEntity.m_6047_()) {
            if (!playerEntity.m_150110_().f_35937_) {
                ItemStack itemToGive = ItemStack.f_41583_;
                if (STURDY_BEE_CAGE.isPresent() && itemstack.m_150930_(STURDY_BEE_CAGE.get())) {
                    itemToGive = STURDY_BEE_CAGE.get().m_7968_();
                } else if (BEE_CAGE.isPresent() && itemstack.m_150930_(BEE_CAGE.get())) {
                    itemToGive = BEE_CAGE.get().m_7968_();
                }
                GeneralUtils.givePlayerItem(playerEntity, playerHand, itemToGive, true, true);
            }
            return ProductiveBeesCompat.isFilledBabyBeeCageItem(itemstack) ? InteractionResult.CONSUME_PARTIAL : InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public Pair<Integer, Integer> getModdedBeePrimaryAndSecondaryColors(Entity entity) {
        ConfigurableBee configurableBee;
        if (entity instanceof ConfigurableBee && !(configurableBee = (ConfigurableBee)entity).hasBeeTexture()) {
            CompoundTag nbt = configurableBee.getNBTData();
            int primary = 15046912;
            int secondary = 2298112;
            if (nbt.m_128441_("primaryColor")) {
                primary = nbt.m_128451_("primaryColor");
            }
            if (nbt.m_128441_("secondaryColor")) {
                secondary = nbt.m_128451_("secondaryColor");
            }
            return Pair.of((Object)primary, (Object)secondary);
        }
        return null;
    }
}

