/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.CrystallineFlowerBlockEntity;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.HoneyCocoonBlockEntity;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modinit.BzLootFunctionTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class DropContainerItems
extends LootItemConditionalFunction {
    public DropContainerItems(LootItemCondition[] itemConditions) {
        super(itemConditions);
    }

    public LootItemFunctionType m_7162_() {
        return BzLootFunctionTypes.DROP_CONTAINER_ITEMS.get();
    }

    public ItemStack m_7372_(ItemStack itemStack, LootContext lootContext) {
        ServerLevel level = lootContext.m_78952_();
        Vec3 spawnPos = (Vec3)lootContext.m_78953_(LootContextParams.f_81460_);
        BlockEntity be = (BlockEntity)lootContext.m_78953_(LootContextParams.f_81462_);
        if (spawnPos != null && be instanceof Container) {
            HoneyCocoonBlockEntity honeyCocoonBlockEntity;
            Container container = (Container)be;
            if (!(ModChecker.lootrPresent && BzModCompatibilityConfigs.allowLootrCompat && container instanceof HoneyCocoonBlockEntity && (honeyCocoonBlockEntity = (HoneyCocoonBlockEntity)container).getLootTable() != null)) {
                Containers.m_19002_((Level)level, (BlockPos)BlockPos.m_274446_((Position)spawnPos), (Container)container);
            }
        } else if (spawnPos != null && be instanceof CrystallineFlowerBlockEntity) {
            ItemStack consumeItems;
            CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)be;
            BlockPos itemDropPos = BlockPos.m_274446_((Position)spawnPos);
            ItemStack bookItems = crystallineFlowerBlockEntity.getBookSlotItems();
            if (!bookItems.m_41619_()) {
                Containers.m_18992_((Level)level, (double)itemDropPos.m_123341_(), (double)itemDropPos.m_123342_(), (double)itemDropPos.m_123343_(), (ItemStack)bookItems);
            }
            if (!(consumeItems = crystallineFlowerBlockEntity.getConsumeSlotItems()).m_41619_()) {
                Containers.m_18992_((Level)level, (double)itemDropPos.m_123341_(), (double)itemDropPos.m_123342_(), (double)itemDropPos.m_123343_(), (ItemStack)consumeItems);
            }
        }
        return itemStack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<DropContainerItems> {
        public void serialize(JsonObject jsonObject, DropContainerItems dropContainerItems, JsonSerializationContext jsonSerializationContext) {
            super.m_6170_(jsonObject, (LootItemConditionalFunction)dropContainerItems, jsonSerializationContext);
        }

        public DropContainerItems deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] containerItems) {
            return new DropContainerItems(containerItems);
        }
    }
}

