/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.EntityHurtEvent;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CalmingEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.calmingEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> BzGeneralConfigs.calmingEssenceAbilityUse;

    public CalmingEssence(Item.Properties properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public int getColor() {
        return 44525;
    }

    @Override
    void addDescriptionComponents(List<Component> components) {
        components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_calming_description_1").m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC));
        components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_calming_description_2").m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC));
        components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_calming_description_3").m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC));
    }

    @Override
    public void applyAbilityEffects(ItemStack stack, Level level, ServerPlayer serverPlayer) {
        if (CalmingEssence.getIsActive(stack)) {
            if (((long)serverPlayer.f_19797_ + serverPlayer.m_20148_().getLeastSignificantBits()) % 12L == 0L) {
                CalmingEssence.spawnParticles(serverPlayer.m_284548_(), serverPlayer.m_20182_(), serverPlayer.m_217043_());
            }
            if (((long)serverPlayer.f_19797_ + serverPlayer.m_20148_().getLeastSignificantBits()) % 20L == 0L) {
                serverPlayer.m_8951_().m_6085_((Player)serverPlayer, Stats.f_12988_.m_12902_((Object)Stats.f_12992_), 0);
                for (Entity entity : level.m_45933_((Entity)serverPlayer, serverPlayer.m_20191_().m_82400_(60.0))) {
                    Warden warden;
                    NeutralMob neutralMob;
                    Mob mob;
                    if (entity.m_6095_().m_204039_(BzTags.CALMING_ALLOW_ANGER_THROUGH)) continue;
                    if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() == serverPlayer) {
                        mob.m_6710_(null);
                    }
                    if (entity instanceof NeutralMob && (neutralMob = (NeutralMob)entity).m_6120_() == serverPlayer.m_20148_()) {
                        neutralMob.m_21662_();
                    }
                    if (!(entity instanceof Warden) || (warden = (Warden)entity).m_219449_().m_219256_().orElse(null) != serverPlayer) continue;
                    warden.m_219428_((Entity)serverPlayer);
                }
                if (serverPlayer.m_21195_(BzEffects.WRATH_OF_THE_HIVE.get())) {
                    this.decrementAbilityUseRemaining(stack, serverPlayer, this.getAbilityUseRemaining(stack));
                } else if (serverPlayer.m_20142_()) {
                    this.decrementAbilityUseRemaining(stack, serverPlayer, 60);
                } else {
                    this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
                }
            }
        }
    }

    private void depleteEssence(ItemStack stack, ServerPlayer serverPlayer) {
        this.setAbilityUseRemaining(stack, 0);
        this.setDepleted(stack, serverPlayer, false);
    }

    public static boolean IsCalmingEssenceActive(Player player) {
        if (player != null) {
            ItemStack offHandItem = player.m_21206_();
            return offHandItem.m_150930_(BzItems.ESSENCE_CALMING.get()) && CalmingEssence.getIsActive(offHandItem);
        }
        return false;
    }

    public static void OnAttack(EntityHurtEvent event) {
        Entity entity;
        DamageSource damageSource = event.source();
        LivingEntity livingEntity = event.entity();
        if (livingEntity instanceof Mob && (entity = damageSource.m_7639_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            offHandItem = serverPlayer.m_21206_();
            Item item = offHandItem.m_41720_();
            if (item instanceof CalmingEssence) {
                CalmingEssence calmingEssence = (CalmingEssence)item;
                if (CalmingEssence.IsCalmingEssenceActive((Player)serverPlayer)) {
                    calmingEssence.depleteEssence(offHandItem, serverPlayer);
                }
            }
        } else if (livingEntity instanceof ServerPlayer) {
            Item item;
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (damageSource.m_7639_() instanceof Mob && (item = (offHandItem = serverPlayer.m_21206_()).m_41720_()) instanceof CalmingEssence) {
                CalmingEssence calmingEssence = (CalmingEssence)item;
                if (CalmingEssence.IsCalmingEssenceActive((Player)serverPlayer)) {
                    calmingEssence.depleteEssence(offHandItem, serverPlayer);
                }
            }
        }
    }

    public static void spawnParticles(ServerLevel world, Vec3 location, RandomSource random) {
        world.m_8767_((ParticleOptions)BzParticles.SPARKLE_PARTICLE.get(), location.m_7096_(), location.m_7098_() + 1.0, location.m_7094_(), 1, random.m_188583_() * 0.2, random.m_188583_() * 0.25 + 0.1, random.m_188583_() * 0.2, 0.0);
    }
}

