/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.PollenPuff;
import com.telepathicgrunt.the_bumblezone.mixin.effects.MobEffectInstanceAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class HoneyBeeLeggings
extends BeeArmor {
    public HoneyBeeLeggings(ArmorMaterial material, ArmorItem.Type armorType, Item.Properties properties, int variant) {
        super(material, armorType, properties, variant, false);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(BzTags.BEE_ARMOR_REPAIR_ITEMS);
    }

    public void onArmorTick(ItemStack itemstack, Level level, Player player) {
        this.bz$onArmorTick(itemstack, level, player);
    }

    @Override
    public void bz$onArmorTick(ItemStack itemstack, Level level, Player player) {
        if (player.m_5833_()) {
            return;
        }
        if (player.m_36335_().m_41519_(itemstack.m_41720_())) {
            return;
        }
        RandomSource random = player.m_217043_();
        boolean isPollinated = HoneyBeeLeggings.isPollinated(itemstack);
        boolean isSprinting = player.m_20142_();
        int beeWearablesCount = BeeArmor.getBeeThemedWearablesCount((Entity)player);
        HoneyBeeLeggings.pollenBehavior(itemstack, level, (LivingEntity)player, random, isPollinated, isSprinting, beeWearablesCount);
        HoneyBeeLeggings.effectBehavior(itemstack, level, (LivingEntity)player, random, beeWearablesCount);
        HoneyBeeLeggings.spawnParticles(level, (LivingEntity)player, random, isPollinated, isSprinting, beeWearablesCount);
    }

    private static void pollenBehavior(ItemStack itemstack, Level level, LivingEntity livingEntity, RandomSource random, boolean isPollinated, boolean isSprinting, int beeWearablesCount) {
        if (!level.m_5776_()) {
            ServerPlayer serverPlayer;
            boolean ejectPollen;
            boolean bl = ejectPollen = livingEntity.m_6144_() && isPollinated;
            if (!ejectPollen && isPollinated && level.m_46467_() % 3L == 0L) {
                BlockState state;
                if (livingEntity.m_20075_().m_204336_(BzTags.HONEY_BEE_BOOTS_REMOVES_POLLEN_BLOCKS)) {
                    ejectPollen = true;
                    if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer2 = (ServerPlayer)livingEntity;
                        BzCriterias.HONEY_BEE_LEGGINGS_POLLEN_REMOVAL_TRIGGER.trigger(serverPlayer2);
                    }
                }
                if (!ejectPollen && (state = level.m_8055_(livingEntity.m_20183_())).m_60819_().m_205070_(BzTags.HONEY_BEE_BOOTS_REMOVES_POLLEN_FLUIDS)) {
                    ejectPollen = true;
                    if (livingEntity instanceof ServerPlayer) {
                        serverPlayer = (ServerPlayer)livingEntity;
                        BzCriterias.HONEY_BEE_LEGGINGS_POLLEN_REMOVAL_TRIGGER.trigger(serverPlayer);
                    }
                }
            }
            if (ejectPollen) {
                HoneyBeeLeggings.removeAndSpawnPollen(level, livingEntity.m_20182_(), itemstack);
                if (!level.m_5776_() && random.m_188501_() < 0.1f) {
                    itemstack.m_41622_(1, livingEntity, playerEntity -> playerEntity.m_21166_(EquipmentSlot.LEGS));
                }
            } else if (!livingEntity.m_6144_() && !isPollinated) {
                BlockState withinBlock = level.m_8055_(livingEntity.m_20183_());
                if (withinBlock.m_60713_(BzBlocks.PILE_OF_POLLEN.get())) {
                    HoneyBeeLeggings.setPollinated(itemstack);
                    int newLevel = (Integer)withinBlock.m_61143_((Property)PileOfPollen.LAYERS) - 1;
                    if (newLevel == 0) {
                        level.m_7731_(livingEntity.m_20183_(), Blocks.f_50016_.m_49966_(), 3);
                    } else {
                        level.m_7731_(livingEntity.m_20183_(), (BlockState)withinBlock.m_61124_((Property)PileOfPollen.LAYERS, (Comparable)Integer.valueOf(newLevel)), 3);
                    }
                } else {
                    float f = random.m_188501_();
                    float f2 = (float)(beeWearablesCount - 1) * 0.015f;
                    float f3 = isSprinting ? 0.015f : 0.00333f;
                    if (f < f2 + f3 && withinBlock.m_204336_(BlockTags.f_13041_)) {
                        HoneyBeeLeggings.setPollinated(itemstack);
                        if (livingEntity instanceof ServerPlayer) {
                            serverPlayer = (ServerPlayer)livingEntity;
                            BzCriterias.HONEY_BEE_LEGGINGS_FLOWER_POLLEN_TRIGGER.trigger(serverPlayer);
                            serverPlayer.m_36220_(BzStats.HONEY_BEE_LEGGINGS_FLOWER_POLLEN_RL.get());
                        }
                    }
                }
            }
        }
    }

    private static void effectBehavior(ItemStack itemstack, Level level, LivingEntity livingEntity, RandomSource random, int beeWearablesCount) {
        MobEffectInstance slowness = livingEntity.m_21124_(MobEffects.f_19597_);
        if (slowness != null && (beeWearablesCount >= 3 || level.m_46467_() % 2L == 0L)) {
            for (int i = 0; i <= Math.max(beeWearablesCount - 2, 1); ++i) {
                if (slowness.m_19557_() <= 0) continue;
                ((MobEffectInstanceAccessor)slowness).bumblezone$callTickDownDuration();
            }
            if (!level.m_5776_() && random.m_188501_() < 0.004f && itemstack.m_41776_() - itemstack.m_41773_() > 1) {
                itemstack.m_41622_(1, livingEntity, playerEntity -> playerEntity.m_21166_(EquipmentSlot.LEGS));
            }
        }
    }

    private static void spawnParticles(Level world, LivingEntity livingEntity, RandomSource random, boolean isPollinated, boolean isSprinting, int beeWearablesCount) {
        block3: {
            block4: {
                if (!world.m_5776_() || !isPollinated) break block3;
                if (isSprinting) break block4;
                float f = random.m_188501_();
                float f2 = beeWearablesCount >= 3 ? 0.03f : 0.025f;
                if (!(f < f2)) break block3;
            }
            int particles = beeWearablesCount >= 3 ? 2 : 1;
            for (int i = 0; i < particles; ++i) {
                double speedYModifier = isSprinting ? 0.05 : 0.02;
                double speedXZModifier = isSprinting ? 0.03 : 0.02;
                double xOffset = (double)random.m_188501_() * 0.1 - 0.05;
                double yOffset = (double)random.m_188501_() * 0.1 + 0.25;
                double zOffset = (double)random.m_188501_() * 0.1 - 0.05;
                Vec3 pos = livingEntity.m_20182_();
                world.m_6493_((ParticleOptions)BzParticles.POLLEN_PARTICLE.get(), true, pos.m_7096_() + xOffset, pos.m_7098_() + yOffset, pos.m_7094_() + zOffset, random.m_188583_() * speedXZModifier, (random.m_188583_() + 0.25) * speedYModifier, random.m_188583_() * speedXZModifier);
            }
        }
    }

    public static void armorStandTick(LivingEntity livingEntity) {
        ArmorStand armorStand;
        ItemStack leggings;
        if (livingEntity instanceof ArmorStand && (leggings = (armorStand = (ArmorStand)livingEntity).m_6844_(EquipmentSlot.LEGS)).m_41720_() instanceof HoneyBeeLeggings) {
            Level level = armorStand.m_9236_();
            RandomSource random = armorStand.m_217043_();
            boolean isPollinated = HoneyBeeLeggings.isPollinated(leggings);
            boolean isSprinting = armorStand.m_20142_();
            int beeWearablesCount = BeeArmor.getBeeThemedWearablesCount((Entity)armorStand);
            HoneyBeeLeggings.pollenBehavior(leggings, level, (LivingEntity)armorStand, random, isPollinated, isSprinting, beeWearablesCount);
        }
    }

    public static ItemStack getEntityBeeLegging(Entity entity) {
        for (ItemStack armor : entity.m_6168_()) {
            if (!(armor.m_41720_() instanceof HoneyBeeLeggings)) continue;
            return armor;
        }
        return ItemStack.f_41583_;
    }

    public static void setPollinated(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof HoneyBeeLeggings) {
            itemStack.m_41784_().m_128379_("pollinated", true);
        }
    }

    public static void clearPollinated(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof HoneyBeeLeggings) {
            itemStack.m_41784_().m_128379_("pollinated", false);
        }
    }

    public static boolean isPollinated(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof HoneyBeeLeggings && itemStack.m_41782_() && itemStack.m_41783_().m_128471_("pollinated");
    }

    public static void removeAndSpawnPollen(Level world, Vec3 position, ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof HoneyBeeLeggings) {
            PollenPuff.spawnItemstackEntity(world, position.m_82549_(new Vec3(0.0, 0.25, 0.0)), new ItemStack((ItemLike)BzItems.POLLEN_PUFF.get(), 1));
            HoneyBeeLeggings.clearPollinated(itemStack);
        }
    }
}

