/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.client.rendering.beequeen.BeeQueenPose;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeeQueenAlwaysLookAtPlayerGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeeQueenAngerableMeleeAttackGoal;
import com.telepathicgrunt.the_bumblezone.entities.navigation.DirectPathNavigator;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.mixin.entities.ItemEntityAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.PlayerAdvancementsAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.PlayerDataHandler;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import com.telepathicgrunt.the_bumblezone.packets.TradeHintParticleSpawnPacket;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BeeQueenEntity
extends Animal
implements NeutralMob {
    private static final TargetingConditions PLAYER_ACKNOWLEDGE_SIGHT = TargetingConditions.m_148353_().m_26883_(10.0);
    public static final int TRADE_HINT_PARTICLE_LIFETIME = 200;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState itemThrownAnimationState = new AnimationState();
    public final AnimationState itemRejectAnimationState = new AnimationState();
    public static final EntityDataSerializer<BeeQueenPose> QUEEN_POSE_SERIALIZER = EntityDataSerializer.m_238090_(BeeQueenPose.class);
    private static final EntityDataAccessor<Integer> THROWCOOLDOWN = SynchedEntityData.m_135353_(BeeQueenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BEESPAWNCOOLDOWN = SynchedEntityData.m_135353_(BeeQueenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(BeeQueenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BeeQueenPose> QUEEN_POSE = SynchedEntityData.m_135353_(BeeQueenEntity.class, QUEEN_POSE_SERIALIZER);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)60, (int)120);
    private UUID persistentAngerTarget;
    private int underWaterTicks;
    private int poseTicks;
    private int tradeHintCooldown = 0;
    private boolean isSpecialDay = false;
    private static final WeightedTradeResult ESSENCE_DROP = new WeightedTradeResult(null, Optional.of(List.of(BzItems.ESSENCE_OF_THE_BEES.get())), 1, 1000, 1);
    private static final ResourceLocation BEE_ESSENCE_ADVANCEMENT_RL = new ResourceLocation("the_bumblezone", "essence/bee_essence_infusion");

    public BeeQueenEntity(EntityType<? extends BeeQueenEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(THROWCOOLDOWN, (Object)0);
        this.f_19804_.m_135372_(REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(BEESPAWNCOOLDOWN, (Object)0);
        this.f_19804_.m_135372_(QUEEN_POSE, (Object)BeeQueenPose.NONE);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (QUEEN_POSE.equals(entityDataAccessor)) {
            BeeQueenPose pose = this.getQueenPose();
            this.setAnimationState(pose, BeeQueenPose.ATTACKING, this.attackAnimationState);
            this.setAnimationState(pose, BeeQueenPose.ITEM_REJECT, this.itemRejectAnimationState);
            this.setAnimationState(pose, BeeQueenPose.ITEM_THROW, this.itemThrownAnimationState);
        }
        super.m_7350_(entityDataAccessor);
    }

    private void setAnimationState(BeeQueenPose pose, BeeQueenPose poseToCheckFor, AnimationState animationState) {
        if (pose == poseToCheckFor) {
            animationState.m_216977_(this.f_19797_);
        } else {
            animationState.m_216973_();
        }
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22281_, 10.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new BeeQueenAngerableMeleeAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BeeQueenAlwaysLookAtPlayerGoal((Mob)this, Player.class, 60.0f));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("throwcooldown", this.getThrowCooldown());
        tag.m_128405_("beespawncooldown", this.getBeeSpawnCooldown());
        this.m_21678_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setThrowCooldown(tag.m_128451_("throwcooldown"));
        this.setBeeSpawnCooldown(tag.m_128451_("beespawncooldown"));
        this.m_147285_(this.m_9236_(), tag);
    }

    public void setIsSpecialDay(boolean isSpecialDay) {
        this.isSpecialDay = isSpecialDay;
    }

    public boolean getIsSpecialDay() {
        return this.isSpecialDay;
    }

    public void setQueenPose(BeeQueenPose beeQueenPose) {
        this.f_19804_.m_135381_(QUEEN_POSE, (Object)beeQueenPose);
    }

    public BeeQueenPose getQueenPose() {
        return (BeeQueenPose)((Object)this.f_19804_.m_135370_(QUEEN_POSE));
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new DirectPathNavigator((Mob)this, pLevel);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor iWorld, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        return true;
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType spawnReason) {
        return true;
    }

    public boolean m_6914_(LevelReader worldReader) {
        AABB box = this.m_20191_();
        return !worldReader.m_46855_(box) && worldReader.m_45556_(box).noneMatch(state -> state.m_280555_()) && worldReader.m_45784_((Entity)this);
    }

    public boolean m_6094_() {
        return false;
    }

    public double m_6048_() {
        return this.m_6972_((Pose)Pose.STANDING).f_20378_ * 0.9f;
    }

    public void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(entity)) {
            double riderYOffset = this.m_20186_() + this.m_6048_() + entity.m_6049_();
            Vec3 forwardVect = Vec3.m_82498_((float)0.0f, (float)this.m_213816_());
            Vec3 sideVect = Vec3.m_82498_((float)0.0f, (float)(this.m_213816_() - 90.0f));
            moveFunction.m_20372_(entity, this.m_20185_() + sideVect.m_7096_() - forwardVect.m_7096_() * 0.5, riderYOffset, this.m_20189_() + sideVect.m_7094_() - forwardVect.m_7094_() * 0.5);
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource == this.m_9236_().m_269111_().m_269555_()) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public void m_7601_(BlockState blockState, Vec3 speedMult) {
        if (blockState.m_60734_() instanceof SweetBerryBushBlock) {
            return;
        }
        super.m_7601_(blockState, speedMult);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        LivingEntity livingEntity;
        Entity entity;
        Snowball snowball;
        Entity entity2 = source.m_7640_();
        if (entity2 instanceof Snowball && (snowball = (Snowball)entity2).m_6095_() == EntityType.f_20477_ && QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.containsKey((Object)Items.f_42452_)) {
            if (!this.m_9236_().m_5776_()) {
                Vec3 forwardVect = Vec3.m_82498_((float)0.0f, (float)this.m_213816_());
                Vec3 sideVect = Vec3.m_82498_((float)0.0f, (float)(this.m_213816_() - 90.0f));
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), 0.0, 0.0, 0.0, Items.f_42452_.m_7968_());
                Entity entity3 = snowball.m_19749_();
                if (entity3 instanceof Player) {
                    Player player = (Player)entity3;
                    itemEntity.m_32052_(player.m_20148_());
                }
                this.tradeItemEntity(itemEntity, forwardVect, sideVect);
            }
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.m_20092_() && source == this.m_9236_().m_269111_().m_269318_()) {
            this.spawnAngryParticles(6);
            this.m_6677_(source);
            return false;
        }
        if (!(this.m_21525_() || !((entity = source.m_7639_()) instanceof LivingEntity) || (livingEntity = (LivingEntity)entity).m_5833_() || livingEntity.m_6095_().m_204039_(BzTags.FORCED_BEE_CALM_AT) || BeeAggression.isBeelikeEntity((Entity)livingEntity))) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL || player.m_7500_()) {
                    this.spawnAngryParticles(6);
                    return super.m_6469_(source, amount);
                }
            }
            if ((livingEntity.m_9236_().m_46472_().equals(BzDimension.BZ_WORLD_KEY) || BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone) && BzBeeAggressionConfigs.aggressiveBees) {
                if (livingEntity.m_21023_(BzEffects.PROTECTION_OF_THE_HIVE.get())) {
                    livingEntity.m_21195_(BzEffects.PROTECTION_OF_THE_HIVE.get());
                } else {
                    livingEntity.m_7292_(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.get(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 3, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
                }
            }
            this.m_6825_();
            this.m_6925_(livingEntity.m_20148_());
            this.m_6710_(livingEntity);
        }
        this.spawnAngryParticles(6);
        return super.m_6469_(source, amount);
    }

    protected void m_8024_() {
        this.underWaterTicks = this.m_5842_() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 100) {
            this.m_6469_(this.m_9236_().m_269111_().m_269063_(), 3.0f);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), false);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        } else {
            this.idleAnimationState.m_216973_();
        }
        BeeQueenPose pose = this.getQueenPose();
        if (pose != BeeQueenPose.NONE) {
            if (pose == BeeQueenPose.ATTACKING && this.poseTicks > 17) {
                this.setQueenPose(BeeQueenPose.NONE);
                this.poseTicks = 0;
            }
            if (pose == BeeQueenPose.ITEM_REJECT && this.poseTicks > 20) {
                this.setQueenPose(BeeQueenPose.NONE);
                this.poseTicks = 0;
            }
            if (pose == BeeQueenPose.ITEM_THROW && this.poseTicks > 20) {
                this.setQueenPose(BeeQueenPose.NONE);
                this.poseTicks = 0;
            }
            ++this.poseTicks;
        }
        if (!this.m_21525_()) {
            if (!this.m_9236_().m_5776_() && this.m_9236_().m_46467_() % 200L == 0L && !this.m_21224_()) {
                this.m_5634_(1.0f);
            }
            if (!this.m_9236_().m_5776_()) {
                if (this.m_21660_()) {
                    this.performAngryActions();
                } else {
                    this.performGroundTrades();
                }
            }
            if (!this.m_9236_().m_5776_()) {
                if (BzGeneralConfigs.beeQueenSpecialDayTrades && (this.f_19797_ == 1 || ((long)this.f_19797_ + this.m_20148_().getLeastSignificantBits()) % 72000L == 0L)) {
                    Optional<List<Item>> specialDayItem = QueensTradeManager.QUEENS_TRADE_MANAGER.getSpecialDayItem();
                    List<Item> allowedSpecialDayTradeItems = ((List)specialDayItem.orElse(new ArrayList())).stream().filter(i -> i.m_245993_(this.m_9236_().m_246046_())).toList();
                    this.setIsSpecialDay(!allowedSpecialDayTradeItems.isEmpty());
                }
                if (this.tradeHintCooldown == 0 && ((long)this.f_19797_ + this.m_20148_().getLeastSignificantBits()) % 40L == 0L) {
                    List nearbyPlayers = this.m_9236_().m_45955_(PLAYER_ACKNOWLEDGE_SIGHT, (LivingEntity)this, this.m_20191_().m_82400_(10.0));
                    for (Player player : nearbyPlayers) {
                        if (!this.isLookingAtMeClose(player)) continue;
                        Item wantItem = null;
                        List tradeResults = null;
                        if (this.getIsSpecialDay()) {
                            Optional<Pair<QueensTradeManager.SpecialDaysEntry, WeightedRandomList<WeightedTradeResult>>> specialDayRewards;
                            Optional<List<Item>> specialDayItem = QueensTradeManager.QUEENS_TRADE_MANAGER.getSpecialDayItem();
                            if (specialDayItem.isEmpty()) {
                                this.setIsSpecialDay(false);
                            }
                            if ((specialDayRewards = QueensTradeManager.QUEENS_TRADE_MANAGER.getSpecialDayItems(wantItem = specialDayItem.get().get(this.f_19796_.m_188503_(specialDayItem.get().size())))).isEmpty()) {
                                this.setIsSpecialDay(false);
                            } else {
                                tradeResults = ((WeightedRandomList)specialDayRewards.get().getSecond()).m_146338_();
                            }
                        }
                        if (wantItem == null || tradeResults == null) {
                            ObjectSet keySet = QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.keySet();
                            wantItem = keySet.stream().skip(this.f_19796_.m_188503_(keySet.size())).findFirst().orElse(null);
                            tradeResults = ((WeightedRandomList)QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.get((Object)wantItem)).m_146338_();
                        }
                        int maximumRewardsToShowAtATime = 5;
                        ArrayList<Item> allRewardItems = new ArrayList<Item>();
                        for (WeightedTradeResult weightedTradeResult : tradeResults) {
                            allRewardItems.addAll(weightedTradeResult.getItems());
                        }
                        Collections.shuffle(allRewardItems);
                        List<Item> slicedRewardItems = allRewardItems.subList(0, Math.min(maximumRewardsToShowAtATime, allRewardItems.size()));
                        TradeHintParticleSpawnPacket.sendToClient((Entity)this, wantItem, slicedRewardItems);
                        this.tradeHintCooldown = 220;
                        break;
                    }
                }
                if (this.tradeHintCooldown > 0) {
                    --this.tradeHintCooldown;
                }
            }
        }
    }

    private void performAngryActions() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_5448_() instanceof Player) {
            this.m_21662_();
            return;
        }
        int beeCooldown = this.getBeeSpawnCooldown();
        if (beeCooldown <= 0 && !this.m_6107_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46134_)) {
            this.setBeeSpawnCooldown(this.f_19796_.m_188503_(50) + 75);
            BlockPos spawnBlockPos = GeneralUtils.getRandomBlockposWithinRange((LivingEntity)this, 5, 0);
            if (!this.m_9236_().m_8055_(spawnBlockPos).m_60795_()) {
                return;
            }
            Bee bee = (Bee)EntityType.f_20550_.m_20615_(this.m_9236_());
            if (bee == null) {
                return;
            }
            bee.m_7870_(this.m_6784_());
            bee.m_6925_(this.m_6120_());
            bee.m_6710_(this.m_5448_());
            bee.m_19890_((double)spawnBlockPos.m_123341_() + 0.5, (double)spawnBlockPos.m_123342_() + 0.5, (double)spawnBlockPos.m_123343_() + 0.5, this.f_19796_.m_188501_() * 360.0f, 0.0f);
            bee.m_6518_((ServerLevelAccessor)((ServerLevel)this.m_9236_()), this.m_9236_().m_6436_(spawnBlockPos), MobSpawnType.TRIGGERED, null, null);
            bee.m_7292_(new MobEffectInstance(MobEffects.f_19615_, Integer.MAX_VALUE, 0, true, false, false));
            this.m_9236_().m_7967_((Entity)bee);
            this.spawnAngryParticles(6);
            this.setQueenPose(BeeQueenPose.ATTACKING);
        } else {
            this.setBeeSpawnCooldown(beeCooldown - 1);
        }
    }

    private void performGroundTrades() {
        if (!BzGeneralConfigs.beeQueenGroundPickup) {
            return;
        }
        int throwCooldown = this.getThrowCooldown();
        if (throwCooldown > 0) {
            this.setThrowCooldown(throwCooldown - 1);
        }
        if ((this.m_9236_().m_46467_() + this.m_20148_().getLeastSignificantBits()) % 20L == 0L && throwCooldown <= 0) {
            Vec3 forwardVect = Vec3.m_82498_((float)0.0f, (float)this.m_213816_());
            Vec3 sideVect = Vec3.m_82498_((float)0.0f, (float)(this.m_213816_() - 90.0f));
            AABB scanArea = this.m_20191_().m_165897_(0.45, 0.9, 0.45).m_82386_(forwardVect.m_7096_() * 0.5, -0.95, forwardVect.m_7094_() * 0.5);
            List items = this.m_9236_().m_45976_(ItemEntity.class, scanArea);
            items.stream().filter(ie -> !ie.m_32063_()).findFirst().ifPresent(itemEntity -> this.tradeItemEntity((ItemEntity)itemEntity, forwardVect, sideVect));
        }
    }

    private void tradeItemEntity(ItemEntity itemEntity, Vec3 forwardVect, Vec3 sideVect) {
        Player player;
        Optional reward;
        int tradedItems = 0;
        Item item = itemEntity.m_32055_().m_41720_();
        boolean didSpecialDayTrade = false;
        if (this.getIsSpecialDay() && QueensTradeManager.QUEENS_TRADE_MANAGER.specialDayQueenTrades.containsKey((Object)item)) {
            Optional<Pair<QueensTradeManager.SpecialDaysEntry, WeightedRandomList<WeightedTradeResult>>> specialDayItems = QueensTradeManager.QUEENS_TRADE_MANAGER.getSpecialDayItems(item);
            if (specialDayItems.isPresent()) {
                reward = ((WeightedRandomList)specialDayItems.get().getSecond()).m_216829_(this.f_19796_);
                if (reward.isPresent()) {
                    this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), itemEntity.m_32055_(), ((ItemEntityAccessor)itemEntity).bumblezone$getThrower(), (QueensTradeManager.SpecialDaysEntry)specialDayItems.get().getFirst());
                    ++tradedItems;
                }
            } else {
                this.setIsSpecialDay(false);
            }
        }
        if (!didSpecialDayTrade && QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.containsKey((Object)item)) {
            for (int i = 0; i < itemEntity.m_32055_().m_41613_(); ++i) {
                reward = ((WeightedRandomList)QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.get((Object)item)).m_216829_(this.f_19796_);
                if (!reward.isPresent()) continue;
                this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), itemEntity.m_32055_(), ((ItemEntityAccessor)itemEntity).bumblezone$getThrower());
                ++tradedItems;
            }
        }
        if (tradedItems > 0) {
            itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            ItemEntity rejectedItemEntity = new ItemEntity(this.m_9236_(), this.m_20185_() + sideVect.m_7096_() * 1.75 + forwardVect.m_7096_() * 1.0, this.m_20186_() + 0.3, this.m_20189_() + sideVect.m_7094_() * 1.75 + forwardVect.m_7096_() * 1.0, itemEntity.m_32055_(), (double)((this.f_19796_.m_188501_() - 0.5f) / 10.0f) + forwardVect.m_7096_() / 3.0, (double)0.4f, (double)((this.f_19796_.m_188501_() - 0.5f) / 10.0f) + forwardVect.m_7094_() / 3.0);
            this.m_9236_().m_7967_((Entity)rejectedItemEntity);
            rejectedItemEntity.m_32060_();
            this.spawnAngryParticles(2);
            this.setQueenPose(BeeQueenPose.ITEM_REJECT);
        }
        this.setThrowCooldown(50);
        if (tradedItems > 0 && itemEntity.m_19749_() != null && (player = this.m_9236_().m_46003_(itemEntity.m_19749_().m_20148_())) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BzCriterias.BEE_QUEEN_FIRST_TRADE_TRIGGER.trigger(serverPlayer);
            PlayerDataHandler.onQueenBeeTrade((Player)serverPlayer, tradedItems);
            if (BeeQueenEntity.finalbeeQueenAdvancementDone(serverPlayer)) {
                ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> {
                    if (!capability.receivedEssencePrize) {
                        this.spawnReward(forwardVect, sideVect, ESSENCE_DROP, ItemStack.f_41583_, serverPlayer.m_20148_());
                        capability.receivedEssencePrize = true;
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"entity.the_bumblezone.bee_queen.mention_reset").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GOLD), false);
                    }
                });
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_21525_()) {
            return InteractionResult.PASS;
        }
        if (this.m_21660_() || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (stack.m_41619_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (BeeQueenEntity.finalbeeQueenAdvancementDone(serverPlayer)) {
                ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> {
                    if (!capability.receivedEssencePrize) {
                        Vec3 forwardVect = Vec3.m_82498_((float)0.0f, (float)this.m_213816_());
                        Vec3 sideVect = Vec3.m_82498_((float)0.0f, (float)(this.m_213816_() - 90.0f));
                        this.spawnReward(forwardVect, sideVect, ESSENCE_DROP, ItemStack.f_41583_, serverPlayer.m_20148_());
                        capability.receivedEssencePrize = true;
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"entity.the_bumblezone.bee_queen.mention_reset").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GOLD), false);
                    } else {
                        long timeDiff = this.m_9236_().m_46467_() - capability.tradeResetPrimedTime;
                        if (timeDiff < 200L && timeDiff > 10L) {
                            this.resetAdvancementTree(serverPlayer, BzCriterias.QUEENS_DESIRE_ROOT_ADVANCEMENT);
                            capability.resetAllTrackerStats();
                            serverPlayer.m_5661_((Component)Component.m_237115_((String)"entity.the_bumblezone.bee_queen.reset_advancements").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GOLD), false);
                        } else {
                            capability.tradeResetPrimedTime = this.m_9236_().m_46467_();
                            serverPlayer.m_5661_((Component)Component.m_237115_((String)"entity.the_bumblezone.bee_queen.advancements_warning").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GOLD), false);
                        }
                    }
                });
            }
            return InteractionResult.PASS;
        }
        boolean traded = false;
        if (QueensTradeManager.QUEENS_TRADE_MANAGER.specialDayQueenTrades.containsKey((Object)item)) {
            Optional<Pair<QueensTradeManager.SpecialDaysEntry, WeightedRandomList<WeightedTradeResult>>> specialDayItems = QueensTradeManager.QUEENS_TRADE_MANAGER.getSpecialDayItems(item);
            if (specialDayItems.isPresent()) {
                if (this.m_9236_().m_5776_()) {
                    return InteractionResult.SUCCESS;
                }
                Vec3 forwardVect = Vec3.m_82498_((float)0.0f, (float)this.m_213816_());
                Vec3 sideVect = Vec3.m_82498_((float)0.0f, (float)(this.m_213816_() - 90.0f));
                Optional reward = ((WeightedRandomList)specialDayItems.get().getSecond()).m_216829_(this.f_19796_);
                if (reward.isPresent()) {
                    this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), stack, player.m_20148_(), (QueensTradeManager.SpecialDaysEntry)specialDayItems.get().getFirst());
                    traded = true;
                }
            } else {
                this.setIsSpecialDay(false);
            }
        }
        if (!traded && QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.containsKey((Object)item)) {
            if (this.m_9236_().m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            Vec3 forwardVect = Vec3.m_82498_((float)0.0f, (float)this.m_213816_());
            Vec3 sideVect = Vec3.m_82498_((float)0.0f, (float)(this.m_213816_() - 90.0f));
            Optional reward = ((WeightedRandomList)QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.get((Object)item)).m_216829_(this.f_19796_);
            if (reward.isPresent()) {
                this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), stack, player.m_20148_());
                traded = true;
            }
        }
        if (!this.m_9236_().m_5776_()) {
            if (!traded) {
                this.spawnAngryParticles(2);
                this.setQueenPose(BeeQueenPose.ITEM_REJECT);
            } else {
                this.setThrowCooldown(50);
                stack.m_41774_(1);
                player.m_21008_(hand, stack);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    BzCriterias.BEE_QUEEN_FIRST_TRADE_TRIGGER.trigger(serverPlayer);
                    PlayerDataHandler.onQueenBeeTrade((Player)serverPlayer);
                    if (BeeQueenEntity.finalbeeQueenAdvancementDone(serverPlayer)) {
                        ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> {
                            if (!capability.receivedEssencePrize) {
                                Vec3 forwardVect = Vec3.m_82498_((float)0.0f, (float)this.m_213816_());
                                Vec3 sideVect = Vec3.m_82498_((float)0.0f, (float)(this.m_213816_() - 90.0f));
                                this.spawnReward(forwardVect, sideVect, ESSENCE_DROP, ItemStack.f_41583_, serverPlayer.m_20148_());
                                capability.receivedEssencePrize = true;
                                serverPlayer.m_5661_((Component)Component.m_237115_((String)"entity.the_bumblezone.bee_queen.mention_reset").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GOLD), false);
                            }
                        });
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void resetAdvancementTree(ServerPlayer serverPlayer, ResourceLocation advancementRL) {
        Advancement parentAdvancement = serverPlayer.f_8924_.m_129889_().m_136041_(advancementRL);
        if (parentAdvancement == null) {
            return;
        }
        Iterable advancements = parentAdvancement.m_138322_();
        for (Advancement advancement : advancements) {
            if (advancement.m_138327_().equals((Object)BEE_ESSENCE_ADVANCEMENT_RL)) continue;
            AdvancementProgress advancementprogress = serverPlayer.m_8960_().m_135996_(advancement);
            for (String criteria : advancementprogress.m_8220_()) {
                serverPlayer.m_8960_().m_135998_(advancement, criteria);
            }
            this.resetAdvancementTree(serverPlayer, advancement.m_138327_());
        }
    }

    private static boolean finalbeeQueenAdvancementDone(ServerPlayer serverPlayer) {
        Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(BzCriterias.QUEENS_DESIRE_FINAL_ADVANCEMENT);
        Map<Advancement, AdvancementProgress> advancementsProgressMap = ((PlayerAdvancementsAccessor)serverPlayer.m_8960_()).bumblezone$getProgress();
        return advancement != null && advancementsProgressMap.containsKey(advancement) && advancementsProgressMap.get(advancement).m_8193_();
    }

    private boolean isContainerBlockEntity(ItemStack itemStack) {
        EntityBlock block;
        BlockItem blockItem;
        Item item = itemStack.m_41720_();
        return item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof EntityBlock && (block = (EntityBlock)item).m_142194_(this.m_20183_(), blockItem.m_40614_().m_49966_()) instanceof Container;
    }

    private void spawnReward(Vec3 forwardVect, Vec3 sideVect, WeightedTradeResult reward, ItemStack originalItem, UUID playerUUID) {
        this.spawnReward(forwardVect, sideVect, reward, originalItem, playerUUID, null);
    }

    private void spawnReward(Vec3 forwardVect, Vec3 sideVect, WeightedTradeResult reward, ItemStack originalItem, UUID playerUUID, QueensTradeManager.SpecialDaysEntry specialDaysEntry) {
        int currentItemStackCount;
        Player player;
        int rewardMultiplier = 1;
        if (specialDaysEntry != null && playerUUID != null && (player = this.m_9236_().m_46003_(playerUUID)) != null) {
            player.m_5661_((Component)Component.m_237115_((String)specialDaysEntry.specialMessage()).m_130940_(specialDaysEntry.textColor()), true);
        }
        Item chosenItem = reward.getItems().get(this.f_19796_.m_188503_(reward.getItems().size()));
        int itemStackMaxSize = chosenItem.m_41459_();
        for (int remainingItemToSpawn = reward.count * rewardMultiplier; remainingItemToSpawn > 0; remainingItemToSpawn -= currentItemStackCount) {
            Level level;
            ItemStack rewardItem = chosenItem.m_7968_();
            this.setQueenPose(BeeQueenPose.ITEM_THROW);
            if (originalItem.m_204117_(ItemTags.f_13191_) && rewardItem.m_204117_(ItemTags.f_13191_) && originalItem.m_41782_()) {
                rewardItem.m_41784_().m_128391_(originalItem.m_41784_());
            } else if (originalItem.m_150930_(rewardItem.m_41720_()) && originalItem.m_41782_()) {
                rewardItem.m_41784_().m_128391_(originalItem.m_41784_());
            } else if (this.isContainerBlockEntity(originalItem) && this.isContainerBlockEntity(rewardItem) && originalItem.m_41782_()) {
                rewardItem.m_41784_().m_128391_(originalItem.m_41784_());
            }
            currentItemStackCount = Math.min(remainingItemToSpawn, itemStackMaxSize);
            rewardItem.m_41764_(currentItemStackCount);
            ItemEntity rewardItemEntity = new ItemEntity(this.m_9236_(), this.m_20185_() + sideVect.m_7096_() * 0.9 + forwardVect.m_7096_() * 1.0, this.m_20186_() + 0.3, this.m_20189_() + sideVect.m_7094_() * 0.9 + forwardVect.m_7096_() * 1.0, rewardItem, (double)((this.f_19796_.m_188501_() - 0.5f) / 10.0f) + forwardVect.m_7096_() / 4.0, (double)0.3f, (double)((this.f_19796_.m_188501_() - 0.5f) / 10.0f) + forwardVect.m_7094_() / 4.0);
            this.m_9236_().m_7967_((Entity)rewardItemEntity);
            rewardItemEntity.m_32060_();
            this.spawnHappyParticles();
            if (reward.xpReward <= 0 || !((level = this.m_9236_()) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)new Vec3(this.m_20185_() + forwardVect.m_7096_() * 1.0, this.m_20186_() + 0.3, this.m_20189_() + forwardVect.m_7096_() * 1.0), (int)reward.xpReward);
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), BzSounds.BEE_QUEEN_HAPPY.get(), SoundSource.NEUTRAL, 1.0f, this.m_217043_().m_188501_() * 0.2f + 0.6f);
    }

    boolean isLookingAtMeClose(Player player) {
        Vec3 normalizedPlayerView = player.m_20252_(1.0f).m_82541_();
        Vec3 diff = new Vec3(this.m_20185_() - player.m_20185_(), this.m_20188_() - 0.2 - player.m_20188_(), this.m_20189_() - player.m_20189_());
        double d = diff.m_82553_();
        double dotProduct = normalizedPlayerView.m_82526_(diff = diff.m_82541_());
        return dotProduct > 0.9 - 0.025 / d && player.m_142582_((Entity)this);
    }

    public void spawnAngryParticles(int particles) {
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.m_20185_(), this.m_20186_() + (double)0.45f, this.m_20189_(), particles, (double)(this.m_217043_().m_188501_() - 0.5f), (double)(this.m_217043_().m_188501_() * 0.4f + 0.4f), (double)(this.m_217043_().m_188501_() - 0.5f), (double)(this.m_217043_().m_188501_() * 0.8f + 0.4f));
        }
    }

    private void spawnHappyParticles() {
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_(), this.m_20186_() + 0.75, this.m_20189_(), 5, 0.8, 0.75, 0.8, (double)this.m_217043_().m_188501_() + 0.5);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        Bee bee = (Bee)EntityType.f_20550_.m_20615_((Level)serverWorld);
        bee.m_6863_(true);
        return bee;
    }

    public int m_21529_() {
        return 1;
    }

    public int m_8132_() {
        return 90;
    }

    public int getThrowCooldown() {
        return (Integer)this.f_19804_.m_135370_(THROWCOOLDOWN);
    }

    public void setThrowCooldown(Integer cooldown) {
        this.f_19804_.m_135381_(THROWCOOLDOWN, (Object)cooldown);
    }

    public int getBeeSpawnCooldown() {
        return (Integer)this.f_19804_.m_135370_(BEESPAWNCOOLDOWN);
    }

    public void setBeeSpawnCooldown(Integer cooldown) {
        this.f_19804_.m_135381_(BEESPAWNCOOLDOWN, (Object)cooldown);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(REMAINING_ANGER_TIME);
    }

    public void m_7870_(int remainingPersistentAngerTime) {
        this.f_19804_.m_135381_(REMAINING_ANGER_TIME, (Object)remainingPersistentAngerTime);
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_21662_() {
        super.m_21662_();
        this.setBeeSpawnCooldown(0);
        this.m_6710_(null);
    }

    protected void m_7355_(BlockPos pos, BlockState blockState) {
    }

    protected SoundEvent m_7515_() {
        return BzSounds.BEE_QUEEN_LOOP.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return BzSounds.BEE_QUEEN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return BzSounds.BEE_QUEEN_DEATH.get();
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.5f * this.m_20192_()), (double)(this.m_20205_() * 0.2f));
    }
}

