/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.rootmin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminGrassRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminPose;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminShieldRenderer;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.mixin.client.BlockRenderDispatcherAccessor;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class RootminRenderer
extends MobRenderer<RootminEntity, RootminModel> {
    private static final ResourceLocation SKIN = new ResourceLocation("the_bumblezone", "textures/entity/rootmin.png");

    public RootminRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new RootminModel(context.m_174023_(RootminModel.LAYER_LOCATION)), 0.7f);
        this.m_115326_(new FlowerBlockLayer((RenderLayerParent<RootminEntity, RootminModel>)this, context.m_234597_()));
        this.m_115326_(new RootminGrassRenderer(this, context.m_174027_()));
        this.m_115326_(new RootminShieldRenderer((RenderLayerParent<RootminEntity, RootminModel>)this, context.m_174027_()));
    }

    public void render(RootminEntity rootminEntity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.m_85836_();
        super.m_7392_((Mob)rootminEntity, entityYaw, partialTicks, stack, buffer, packedLight);
        this.adjustShadow(rootminEntity, partialTicks);
        stack.m_85849_();
    }

    private void adjustShadow(RootminEntity rootminEntity, float partialTicks) {
        RootminPose pose = rootminEntity.getRootminPose();
        float percentage = (20.0f - Math.max((float)rootminEntity.animationTimeBetweenHiding - partialTicks, 0.0f)) / 20.0f;
        float target = pose == RootminPose.ENTITY_TO_BLOCK ? 0.0f : 0.7f;
        float from = pose != RootminPose.ENTITY_TO_BLOCK ? 0.0f : 0.7f;
        this.f_114477_ = Mth.m_14179_((float)percentage, (float)from, (float)target);
        target = pose == RootminPose.ENTITY_TO_BLOCK ? 0.0f : 1.0f;
        from = pose != RootminPose.ENTITY_TO_BLOCK ? 0.0f : 1.0f;
        this.f_114478_ = Mth.m_14179_((float)percentage, (float)from, (float)target);
    }

    public ResourceLocation getTextureLocation(RootminEntity rootminEntity) {
        return SKIN;
    }

    protected float getBob(RootminEntity livingEntity, float f) {
        return super.m_6930_((LivingEntity)livingEntity, f);
    }

    protected float getAttackAnim(RootminEntity livingEntity, float f) {
        return super.m_115342_((LivingEntity)livingEntity, f);
    }

    protected boolean isBodyVisible(RootminEntity livingEntity) {
        return super.m_5933_((LivingEntity)livingEntity);
    }

    protected float getWhiteOverlayProgress(RootminEntity livingEntity, float f) {
        return super.m_6931_((LivingEntity)livingEntity, f);
    }

    public static class FlowerBlockLayer
    extends RenderLayer<RootminEntity, RootminModel> {
        private final BlockRenderDispatcher blockRenderer;

        public FlowerBlockLayer(RenderLayerParent<RootminEntity, RootminModel> renderLayerParent, BlockRenderDispatcher blockRenderDispatcher) {
            super(renderLayerParent);
            this.blockRenderer = blockRenderDispatcher;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, RootminEntity rootminEntity, float f, float g, float h, float j, float k, float l) {
            BlockState blockState = rootminEntity.getFlowerBlock();
            if (blockState == null) {
                return;
            }
            ModelPart rootModel = ((RootminModel)this.m_117386_()).m_142109_();
            ModelPart bodyModel = rootModel.m_171324_("body");
            poseStack.m_85836_();
            rootModel.m_104299_(poseStack);
            bodyModel.m_104299_(poseStack);
            poseStack.m_252880_(-0.5f, -0.9375f, 0.5f);
            poseStack.m_85841_(1.0f, -1.0f, -1.0f);
            this.renderSingleBlock(blockState, poseStack, multiBufferSource, packedLight, OverlayTexture.f_118083_, (BlockAndTintGetter)rootminEntity.m_9236_(), rootminEntity.m_20183_());
            if (blockState.m_60734_() instanceof DoublePlantBlock) {
                blockState = (BlockState)blockState.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
                poseStack.m_252880_(0.0f, 1.0f, 0.0f);
                this.renderSingleBlock(blockState, poseStack, multiBufferSource, packedLight, OverlayTexture.f_118083_, (BlockAndTintGetter)rootminEntity.m_9236_(), rootminEntity.m_20183_());
            }
            poseStack.m_85849_();
        }

        public void renderSingleBlock(BlockState blockState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, BlockAndTintGetter level, BlockPos blockPos) {
            RenderShape renderShape = blockState.m_60799_();
            if (renderShape == RenderShape.INVISIBLE) {
                return;
            }
            switch (renderShape) {
                case MODEL: {
                    BakedModel bakedModel = this.blockRenderer.m_110910_(blockState);
                    int k = ((BlockRenderDispatcherAccessor)this.blockRenderer).bumblezone$getBlockColors().m_92577_(blockState, level, blockPos, 1);
                    float f = (float)(k >> 16 & 0xFF) / 255.0f;
                    float g = (float)(k >> 8 & 0xFF) / 255.0f;
                    float h = (float)(k & 0xFF) / 255.0f;
                    this.blockRenderer.m_110937_().m_111067_(poseStack.m_85850_(), multiBufferSource.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)blockState, (boolean)false)), blockState, bakedModel, f, g, h, i, j);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ((BlockRenderDispatcherAccessor)this.blockRenderer).bumblezone$getBlockEntityRenderer().m_108829_(new ItemStack((ItemLike)blockState.m_60734_()), ItemDisplayContext.NONE, poseStack, multiBufferSource, i, j);
                }
            }
        }
    }
}

