/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class RotationFacingBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)3);

    protected RotationFacingBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(1))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        Direction facingDirection = (Direction)state.m_61143_((Property)FACING);
        int rotationIndex = (Integer)state.m_61143_((Property)ROTATION);
        Direction newFacingDirection = rotation.m_55954_(facingDirection);
        int newRotationIndex = RotationFacingBlock.getRotatedRotation(facingDirection, rotationIndex, rotation);
        return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)newFacingDirection)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(newRotationIndex));
    }

    private static int getRotatedRotation(Direction attachmentFace, int rotationIndex, Rotation rotation) {
        if (attachmentFace.m_122434_() == Direction.Axis.Y) {
            return (rotationIndex + 4 - rotation.ordinal()) % 4;
        }
        return rotationIndex;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction facingDirection = (Direction)state.m_61143_((Property)FACING);
        int rotationIndex = (Integer)state.m_61143_((Property)ROTATION);
        Direction newFacingDirection = mirror.m_54848_(facingDirection);
        int newRotationIndex = RotationFacingBlock.getMirroredRotation(facingDirection, rotationIndex, mirror);
        return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)newFacingDirection)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(newRotationIndex));
    }

    private static int getMirroredRotation(Direction attachmentFace, int rotationIndex, Mirror mirror) {
        boolean rotationIsEven;
        if (mirror == Mirror.NONE) {
            return rotationIndex;
        }
        boolean specialCase = mirror == Mirror.LEFT_RIGHT && attachmentFace.m_122434_() == Direction.Axis.Y;
        boolean bl = rotationIsEven = rotationIndex % 2 == 0;
        if (specialCase && rotationIsEven || !specialCase && !rotationIsEven) {
            return (rotationIndex + 2) % 4;
        }
        return rotationIndex;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{ROTATION});
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Direction clickFaceDirection = blockPlaceContext.m_43719_();
        Vec3 clickedPos = blockPlaceContext.m_43720_().m_82546_(blockPlaceContext.m_8083_().m_252807_());
        double xSpot = clickedPos.m_7096_();
        double ySpot = clickedPos.m_7098_();
        double zSpot = clickedPos.m_7094_();
        int rotation = clickFaceDirection.m_122434_() == Direction.Axis.Y ? (Math.abs(xSpot) > Math.abs(zSpot) ? (xSpot > 0.0 ? 1 : 3) : (zSpot > 0.0 ? 0 : 2)) : (clickFaceDirection.m_122434_() == Direction.Axis.X ? (Math.abs(ySpot) > Math.abs(zSpot) ? (ySpot > 0.0 ? 0 : 2) : (zSpot > 0.0 ? (clickFaceDirection == Direction.WEST ? 3 : 1) : (clickFaceDirection == Direction.WEST ? 1 : 3))) : (Math.abs(ySpot) > Math.abs(xSpot) ? (ySpot > 0.0 ? 0 : 2) : (xSpot > 0.0 ? (clickFaceDirection == Direction.SOUTH ? 3 : 1) : (clickFaceDirection == Direction.SOUTH ? 1 : 3))));
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)clickFaceDirection)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rotation));
    }
}

