/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.ElectricRingEntity;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EssenceBlockYellow
extends EssenceBlock {
    private static final int RINGS_TO_PASS = 100;

    public EssenceBlockYellow() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_));
    }

    @Override
    public ResourceLocation getArenaNbt() {
        return new ResourceLocation("the_bumblezone", "essence/yellow_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return 6000;
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.yellow_essence_event", BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    }

    @Override
    public ResourceLocation getEssenceItemReward() {
        return new ResourceLocation("the_bumblezone", "gameplay/rewards/yellow_arena_victory");
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void awardPlayerWinStat(ServerPlayer serverPlayer) {
        serverPlayer.m_36220_(BzStats.RADIANCE_EVENT_DEFEATED_RL.get());
    }

    @Override
    public void performUniqueArenaTick(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity) {
        if (essenceBlockEntity.getPlayerInArena().size() == 0) {
            return;
        }
        int ringsPassed = essenceBlockEntity.getExtraEventTrackingProgress();
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        int ringsActive = 0;
        for (int i = eventEntitiesInArena.size() - 1; i >= 0; --i) {
            Vex vex;
            UUID entityToCheck = eventEntitiesInArena.get(i).uuid();
            Entity entity = serverLevel.m_8791_(entityToCheck);
            if (entity == null) {
                List nearbyRings = serverLevel.m_45976_(ElectricRingEntity.class, new AABB((double)((float)blockPos.m_123341_() - (float)essenceBlockEntity.getArenaSize().m_123341_() * 0.5f), (double)((float)blockPos.m_123342_() - (float)essenceBlockEntity.getArenaSize().m_123342_() * 0.5f), (double)((float)blockPos.m_123343_() - (float)essenceBlockEntity.getArenaSize().m_123343_() * 0.5f), (double)((float)blockPos.m_123341_() + (float)essenceBlockEntity.getArenaSize().m_123341_() * 0.5f), (double)((float)blockPos.m_123342_() + (float)essenceBlockEntity.getArenaSize().m_123342_() * 0.5f), (double)((float)blockPos.m_123343_() + (float)essenceBlockEntity.getArenaSize().m_123343_() * 0.5f)));
                for (ElectricRingEntity nearbyRing : nearbyRings) {
                    if (!nearbyRing.m_20148_().equals(entityToCheck) || !nearbyRing.getEssenceController().equals(essenceBlockEntity.getUUID())) continue;
                    entity = nearbyRing;
                    break;
                }
            }
            if (entity == null) {
                eventEntitiesInArena.remove(i);
                continue;
            }
            if (entity instanceof ElectricRingEntity) {
                ElectricRingEntity electricRingEntity = (ElectricRingEntity)entity;
                electricRingEntity.setEssenceController(essenceBlockEntity.getUUID());
                electricRingEntity.setEssenceControllerBlockPos(essenceBlockEntity.m_58899_());
                electricRingEntity.setEssenceControllerDimension((ResourceKey<Level>)serverLevel.m_46472_());
                ++ringsActive;
                continue;
            }
            if (!(entity instanceof Vex) || (vex = (Vex)entity).m_5448_() == null || vex.f_19797_ % 20 != 0) continue;
            Vec3 targetDirection = vex.m_5448_().m_20182_().m_82546_(vex.m_20182_()).m_82541_();
            if (vex.m_34028_()) {
                vex.m_246865_(targetDirection.m_82490_(0.3));
            }
            if (vex.m_217043_().m_188503_(15) != 0) continue;
            vex.m_21566_().m_6849_(vex.m_20185_(), vex.m_20186_(), vex.m_20189_(), 1.0);
        }
        if (ringsPassed != 100 && ringsActive == 0) {
            EssenceBlockYellow.spawnNewRing(serverLevel, blockPos, essenceBlockEntity, ringsPassed, eventEntitiesInArena);
            if (ringsPassed >= 2) {
                EssenceBlockYellow.spawnNewEnemy(serverLevel, blockPos, essenceBlockEntity, eventEntitiesInArena);
            }
        }
        float newProgress = ringsPassed / 100;
        essenceBlockEntity.getEventBar().m_142711_(1.0f - newProgress);
        essenceBlockEntity.setExtraEventTrackingProgress(ringsPassed);
        if (ringsPassed == 100) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
        }
    }

    private static void spawnNewRing(ServerLevel serverLevel, BlockPos blockPos, EssenceBlockEntity essenceBlockEntity, int currentRingsPassed, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        BlockPos arenaSize = essenceBlockEntity.getArenaSize();
        RandomSource random = serverLevel.m_213780_();
        int x = arenaSize.m_123341_() / 2 - 5;
        int y = -(arenaSize.m_123342_() / 2) + 1;
        int z = arenaSize.m_123343_() / 2 - 5;
        if ((double)(currentRingsPassed / 100) >= 0.5) {
            float randomChosen = random.m_188501_();
            randomChosen = (double)randomChosen < 0.3 ? 0.0f : (randomChosen * 0.4f + 0.55f) * (float)(currentRingsPassed * 12 / 100);
            y = (int)Math.min((float)y + randomChosen, (float)arenaSize.m_123342_() / 2.0f - 3.0f);
        } else {
            y = (int)Math.min((float)y + random.m_188501_() * (float)(currentRingsPassed * 12 / 100), (float)arenaSize.m_123342_() / 2.0f - 3.0f);
        }
        switch (currentRingsPassed % 4) {
            case 0: {
                x = (int)((float)x * random.m_188501_() + 2.0f);
                z = (int)((float)z * random.m_188501_() + 2.0f);
                break;
            }
            case 1: {
                x = (int)((float)x * random.m_188501_() + 2.0f);
                z = (int)((float)z * random.m_188501_() + 2.0f) * -1;
                break;
            }
            case 2: {
                x = (int)((float)x * random.m_188501_() + 2.0f) * -1;
                z = (int)((float)z * random.m_188501_() + 2.0f) * -1;
                break;
            }
            case 3: {
                x = (int)((float)x * random.m_188501_() + 2.0f) * -1;
                z = (int)((float)z * random.m_188501_() + 2.0f);
            }
        }
        Vec3 centerOfRing = new Vec3((double)(blockPos.m_123341_() + x), (double)(blockPos.m_123342_() + y), (double)(blockPos.m_123343_() + z));
        Vec3 centerOfEssence = essenceBlockEntity.m_58899_().m_252807_();
        centerOfEssence = new Vec3(centerOfEssence.m_7096_(), 0.0, centerOfEssence.m_7094_());
        Vec3 vectorFromEssence = centerOfEssence.m_82546_(centerOfRing).m_82520_(0.0, centerOfRing.m_7098_(), 0.0).m_82541_();
        double angle = Mth.m_14136_((double)(-vectorFromEssence.m_7096_()), (double)vectorFromEssence.m_7094_()) + 1.5707963705062866;
        if (angle < 0.0) {
            angle += 3.1415927410125732;
        }
        angle *= 57.2957763671875;
        ElectricRingEntity ringEntity = (ElectricRingEntity)BzEntities.ELECTRIC_RING_ENTITY.get().m_20615_((Level)serverLevel);
        if (ringEntity != null) {
            ringEntity.m_20049_("the_bumblezone.yellow_essence_arena");
            ringEntity.m_146922_((float)angle);
            if (y > 0) {
                ringEntity.m_146926_(90.0f);
            } else if (y > -3) {
                ringEntity.m_146926_(45.0f);
            }
            ringEntity.m_6034_(centerOfRing.f_82479_, centerOfRing.f_82480_, centerOfRing.f_82481_);
            ringEntity.m_146867_();
            ringEntity.setEssenceController(essenceBlockEntity.getUUID());
            ringEntity.setEssenceControllerBlockPos(essenceBlockEntity.m_58899_());
            ringEntity.setEssenceControllerDimension((ResourceKey<Level>)serverLevel.m_46472_());
            eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(ringEntity.m_20148_()));
            serverLevel.m_47205_((Entity)ringEntity);
        }
    }

    private static void spawnNewEnemy(ServerLevel serverLevel, BlockPos blockPos, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        int yOffset;
        TagKey<EntityType<?>> enemyTagToUse = BzTags.ESSENCE_RADIANCE_ARENA_NORMAL_ENEMY;
        List entityTypeList = BuiltInRegistries.f_256780_.m_203431_(enemyTagToUse).map(holders -> holders.m_203614_().map(Holder::m_203334_).toList()).orElseGet(ArrayList::new);
        EntityType entityTypeToSpawn = (EntityType)entityTypeList.get(serverLevel.m_213780_().m_188503_(entityTypeList.size()));
        Entity entity = entityTypeToSpawn.m_262496_(serverLevel, blockPos.m_7918_(0, yOffset = (essenceBlockEntity.getArenaSize().m_123342_() - 2) / 2, 0), MobSpawnType.TRIGGERED);
        if (entity != null) {
            entity.m_20049_("the_bumblezone.yellow_essence_arena");
            eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(entity.m_20148_()));
            UUID playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.m_213780_().m_188503_(essenceBlockEntity.getPlayerInArena().size()));
            ServerPlayer player = serverLevel.m_7654_().m_6846_().m_11259_(playerUUID);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player;
                float maxHeart = Math.max(serverPlayer.m_21223_(), serverPlayer.m_21233_());
                float maxArmor = serverPlayer.m_21230_();
                float mobHealthBoost = maxHeart / 10.0f + maxArmor / 2.0f;
                float mobAttackBoost = Math.max(maxHeart / 40.0f + maxArmor / 3.0f - 3.5f, 0.0f);
                boolean isEssenced = EssenceOfTheBees.hasEssence(serverPlayer);
                if (!isEssenced) {
                    mobHealthBoost *= 1.5f;
                    mobAttackBoost *= 1.5f;
                }
                if (entity instanceof LivingEntity) {
                    AttributeInstance livingEntityAttributeFollowRange;
                    AttributeInstance livingEntityAttributeFlyingSpeed;
                    AttributeInstance livingEntityAttributeSpeed;
                    AttributeInstance livingEntityAttributeKnockback;
                    AttributeInstance livingEntityAttributeAttack;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    AttributeInstance livingEntityAttributeHealth = livingEntity.m_21051_(Attributes.f_22276_);
                    if (livingEntityAttributeHealth != null) {
                        livingEntityAttributeHealth.m_22125_(new AttributeModifier(UUID.fromString("03c85bd0-09eb-11ee-be56-0242ac120002"), "Essence Arena Health Boost", (double)mobHealthBoost, AttributeModifier.Operation.ADDITION));
                        livingEntity.m_5634_(mobHealthBoost);
                    }
                    if ((livingEntityAttributeAttack = livingEntity.m_21051_(Attributes.f_22281_)) != null) {
                        livingEntityAttributeAttack.m_22125_(new AttributeModifier(UUID.fromString("355141f8-09eb-11ee-be56-0242ac120002"), "Essence Arena Damage Boost", (double)mobAttackBoost, AttributeModifier.Operation.ADDITION));
                    }
                    if ((livingEntityAttributeKnockback = livingEntity.m_21051_(Attributes.f_22282_)) != null) {
                        livingEntityAttributeKnockback.m_22125_(new AttributeModifier(UUID.fromString("29143bb6-37d6-11ee-be56-0242ac120002"), "Essence Arena Knockback Boost", isEssenced ? 0.3 : 0.6, AttributeModifier.Operation.ADDITION));
                    }
                    if ((livingEntityAttributeSpeed = livingEntity.m_21051_(Attributes.f_22279_)) != null) {
                        livingEntityAttributeSpeed.m_22125_(new AttributeModifier(UUID.fromString("39ca0496-fa37-488f-8199-c4779f1afe0c"), "Essence Arena Speed Boost", isEssenced ? 0.065 : 0.085, AttributeModifier.Operation.ADDITION));
                    }
                    if ((livingEntityAttributeFlyingSpeed = livingEntity.m_21051_(Attributes.f_22280_)) != null) {
                        livingEntityAttributeFlyingSpeed.m_22125_(new AttributeModifier(UUID.fromString("c762c216-0a3a-11ee-be56-0242ac120002"), "Essence Arena Flying Speed Boost", isEssenced ? 0.065 : 0.085, AttributeModifier.Operation.ADDITION));
                    }
                    if ((livingEntityAttributeFollowRange = livingEntity.m_21051_(Attributes.f_22277_)) != null) {
                        livingEntityAttributeFollowRange.m_22125_(new AttributeModifier(UUID.fromString("23a7a8a9-85bc-4dc3-9417-a4bd4b1b95a2"), "Essence Arena Sight Boost", 32.0, AttributeModifier.Operation.ADDITION));
                    }
                }
                if (entity instanceof NeutralMob) {
                    NeutralMob neutralMob = (NeutralMob)entity;
                    neutralMob.m_7870_(Integer.MAX_VALUE);
                    neutralMob.m_6925_(playerUUID);
                    neutralMob.m_6710_((LivingEntity)serverPlayer);
                } else if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_6710_((LivingEntity)serverPlayer);
                    if (entity instanceof Rabbit) {
                        Rabbit rabbit = (Rabbit)entity;
                        rabbit.m_28464_(Rabbit.Variant.EVIL);
                    }
                }
                if (entity instanceof Vex) {
                    Vex vex = (Vex)entity;
                    if (eventEntitiesInArena.size() > 25) {
                        vex.m_20225_(true);
                    }
                }
            }
        }
    }

    @Override
    public void onPlayerEnter(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, BzSounds.RADIANCE_EVENT.get().m_11660_(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, BzSounds.RADIANCE_EVENT.get().m_11660_(), false);
        EssenceBlockYellow.removeBonusEffectsFromPlayer(serverPlayer);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }

    public void ringActivated(ElectricRingEntity electricRingEntity, EssenceBlockEntity essenceBlockEntity, ServerPlayer serverPlayer) {
        int ringsPassed = essenceBlockEntity.getExtraEventTrackingProgress();
        essenceBlockEntity.getEventEntitiesInArena().removeIf(e -> e.uuid().equals(electricRingEntity.m_20148_()));
        if (ringsPassed + 1 >= 100) {
            EssenceBlockYellow.removeBonusEffectsFromPlayer(serverPlayer);
        } else if (EssenceOfTheBees.hasEssence(serverPlayer)) {
            serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19596_, essenceBlockEntity.getEventTimer(), ringsPassed / 7, false, false));
            serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19603_, essenceBlockEntity.getEventTimer(), Math.min(ringsPassed / 7, 8), false, false));
        }
        float newProgress = ++ringsPassed / 100;
        essenceBlockEntity.getEventBar().m_142711_(1.0f - newProgress);
        essenceBlockEntity.setExtraEventTrackingProgress(ringsPassed);
    }

    private static void removeBonusEffectsFromPlayer(ServerPlayer serverPlayer) {
        if (serverPlayer.m_21023_(MobEffects.f_19603_)) {
            serverPlayer.m_21195_(MobEffects.f_19603_);
        }
        if (serverPlayer.m_21023_(MobEffects.f_19596_)) {
            serverPlayer.m_21195_(MobEffects.f_19596_);
        }
    }
}

