#version 150

uniform sampler2D DiffuseSampler;
uniform sampler2D BlurSampler;
uniform sampler2D DiffuseDepthSampler;

uniform mat4 ProjMat;
uniform vec2 OutSize;
uniform vec2 ScreenSize;
uniform float _FOV;

in vec2 texCoord;
in vec2 scaledCoord;

uniform vec2 InSize;
uniform vec4 Scissor;
uniform vec4 Vignette;

out vec4 fragColor;

float near = 0.1;
float far = 1000.0;
float exposure = 0.01;
float AOE = 0.;

float LinearizeDepth(float depth) 
{
    float z = depth * 2.0f - 1.0f;
    return (near * far) / (far + near - z * (far - near));    
}

void main() {
    vec4 ScaledTexel = texture(DiffuseSampler, texCoord);
    vec4 BlurTexel = texture(BlurSampler, texCoord);
	float depth = LinearizeDepth(texture(DiffuseDepthSampler, texCoord).r);
    float distance = length(vec3(-2.375, (2.*texCoord - 1.) * vec2(ScreenSize.x/ScreenSize.y, 2.) * tan(radians(_FOV / 10.))));
    float circleDistance = (distance * distance);
	vec2 uv = texCoord;
    float d = sqrt(pow((uv.x - 0.5),2.0) + pow((uv.y - 0.5),2.0));
	d = exp(-(d * AOE)) * exposure / (distance*0.01);
    vec4 OutTexel = ScaledTexel - BlurTexel + BlurTexel / circleDistance;
    fragColor = vec4(OutTexel.rgb*clamp(1.0 + d, 0.0, 10.0),1.0);
}
