/*
 * Decompiled with CFR 0.152.
 */
package net.bryszirake.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.bryszirake.BryszirakeMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BryszirakeModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        BryszirakeMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        BryszirakeMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BryszirakeMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.PlayerRakeMusic = message.data.PlayerRakeMusic;
                    variables.PlayerBloodhourFog = message.data.PlayerBloodhourFog;
                    variables.PlayerBloodHourFogSlowFade = message.data.PlayerBloodHourFogSlowFade;
                    variables.JumpscareTimer = message.data.JumpscareTimer;
                    variables.JumpscareActive = message.data.JumpscareActive;
                    variables.ShaderOnPlayerHit = message.data.ShaderOnPlayerHit;
                    variables.PlaySpottedSoundAndEffects = message.data.PlaySpottedSoundAndEffects;
                    variables.FogOverlayNumber = message.data.FogOverlayNumber;
                    variables.OverlaySlowdown = message.data.OverlaySlowdown;
                    variables.IsBloodHour = message.data.IsBloodHour;
                    variables.PlayerSleepScreen = message.data.PlayerSleepScreen;
                    variables.JumpscareType = message.data.JumpscareType;
                    variables.tracker_number = message.data.tracker_number;
                    variables.VisionHourFogOverlay = message.data.VisionHourFogOverlay;
                    variables.VisionHourOverlaySlowdown = message.data.VisionHourOverlaySlowdown;
                    variables.FogDensity = message.data.FogDensity;
                    variables.FogStartingDensity = message.data.FogStartingDensity;
                    variables.FogDensityNumberLock = message.data.FogDensityNumberLock;
                    variables.FogDensitySlowdown = message.data.FogDensitySlowdown;
                    variables.FogStartingDensitySlowdown = message.data.FogStartingDensitySlowdown;
                    variables.ShopkeeperTradeButtonNumber = message.data.ShopkeeperTradeButtonNumber;
                    variables.DiscCycleTime = message.data.DiscCycleTime;
                    variables.GiveSilverCoin = message.data.GiveSilverCoin;
                    variables.ChallengeCompletedOverlayNumber = message.data.ChallengeCompletedOverlayNumber;
                    variables.BlackoutFogOverlay = message.data.BlackoutFogOverlay;
                    variables.BlackoutOverlaySlowdown = message.data.BlackoutOverlaySlowdown;
                    variables.InCombatwRake = message.data.InCombatwRake;
                    variables.NearestRakeHealth = message.data.NearestRakeHealth;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean PlayerRakeMusic = false;
        public double PlayerBloodhourFog = 0.0;
        public double PlayerBloodHourFogSlowFade = 0.0;
        public double JumpscareTimer = 0.0;
        public boolean JumpscareActive = false;
        public double ShaderOnPlayerHit = 0.0;
        public boolean PlaySpottedSoundAndEffects = false;
        public double FogOverlayNumber = 0.0;
        public double OverlaySlowdown = 0.0;
        public double IsBloodHour = 0.0;
        public boolean PlayerSleepScreen = false;
        public double JumpscareType = 0.0;
        public double tracker_number = 0.0;
        public double VisionHourFogOverlay = 0.0;
        public double VisionHourOverlaySlowdown = 0.0;
        public double FogDensity = 0.0;
        public double FogStartingDensity = 0.0;
        public double FogDensityNumberLock = 0.0;
        public double FogDensitySlowdown = 0.0;
        public double FogStartingDensitySlowdown = 0.0;
        public double ShopkeeperTradeButtonNumber = 0.0;
        public double DiscCycleTime = 0.0;
        public double GiveSilverCoin = 0.0;
        public double ChallengeCompletedOverlayNumber = 0.0;
        public double BlackoutFogOverlay = 0.0;
        public double BlackoutOverlaySlowdown = 0.0;
        public double InCombatwRake = 0.0;
        public double NearestRakeHealth = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                BryszirakeMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("PlayerRakeMusic", this.PlayerRakeMusic);
            nbt.m_128347_("PlayerBloodhourFog", this.PlayerBloodhourFog);
            nbt.m_128347_("PlayerBloodHourFogSlowFade", this.PlayerBloodHourFogSlowFade);
            nbt.m_128347_("JumpscareTimer", this.JumpscareTimer);
            nbt.m_128379_("JumpscareActive", this.JumpscareActive);
            nbt.m_128347_("ShaderOnPlayerHit", this.ShaderOnPlayerHit);
            nbt.m_128379_("PlaySpottedSoundAndEffects", this.PlaySpottedSoundAndEffects);
            nbt.m_128347_("FogOverlayNumber", this.FogOverlayNumber);
            nbt.m_128347_("OverlaySlowdown", this.OverlaySlowdown);
            nbt.m_128347_("IsBloodHour", this.IsBloodHour);
            nbt.m_128379_("PlayerSleepScreen", this.PlayerSleepScreen);
            nbt.m_128347_("JumpscareType", this.JumpscareType);
            nbt.m_128347_("tracker_number", this.tracker_number);
            nbt.m_128347_("VisionHourFogOverlay", this.VisionHourFogOverlay);
            nbt.m_128347_("VisionHourOverlaySlowdown", this.VisionHourOverlaySlowdown);
            nbt.m_128347_("FogDensity", this.FogDensity);
            nbt.m_128347_("FogStartingDensity", this.FogStartingDensity);
            nbt.m_128347_("FogDensityNumberLock", this.FogDensityNumberLock);
            nbt.m_128347_("FogDensitySlowdown", this.FogDensitySlowdown);
            nbt.m_128347_("FogStartingDensitySlowdown", this.FogStartingDensitySlowdown);
            nbt.m_128347_("ShopkeeperTradeButtonNumber", this.ShopkeeperTradeButtonNumber);
            nbt.m_128347_("DiscCycleTime", this.DiscCycleTime);
            nbt.m_128347_("GiveSilverCoin", this.GiveSilverCoin);
            nbt.m_128347_("ChallengeCompletedOverlayNumber", this.ChallengeCompletedOverlayNumber);
            nbt.m_128347_("BlackoutFogOverlay", this.BlackoutFogOverlay);
            nbt.m_128347_("BlackoutOverlaySlowdown", this.BlackoutOverlaySlowdown);
            nbt.m_128347_("InCombatwRake", this.InCombatwRake);
            nbt.m_128347_("NearestRakeHealth", this.NearestRakeHealth);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt;
            if (tag == null) {
                tag = this.writeNBT();
            }
            if ((nbt = (CompoundTag)tag) == null) {
                nbt = (CompoundTag)this.writeNBT();
            }
            this.PlayerRakeMusic = nbt.m_128471_("PlayerRakeMusic");
            this.PlayerBloodhourFog = nbt.m_128459_("PlayerBloodhourFog");
            this.PlayerBloodHourFogSlowFade = nbt.m_128459_("PlayerBloodHourFogSlowFade");
            this.JumpscareTimer = nbt.m_128459_("JumpscareTimer");
            this.JumpscareActive = nbt.m_128471_("JumpscareActive");
            this.ShaderOnPlayerHit = nbt.m_128459_("ShaderOnPlayerHit");
            this.PlaySpottedSoundAndEffects = nbt.m_128471_("PlaySpottedSoundAndEffects");
            this.FogOverlayNumber = nbt.m_128459_("FogOverlayNumber");
            this.OverlaySlowdown = nbt.m_128459_("OverlaySlowdown");
            this.IsBloodHour = nbt.m_128459_("IsBloodHour");
            this.PlayerSleepScreen = nbt.m_128471_("PlayerSleepScreen");
            this.JumpscareType = nbt.m_128459_("JumpscareType");
            this.tracker_number = nbt.m_128459_("tracker_number");
            this.VisionHourFogOverlay = nbt.m_128459_("VisionHourFogOverlay");
            this.VisionHourOverlaySlowdown = nbt.m_128459_("VisionHourOverlaySlowdown");
            this.FogDensity = nbt.m_128459_("FogDensity");
            this.FogStartingDensity = nbt.m_128459_("FogStartingDensity");
            this.FogDensityNumberLock = nbt.m_128459_("FogDensityNumberLock");
            this.FogDensitySlowdown = nbt.m_128459_("FogDensitySlowdown");
            this.FogStartingDensitySlowdown = nbt.m_128459_("FogStartingDensitySlowdown");
            this.ShopkeeperTradeButtonNumber = nbt.m_128459_("ShopkeeperTradeButtonNumber");
            this.DiscCycleTime = nbt.m_128459_("DiscCycleTime");
            this.GiveSilverCoin = nbt.m_128459_("GiveSilverCoin");
            this.ChallengeCompletedOverlayNumber = nbt.m_128459_("ChallengeCompletedOverlayNumber");
            this.BlackoutFogOverlay = nbt.m_128459_("BlackoutFogOverlay");
            this.BlackoutOverlaySlowdown = nbt.m_128459_("BlackoutOverlaySlowdown");
            this.InCombatwRake = nbt.m_128459_("InCombatwRake");
            this.NearestRakeHealth = nbt.m_128459_("NearestRakeHealth");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("bryszirake", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "bryszirake_mapvars";
        public boolean BloodHourTextTrue = false;
        public double BloodHourTextNumber = 0.0;
        public double PlayerSleepScreenNumber = 0.0;
        public boolean SkipToDay = false;
        public boolean BloodHour = false;
        public boolean RakeHasSpawned = false;
        public double FogDistance = 0.0;
        public double VisionHourTriggerCooldown = 24000.0;
        public double ItsVisionEvolvesNumber = 0.0;
        public boolean ItsVisionEvolvesTextTrigger = false;
        public double StaticNumber = 0.0;
        public double BlackoutTextNumber = 0.0;
        public double BlackoutTextTimer = 0.0;
        public double forceload_lim_1_x = 0.0;
        public double forceload_lim_1_y = 0.0;
        public double forceload_lim_1_z = 0.0;
        public double forceload_lim_2_x = 0.0;
        public double forceload_lim_2_y = 0.0;
        public double forceload_lim_2_z = 0.0;
        public double forceload_lim_3_x = 0.0;
        public double forceload_lim_3_y = 0.0;
        public double forceload_lim_3_z = 0.0;
        public double forceload_lim_4_x = 0.0;
        public double forceload_lim_4_y = 0.0;
        public double forceload_lim_4_z = 0.0;
        public double forceload_lim_5_x = 0.0;
        public double forceload_lim_5_y = 0.0;
        public double forceload_lim_5_z = 0.0;
        public boolean world_tick_player_sync = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            if (nbt == null) {
                nbt = this.m_7176_(new CompoundTag());
            }
            this.BloodHourTextTrue = nbt.m_128471_("BloodHourTextTrue");
            this.BloodHourTextNumber = nbt.m_128459_("BloodHourTextNumber");
            this.PlayerSleepScreenNumber = nbt.m_128459_("PlayerSleepScreenNumber");
            this.SkipToDay = nbt.m_128471_("SkipToDay");
            this.BloodHour = nbt.m_128471_("BloodHour");
            this.RakeHasSpawned = nbt.m_128471_("RakeHasSpawned");
            this.FogDistance = nbt.m_128459_("FogDistance");
            this.VisionHourTriggerCooldown = nbt.m_128459_("VisionHourTriggerCooldown");
            this.ItsVisionEvolvesNumber = nbt.m_128459_("ItsVisionEvolvesNumber");
            this.ItsVisionEvolvesTextTrigger = nbt.m_128471_("ItsVisionEvolvesTextTrigger");
            this.StaticNumber = nbt.m_128459_("StaticNumber");
            this.BlackoutTextNumber = nbt.m_128459_("BlackoutTextNumber");
            this.BlackoutTextTimer = nbt.m_128459_("BlackoutTextTimer");
            this.forceload_lim_1_x = nbt.m_128459_("forceload_lim_1_x");
            this.forceload_lim_1_y = nbt.m_128459_("forceload_lim_1_y");
            this.forceload_lim_1_z = nbt.m_128459_("forceload_lim_1_z");
            this.forceload_lim_2_x = nbt.m_128459_("forceload_lim_2_x");
            this.forceload_lim_2_y = nbt.m_128459_("forceload_lim_2_y");
            this.forceload_lim_2_z = nbt.m_128459_("forceload_lim_2_z");
            this.forceload_lim_3_x = nbt.m_128459_("forceload_lim_3_x");
            this.forceload_lim_3_y = nbt.m_128459_("forceload_lim_3_y");
            this.forceload_lim_3_z = nbt.m_128459_("forceload_lim_3_z");
            this.forceload_lim_4_x = nbt.m_128459_("forceload_lim_4_x");
            this.forceload_lim_4_y = nbt.m_128459_("forceload_lim_4_y");
            this.forceload_lim_4_z = nbt.m_128459_("forceload_lim_4_z");
            this.forceload_lim_5_x = nbt.m_128459_("forceload_lim_5_x");
            this.forceload_lim_5_y = nbt.m_128459_("forceload_lim_5_y");
            this.forceload_lim_5_z = nbt.m_128459_("forceload_lim_5_z");
            this.world_tick_player_sync = nbt.m_128471_("world_tick_player_sync");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("BloodHourTextTrue", this.BloodHourTextTrue);
            nbt.m_128347_("BloodHourTextNumber", this.BloodHourTextNumber);
            nbt.m_128347_("PlayerSleepScreenNumber", this.PlayerSleepScreenNumber);
            nbt.m_128379_("SkipToDay", this.SkipToDay);
            nbt.m_128379_("BloodHour", this.BloodHour);
            nbt.m_128379_("RakeHasSpawned", this.RakeHasSpawned);
            nbt.m_128347_("FogDistance", this.FogDistance);
            nbt.m_128347_("VisionHourTriggerCooldown", this.VisionHourTriggerCooldown);
            nbt.m_128347_("ItsVisionEvolvesNumber", this.ItsVisionEvolvesNumber);
            nbt.m_128379_("ItsVisionEvolvesTextTrigger", this.ItsVisionEvolvesTextTrigger);
            nbt.m_128347_("StaticNumber", this.StaticNumber);
            nbt.m_128347_("BlackoutTextNumber", this.BlackoutTextNumber);
            nbt.m_128347_("BlackoutTextTimer", this.BlackoutTextTimer);
            nbt.m_128347_("forceload_lim_1_x", this.forceload_lim_1_x);
            nbt.m_128347_("forceload_lim_1_y", this.forceload_lim_1_y);
            nbt.m_128347_("forceload_lim_1_z", this.forceload_lim_1_z);
            nbt.m_128347_("forceload_lim_2_x", this.forceload_lim_2_x);
            nbt.m_128347_("forceload_lim_2_y", this.forceload_lim_2_y);
            nbt.m_128347_("forceload_lim_2_z", this.forceload_lim_2_z);
            nbt.m_128347_("forceload_lim_3_x", this.forceload_lim_3_x);
            nbt.m_128347_("forceload_lim_3_y", this.forceload_lim_3_y);
            nbt.m_128347_("forceload_lim_3_z", this.forceload_lim_3_z);
            nbt.m_128347_("forceload_lim_4_x", this.forceload_lim_4_x);
            nbt.m_128347_("forceload_lim_4_y", this.forceload_lim_4_y);
            nbt.m_128347_("forceload_lim_4_z", this.forceload_lim_4_z);
            nbt.m_128347_("forceload_lim_5_x", this.forceload_lim_5_x);
            nbt.m_128347_("forceload_lim_5_y", this.forceload_lim_5_y);
            nbt.m_128347_("forceload_lim_5_z", this.forceload_lim_5_z);
            nbt.m_128379_("world_tick_player_sync", this.world_tick_player_sync);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                BryszirakeMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "bryszirake_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                BryszirakeMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.JumpscareTimer = original.JumpscareTimer;
            clone.JumpscareActive = original.JumpscareActive;
            clone.IsBloodHour = original.IsBloodHour;
            clone.JumpscareType = original.JumpscareType;
            clone.FogDensity = original.FogDensity;
            clone.FogStartingDensity = original.FogStartingDensity;
            clone.FogDensityNumberLock = original.FogDensityNumberLock;
            clone.FogDensitySlowdown = original.FogDensitySlowdown;
            clone.FogStartingDensitySlowdown = original.FogStartingDensitySlowdown;
            clone.DiscCycleTime = original.DiscCycleTime;
            if (!event.isWasDeath()) {
                clone.PlayerRakeMusic = original.PlayerRakeMusic;
                clone.PlayerBloodhourFog = original.PlayerBloodhourFog;
                clone.PlayerBloodHourFogSlowFade = original.PlayerBloodHourFogSlowFade;
                clone.ShaderOnPlayerHit = original.ShaderOnPlayerHit;
                clone.PlaySpottedSoundAndEffects = original.PlaySpottedSoundAndEffects;
                clone.FogOverlayNumber = original.FogOverlayNumber;
                clone.OverlaySlowdown = original.OverlaySlowdown;
                clone.PlayerSleepScreen = original.PlayerSleepScreen;
                clone.tracker_number = original.tracker_number;
                clone.VisionHourFogOverlay = original.VisionHourFogOverlay;
                clone.VisionHourOverlaySlowdown = original.VisionHourOverlaySlowdown;
                clone.ShopkeeperTradeButtonNumber = original.ShopkeeperTradeButtonNumber;
                clone.GiveSilverCoin = original.GiveSilverCoin;
                clone.ChallengeCompletedOverlayNumber = original.ChallengeCompletedOverlayNumber;
                clone.BlackoutFogOverlay = original.BlackoutFogOverlay;
                clone.BlackoutOverlaySlowdown = original.BlackoutOverlaySlowdown;
                clone.InCombatwRake = original.InCombatwRake;
                clone.NearestRakeHealth = original.NearestRakeHealth;
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    BryszirakeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    BryszirakeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                BryszirakeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

