/*
 * Decompiled with CFR 0.152.
 */
package net.bryszirake.configuration;

import net.minecraftforge.common.ForgeConfigSpec;

public class RakeConfigConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CANRAKEBREAKBLOCKS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CANRAKECLIMB;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SKIPTODAY;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CANRAKETELEPORT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CANCAVESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> CAVEUPDATECHECK;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CANBLOODHOURHAPPEN;
    public static final ForgeConfigSpec.ConfigValue<Double> BLOODHOURCHANCE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CANBLOODHOURBREAKBLOCKS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DISABLEDISABLESLEEPING;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DAYMUSIC;
    public static final ForgeConfigSpec.ConfigValue<Double> SCRAPLIMIT;
    public static final ForgeConfigSpec.ConfigValue<Double> RAKEHEALTHBAR;
    public static final ForgeConfigSpec.ConfigValue<Double> VISIONHOURCHANCE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CANVISIONHOURBREAKBLOCKS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CANVISIONHOURHAPPEN;
    public static final ForgeConfigSpec.ConfigValue<Double> BLACKOUTCHANCE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CANBLACKOUTBREAKBLOCKS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CANBLACKOUTHAPPEN;

    static {
        BUILDER.push("DefaultRake");
        CANRAKEBREAKBLOCKS = BUILDER.define("Can rake break blocks?", true);
        CANRAKECLIMB = BUILDER.define("Can rake climb?", true);
        SKIPTODAY = BUILDER.comment("does it skip to day if you defeat the rake").define("Skip to day", true);
        CANRAKETELEPORT = BUILDER.define("can rake teleport", true);
        BUILDER.pop();
        BUILDER.push("Cave");
        CANCAVESPAWN = BUILDER.define("Can cave spawn", true);
        CAVEUPDATECHECK = BUILDER.comment("how often the cave checks for spawning condition for the rake").define("Cave update check", (Object)1200.0);
        BUILDER.pop();
        BUILDER.push("BloodHourRake");
        CANBLOODHOURHAPPEN = BUILDER.define("can bloodhour happen?", true);
        BLOODHOURCHANCE = BUILDER.comment("the higher the number the lower the chance (cant be 1)").define("bloodhour chance", (Object)5.0);
        CANBLOODHOURBREAKBLOCKS = BUILDER.define("can bloodhour break blocks?", true);
        BUILDER.pop();
        BUILDER.push("Other Stuff");
        DISABLEDISABLESLEEPING = BUILDER.comment("enables sleeping (disables rake rewards)").define("disable disable sleeping", false);
        DAYMUSIC = BUILDER.comment("turning this on will play ambient music during the day").define("ambient day music", false);
        SCRAPLIMIT = BUILDER.comment("the limit of how much scrap can spawn in a 512 block radius").define("scrap limit", (Object)10.0);
        RAKEHEALTHBAR = BUILDER.comment("0 = no rake heathbar, 1 = rake health bar when in combat, 2 = rake health bar always").define("rake health bar", (Object)1.0);
        BUILDER.pop();
        BUILDER.push("VisionHour Rake");
        VISIONHOURCHANCE = BUILDER.define("visionhour chance", (Object)15.0);
        CANVISIONHOURBREAKBLOCKS = BUILDER.define("can vision hour break blocks", true);
        CANVISIONHOURHAPPEN = BUILDER.define("can visionhour happen", true);
        BUILDER.pop();
        BUILDER.push("BlackoutRake");
        BLACKOUTCHANCE = BUILDER.define("blackout chance", (Object)15.0);
        CANBLACKOUTBREAKBLOCKS = BUILDER.define("can blackout break blocks", true);
        CANBLACKOUTHAPPEN = BUILDER.define("can blackout happen", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

