/*
 * Decompiled with CFR 0.152.
 */
package com.unixkitty.timecontrol;

import com.unixkitty.timecontrol.Config;
import it.unimi.dsi.fastutil.doubles.DoubleImmutableList;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.PrimaryLevelData;

public class Numbers {
    public static final long DAY_TICKS = 24000L;
    public static final long HALF_DAY_TICKS = 12000L;
    public static final double MAX_TIME_SHIFT = 23.0;
    public static final List<Double> TIME_SHIFT_LIST;
    private static final int real_life_hour_offset = 6;
    private static final int hours_per_day = 24;
    private static final int ticks_per_hour = 1000;
    private static final int real_life_second_is_ticks = 20;
    private static final int real_life_minute_is_ticks = 1200;
    private static final double vanilla_multiplier = 600.0;
    private static final double real_life_minute_multiplier = 16.666666666666668;

    public static double getMultiplier(long worldtime) {
        return Numbers.getMultiplier(Numbers.isDaytime(worldtime));
    }

    public static long getCustomTime(long worldtime) {
        return (long)((double)worldtime * Numbers.getMultiplier(worldtime));
    }

    public static void setWorldtime(Level level, long customtime, double multiplier) {
        Numbers.setLevelDataWorldtime(level, Numbers.getWorldtime(customtime, multiplier));
    }

    public static void setLevelDataWorldtime(Level level, long worldtime) {
        LevelData worldInfo = level.m_6106_();
        if (level.f_46443_ && worldInfo instanceof ClientLevel.ClientLevelData) {
            ((ClientLevel.ClientLevelData)worldInfo).m_104863_(worldtime);
        } else if (worldInfo instanceof PrimaryLevelData) {
            ((PrimaryLevelData)worldInfo).m_6247_(worldtime);
        }
    }

    public static String getProgressString(long item) {
        int stringLength = 50;
        int percent = (int)((item %= 12000L) * 100L / 12000L);
        int division = 2;
        return String.join((CharSequence)"", Collections.nCopies(percent == 0 ? 2 : 2 - (int)Math.log10(percent), " ")) + String.format(" %d%% [", percent) + String.join((CharSequence)"", Collections.nCopies(percent / division, "=")) + ">" + String.join((CharSequence)"", Collections.nCopies(50 - percent / division, " ")) + "]" + String.join((CharSequence)"", Collections.nCopies(item == 0L ? (int)Math.log10(12000.0) : (int)Math.log10(12000.0) - (int)Math.log10(item), " ")) + String.format(" %d/%d", item, 12000L);
    }

    private static long getWorldtime(long customtime, double multiplier) {
        return (long)((double)customtime / multiplier % 2.147483647E9);
    }

    private static double getMultiplier(boolean day) {
        return BigDecimal.valueOf((double)(day ? (Integer)Config.day_length_seconds.get() : (Integer)Config.night_length_seconds.get()).intValue() / 600.0).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
    }

    public static boolean isDaytime(long worldtime) {
        long l = worldtime % 24000L;
        return l >= 0L && l < 12000L;
    }

    public static long getSystemtimeTicks(int hour, int minute, int day) {
        hour = (hour - 6 + 24) % 24 * 1000;
        minute = (int)Math.round((double)minute * 16.666666666666668 % 1000.0);
        return (long)(hour + minute) + (long)day * 24000L;
    }

    static {
        ArrayList<Double> tempList = new ArrayList<Double>();
        for (double i = -23.0; i <= 23.0; i += 0.5) {
            tempList.add(i);
        }
        TIME_SHIFT_LIST = new DoubleImmutableList(tempList);
    }
}

