/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.abridged.worldgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.placementcondition.PlacementCondition;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;

public record BridgeConfig(PlacementCondition condition, InclusiveRange<Integer> height, InclusiveRange<Integer> segments, Integer maxHeightDifference, List<ResourceLocation> base, List<ResourceLocation> edge, Holder<StructureProcessorList> processors, List<Extension> extensions) {
    public static final Codec<List<ResourceLocation>> COMPACT_ID_LIST_CODEC = BridgeConfig.compactList(ResourceLocation.f_135803_);
    public static final Codec<BridgeConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PlacementCondition.CODEC.fieldOf("condition").forGetter(BridgeConfig::condition), (App)InclusiveRange.m_184572_((Codec)Codec.INT).fieldOf("height").forGetter(BridgeConfig::height), (App)InclusiveRange.m_184572_((Codec)Codec.intRange((int)2, (int)12)).fieldOf("segments").forGetter(BridgeConfig::segments), (App)Codec.INT.fieldOf("max_height_difference").forGetter(BridgeConfig::maxHeightDifference), (App)COMPACT_ID_LIST_CODEC.fieldOf("base_template").forGetter(BridgeConfig::base), (App)COMPACT_ID_LIST_CODEC.fieldOf("edge_template").forGetter(BridgeConfig::edge), (App)StructureProcessorType.f_74468_.fieldOf("processors").forGetter(BridgeConfig::processors), (App)Extension.CODEC.listOf().fieldOf("extensions").forGetter(BridgeConfig::extensions)).apply((Applicative)instance, BridgeConfig::new));

    public ResourceLocation getProcessorId() {
        Optional key = this.processors.m_203543_();
        return key.map(ResourceKey::m_135782_).orElseGet(() -> ResourceLocation.m_135820_((String)"minecraft:empty"));
    }

    private static <T> Codec<List<T>> compactList(Codec<T> codec) {
        return Codec.either((Codec)codec.listOf(), codec).xmap(either -> (List)either.map(id -> id, List::of), Either::left);
    }

    public record Extension(HolderSet<Block> blocks, BlockStateProvider extendedState) {
        public static final Codec<Extension> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).fieldOf("blocks").forGetter(Extension::blocks), (App)BlockStateProvider.f_68747_.fieldOf("extended_state").forGetter(Extension::extendedState)).apply((Applicative)instance, Extension::new));
    }
}

