/*
 * Decompiled with CFR 0.152.
 */
package com.mc_goodch.ancient_manuscripts.utilities;

import com.mc_goodch.ancient_manuscripts.AncientManuscripts;
import com.mc_goodch.ancient_manuscripts.config.AMConfig;
import com.mc_goodch.ancient_manuscripts.config.Blacklist;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentUtilities {
    @Nullable
    public static Enchantment randomEnchantmentForRarity(Enchantment.Rarity rarity, @Nullable Map<Enchantment, Integer> existingEnchantments) {
        Random rand = new Random();
        ArrayList<Enchantment> enchantmentList = new ArrayList<Enchantment>();
        boolean vanillaOnlyEnabled = (Boolean)AMConfig.AM_VANILLA_ENCHANTMENTS_ONLY_ENABLED.get();
        boolean includeCurses = (Boolean)AMConfig.AM_INCLUDE_CURSE_ENCHANTMENTS_ENABLED.get();
        boolean includeTreasure = (Boolean)AMConfig.AM_ALLOW_TREASURE_ENCHANTMENTS_ENABLED.get();
        for (ResourceLocation resource : ForgeRegistries.ENCHANTMENTS.getKeys()) {
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(resource);
            if (existingEnchantments != null && existingEnchantments.containsKey(enchantment)) continue;
            String namespace = resource.m_135827_();
            if (vanillaOnlyEnabled && !namespace.equals("minecraft") || EnchantmentUtilities.isBlacklisted(namespace, resource.m_135815_()) || enchantment.m_6589_() && !includeCurses || enchantment.m_6591_() && !includeTreasure || enchantment.m_44699_() != rarity) continue;
            enchantmentList.add(enchantment);
        }
        if (enchantmentList.isEmpty()) {
            return null;
        }
        Enchantment enchantment = (Enchantment)enchantmentList.get(rand.nextInt(enchantmentList.size()));
        return enchantment;
    }

    public static int getRandomLevel(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    public static boolean isBlacklisted(String namespace, String path) {
        if (AncientManuscripts.blacklist == null) {
            return false;
        }
        for (Blacklist item : AncientManuscripts.blacklist) {
            String modId = item.getModId();
            if (!modId.equals(namespace) || modId.equals("example_mod_id")) continue;
            for (String enchantment : item.getEnchantments()) {
                if (!enchantment.equals("*") && !enchantment.equals(path)) continue;
                return true;
            }
        }
        return false;
    }
}

