/*
 * Decompiled with CFR 0.152.
 */
package com.mc_goodch.ancient_manuscripts.recipes;

import com.mc_goodch.ancient_manuscripts.config.AMConfig;
import com.mc_goodch.ancient_manuscripts.init.ItemInit;
import com.mc_goodch.ancient_manuscripts.init.RecipeInit;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;

public class BookGlueAltRecipe
extends CustomRecipe {
    private final int maxGlueDurability = (Integer)AMConfig.AM_MAGIC_BOOK_GLUE_DURABILITY.get();

    public BookGlueAltRecipe(ResourceLocation location, CraftingBookCategory category) {
        super(location, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack glueStack = null;
        int bucketCount = 0;
        int honeycombCount = 0;
        int slimeBallCount = 0;
        int glowstoneCount = 0;
        int boneMealCount = 0;
        int glueCount = 0;
        int itemCount = container.m_6643_();
        for (int x = 0; x < itemCount; ++x) {
            ItemStack stack = container.m_8020_(x);
            if (stack.m_41619_()) continue;
            Item stackItem = stack.m_41720_();
            if (stackItem == Items.f_42447_) {
                ++bucketCount;
                continue;
            }
            if (stackItem == Items.f_42784_) {
                ++honeycombCount;
                continue;
            }
            if (stack.m_204117_(Tags.Items.SLIMEBALLS)) {
                ++slimeBallCount;
                continue;
            }
            if (stack.m_204117_(Tags.Items.DUSTS_GLOWSTONE)) {
                ++glowstoneCount;
                continue;
            }
            if (stackItem == Items.f_42499_) {
                ++boneMealCount;
                continue;
            }
            if (stackItem == ItemInit.ENCHANTED_BOOK_GLUE.get()) {
                int glueDamage;
                int glueDurability = stack.m_41776_();
                if (glueDurability - (glueDamage = stack.m_41773_()) <= this.maxGlueDurability / 2) {
                    glueStack = stack;
                }
                ++glueCount;
                continue;
            }
            return false;
        }
        return bucketCount == 1 && honeycombCount == 1 && slimeBallCount == 1 && glowstoneCount == 1 && boneMealCount == 1 && glueCount == 1 && glueStack != null;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess access) {
        ItemStack glueStack = new ItemStack((ItemLike)ItemInit.ENCHANTED_BOOK_GLUE.get());
        return glueStack;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeInit.BOOK_GLUE_ALT.get();
    }
}

