/*
 * Decompiled with CFR 0.152.
 */
package com.mc_goodch.ancient_manuscripts.gui;

import com.mc_goodch.ancient_manuscripts.blocks.entity.custom.AbstractBindingTableBlockEntity;
import com.mc_goodch.ancient_manuscripts.config.AMConfig;
import com.mc_goodch.ancient_manuscripts.gui.slot.BookBindingBookSlot;
import com.mc_goodch.ancient_manuscripts.gui.slot.BookBindingDiamondSlot;
import com.mc_goodch.ancient_manuscripts.gui.slot.BookBindingGlueSlot;
import com.mc_goodch.ancient_manuscripts.gui.slot.BookBindingManuscriptSlot;
import com.mc_goodch.ancient_manuscripts.gui.slot.BookBindingResultSlot;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class AbstractBindingTableMenu
extends AbstractContainerMenu {
    private static boolean allowDiamondUpgrades = (Boolean)AMConfig.AM_ALLOW_DIAMOND_UPGRADES_ENABLED.get();
    protected final AbstractBindingTableBlockEntity blockEntity;
    protected final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = allowDiamondUpgrades ? 8 : 7;

    public AbstractBindingTableMenu(MenuType<?> type, int containerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super(type, containerId);
        AbstractBindingTableMenu.m_38869_((Container)inv, (int)8);
        this.blockEntity = (AbstractBindingTableBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new BookBindingGlueSlot((IItemHandler)handler, 0, 26, allowDiamondUpgrades ? 16 : 26));
            this.m_38897_((Slot)new BookBindingBookSlot((IItemHandler)handler, 1, 26, allowDiamondUpgrades ? 35 : 44));
            if (allowDiamondUpgrades) {
                this.m_38897_((Slot)new BookBindingDiamondSlot((IItemHandler)handler, 2, 26, 54));
            }
            this.m_38897_((Slot)new BookBindingManuscriptSlot((IItemHandler)handler, 3, 62, 26));
            this.m_38897_((Slot)new BookBindingManuscriptSlot((IItemHandler)handler, 4, 80, 26));
            this.m_38897_((Slot)new BookBindingManuscriptSlot((IItemHandler)handler, 5, 62, 44));
            this.m_38897_((Slot)new BookBindingManuscriptSlot((IItemHandler)handler, 6, 80, 44));
            this.m_38897_((Slot)new BookBindingResultSlot((IItemHandler)handler, 7, 134, 35));
        });
        AbstractBindingTableMenu.m_38886_((ContainerData)this.data, (int)3);
        this.m_38884_(this.data);
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public boolean cannotCraft() {
        return this.data.m_6413_(2) == 0;
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        int progressArrowSize = 23;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 36 + TE_INVENTORY_SLOT_COUNT, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 36 + TE_INVENTORY_SLOT_COUNT) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    private void addPlayerInventory(Inventory inventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 85 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory inventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 8 + i * 18, 143));
        }
    }

    public boolean m_6875_(Player player) {
        return false;
    }
}

