/*
 * Decompiled with CFR 0.152.
 */
package com.mc_goodch.ancient_manuscripts.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class AMConfig {
    public static ForgeConfigSpec.BooleanValue AM_TOP_TIER_ENCHANTMENTS_ONLY_ENABLED;
    public static ForgeConfigSpec.BooleanValue AM_VANILLA_ENCHANTMENTS_ONLY_ENABLED;
    public static ForgeConfigSpec.BooleanValue AM_INCLUDE_CURSE_ENCHANTMENTS_ENABLED;
    public static ForgeConfigSpec.BooleanValue AM_ALLOW_TREASURE_ENCHANTMENTS_ENABLED;
    public static ForgeConfigSpec.BooleanValue AM_ALLOW_DIAMOND_UPGRADES_ENABLED;
    public static ForgeConfigSpec.IntValue AM_MAGIC_BOOK_GLUE_DURABILITY;
    public static ForgeConfigSpec.BooleanValue AM_REENCHANTING_ENABLED;
    public static ForgeConfigSpec.IntValue AM_MAX_BOOK_ENCHANTS;
    public static ForgeConfigSpec.IntValue AM_CRAFTING_TIME_TICKS;
    public static ForgeConfigSpec.BooleanValue AM_VILLAGER_TRADES_ENABLED;
    public static ForgeConfigSpec.IntValue AM_VILLAGER_TRADE_MAX_USES;
    public static ForgeConfigSpec.IntValue AM_VILLAGER_TRADE_COST;
    public static ForgeConfigSpec.IntValue AM_VILLAGER_TRADE_LEVEL;
    public static ForgeConfigSpec.BooleanValue AM_TRADER_TRADES_ENABLED;
    public static ForgeConfigSpec.IntValue AM_TRADER_TRADE_MAX_USES;
    public static ForgeConfigSpec.IntValue AM_TRADE_TRADE_COST;

    public static void init(ForgeConfigSpec.Builder builder) {
        builder.comment("Enchantment Options").push("enchantment_options");
        AM_TOP_TIER_ENCHANTMENTS_ONLY_ENABLED = builder.comment("Top tier enchantments only [default: false]").translation("config_top_tier_enchants_only").define("ancientManuscriptsTopTierEnchanmentsOnly", false);
        AM_VANILLA_ENCHANTMENTS_ONLY_ENABLED = builder.comment("Vanilla enchantments only [default: false]").translation("config_vanilla_enchants_only").define("ancientManuscriptsVanillaEnchanmentsOnly", false);
        AM_INCLUDE_CURSE_ENCHANTMENTS_ENABLED = builder.comment("Include curse enchantments [default: false]").translation("config_include_curse_enchants").define("ancientManuscriptsIncludeCurseEnchanments", false);
        AM_ALLOW_TREASURE_ENCHANTMENTS_ENABLED = builder.comment("Allow treasure enchantments [default: true]").translation("config_allow_treasure_enchants").define("ancientManuscriptsAllowTreasureEnchanments", true);
        builder.pop();
        builder.comment("Crafting Options").push("crafting_options");
        AM_MAGIC_BOOK_GLUE_DURABILITY = builder.comment("Glue uses [default: 20]").translation("config_glue_uses").defineInRange("magicBookGlueDurability", 20, 1, 100);
        AM_REENCHANTING_ENABLED = builder.comment("Allow enchanted books in recipe [default: true]").translation("config_allow_enchanted_book_recipe").define("ancientManuscriptsEnchantedBookInRecipeEnabled", true);
        AM_MAX_BOOK_ENCHANTS = builder.comment("Maximum book enchantments [default: 5]").translation("config_max_book_enchants").defineInRange("maximumBookEnchantments", 5, 1, 10);
        AM_CRAFTING_TIME_TICKS = builder.comment("Crafting time in seconds [default: 15]").translation("config_crafting_time").defineInRange("craftingTimeInSeconds", 15, 1, 100);
        AM_ALLOW_DIAMOND_UPGRADES_ENABLED = builder.comment("Allow diamond upgrades [default: true]").translation("config_allow_diamond_upgrades").define("allowDiamondUpgrades", true);
        builder.pop();
        builder.comment("Trade Options").push("trade_options");
        builder.comment("Villager Trades").push("villager_trades");
        AM_VILLAGER_TRADES_ENABLED = builder.comment("Villager trades enabled [default: true]").translation("config_villager_trades_enabled").define("villagerTradesEnabled", true);
        AM_VILLAGER_TRADE_LEVEL = builder.comment("Villager trade level [default: 3]").translation("config_villager_trade_level").defineInRange("villagerTradeLevel", 3, 1, 5);
        AM_VILLAGER_TRADE_MAX_USES = builder.comment("Villager max trades [default: 2]").translation("config_villager_max_trades").defineInRange("villagerMaxTradeCount", 2, 1, 20);
        AM_VILLAGER_TRADE_COST = builder.comment("Villager trade cost [default: 20]").translation("config_villager_trade_cost").defineInRange("villagerTradeCost", 20, 1, 50);
        builder.pop();
        builder.comment("Wandering Trader Trades").push("wandering_trader_trades");
        AM_TRADER_TRADES_ENABLED = builder.comment("Wandering Trader trades enabled [default: true]").translation("config_trader_trades_enabled").define("wanderingTraderTradesEnabled", true);
        AM_TRADER_TRADE_MAX_USES = builder.comment("Wandering Trader max trades [default: 2]").translation("config_trader_max_trades").defineInRange("wanderingTraderMaxTradeCount", 2, 1, 20);
        AM_TRADE_TRADE_COST = builder.comment("Wandering Trader trade cost [default: 30]").translation("config_trader_trade_cost").defineInRange("wanderingTraderTradeCost", 30, 1, 50);
        builder.pop();
        builder.pop();
    }
}

