/*
 * Decompiled with CFR 0.152.
 */
package com.mc_goodch.ancient_manuscripts.blocks.entity.custom;

import com.google.common.collect.ImmutableMap;
import com.mc_goodch.ancient_manuscripts.config.AMConfig;
import com.mc_goodch.ancient_manuscripts.init.ItemInit;
import com.mc_goodch.ancient_manuscripts.init.SoundInit;
import com.mc_goodch.ancient_manuscripts.items.EnchantedBookGlueItem;
import com.mc_goodch.ancient_manuscripts.tags.AMTags;
import com.mc_goodch.ancient_manuscripts.utilities.EnchantmentUtilities;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractBindingTableBlockEntity
extends BlockEntity
implements MenuProvider {
    private static boolean topTierOnlyEnabled = (Boolean)AMConfig.AM_TOP_TIER_ENCHANTMENTS_ONLY_ENABLED.get();
    private static boolean enchantedBooksAllowed = (Boolean)AMConfig.AM_REENCHANTING_ENABLED.get();
    private static boolean allowDiamondUpgrades = (Boolean)AMConfig.AM_ALLOW_DIAMOND_UPGRADES_ENABLED.get();
    private static int maxEnchants = (Integer)AMConfig.AM_MAX_BOOK_ENCHANTS.get();
    protected ContainerData data;
    protected int progress = 0;
    protected int maxProgress = (Integer)AMConfig.AM_CRAFTING_TIME_TICKS.get() * 20;
    protected int validRecipe = 0;
    protected Enchantment chosenEnchantment = null;
    protected int manuscriptCount = -1;
    private final ItemStackHandler itemHandler = new ItemStackHandler(8){

        protected void onContentsChanged(int slot) {
            AbstractBindingTableBlockEntity.this.m_6596_();
            if (slot == 1 || slot >= 3 && slot <= 6) {
                AbstractBindingTableBlockEntity.this.manuscriptCount = -1;
                AbstractBindingTableBlockEntity.this.chosenEnchantment = null;
            }
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();

    public AbstractBindingTableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return null;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.ancient_manuscripts.binding_table");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && side == null) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("binding_table.progress", this.progress);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("binding_table.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, AbstractBindingTableBlockEntity blockEntity) {
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, AbstractBindingTableBlockEntity blockEntity) {
        blockEntity.tick(level, blockPos, blockState, blockEntity);
    }

    private void tick(Level level, BlockPos pos, BlockState state, AbstractBindingTableBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (AbstractBindingTableBlockEntity.hasRecipe(blockEntity)) {
            if (blockEntity.progress % 40 == 0) {
                level.m_5594_(null, pos, (SoundEvent)SoundInit.PAGE_FLIP_SOUND.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            }
            ++blockEntity.progress;
            if (blockEntity.progress > blockEntity.maxProgress) {
                blockEntity.progress = blockEntity.maxProgress;
            }
            blockEntity.validRecipe = 1;
            if (blockEntity.progress >= blockEntity.maxProgress) {
                level.m_5594_(null, pos, (SoundEvent)SoundInit.BOOK_CLOSE_SOUND.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                AbstractBindingTableBlockEntity.craftItem(blockEntity);
            }
        } else {
            blockEntity.validRecipe = 0;
            blockEntity.resetProgress();
            blockEntity.chosenEnchantment = null;
        }
        AbstractBindingTableBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
    }

    private static boolean hasRecipe(AbstractBindingTableBlockEntity entity) {
        int glueDamage;
        ItemStack glueStack = entity.itemHandler.getStackInSlot(0);
        if (glueStack == ItemStack.f_41583_ || glueStack.m_41720_() == ItemInit.EMPTY_GLUE_BOTTLE.get() || entity.itemHandler.getStackInSlot(1) == ItemStack.f_41583_ || entity.itemHandler.getStackInSlot(7) != ItemStack.f_41583_) {
            return false;
        }
        int manuscriptCount = 0;
        for (int x = 3; x < 7; ++x) {
            ItemStack pageStack = entity.itemHandler.getStackInSlot(x);
            if (pageStack == ItemStack.f_41583_) continue;
            ++manuscriptCount;
        }
        if (entity.manuscriptCount != manuscriptCount) {
            entity.manuscriptCount = manuscriptCount;
            entity.chosenEnchantment = null;
        }
        if (manuscriptCount == 0) {
            entity.manuscriptCount = -1;
            entity.chosenEnchantment = null;
            return false;
        }
        int enchantmentCount = 0;
        ItemStack bookStack = entity.itemHandler.getStackInSlot(1);
        if (!enchantedBooksAllowed && bookStack.m_41720_() == Items.f_42690_) {
            entity.manuscriptCount = -1;
            entity.chosenEnchantment = null;
            return false;
        }
        Enchantment.Rarity rarity = entity.getRarityForManuscriptCount(manuscriptCount);
        if (bookStack.m_41720_() == Items.f_42690_) {
            Map enchantmentMap = EnchantmentHelper.m_44831_((ItemStack)bookStack);
            enchantmentCount = enchantmentMap.size();
            if (enchantmentCount >= maxEnchants) {
                entity.manuscriptCount = -1;
                entity.chosenEnchantment = null;
                return false;
            }
            if (entity.chosenEnchantment == null) {
                Enchantment enchantment = EnchantmentUtilities.randomEnchantmentForRarity(rarity, enchantmentMap);
                if (enchantment == null) {
                    entity.manuscriptCount = -1;
                    return false;
                }
                entity.chosenEnchantment = enchantment;
            }
        } else if (entity.chosenEnchantment == null) {
            Enchantment enchantment = EnchantmentUtilities.randomEnchantmentForRarity(rarity, null);
            if (enchantment == null) {
                entity.manuscriptCount = -1;
                return false;
            }
            entity.chosenEnchantment = enchantment;
        }
        if (entity.chosenEnchantment == null) {
            entity.manuscriptCount = -1;
            return false;
        }
        boolean isValidGlueItem = false;
        int glueDurability = glueStack.m_41776_();
        if (glueDurability - (glueDamage = glueStack.m_41773_()) >= manuscriptCount) {
            isValidGlueItem = true;
        }
        return isValidGlueItem;
    }

    private static void craftItem(AbstractBindingTableBlockEntity entity) {
        ItemStack outputBookStack = new ItemStack((ItemLike)Items.f_42690_);
        ItemStack inputBookStack = entity.itemHandler.getStackInSlot(1);
        ItemStack enchantedBook = null;
        Enchantment storedEnchantment = entity.chosenEnchantment;
        Item bookItem = inputBookStack.m_41720_();
        if (enchantedBooksAllowed && bookItem == Items.f_42690_) {
            enchantedBook = inputBookStack.m_41777_();
        }
        int manuscriptCount = 0;
        boolean hasDiamond = false;
        if (allowDiamondUpgrades) {
            hasDiamond = entity.itemHandler.getStackInSlot(2).m_204117_(Tags.Items.GEMS_DIAMOND);
        }
        for (int x = 3; x < 7; ++x) {
            ItemStack pageStack = entity.itemHandler.getStackInSlot(x);
            if (!pageStack.m_204117_(AMTags.Items.MANUSCRIPT_ITEMS)) continue;
            ++manuscriptCount;
        }
        if (entity.manuscriptCount != manuscriptCount || storedEnchantment == null) {
            entity.chosenEnchantment = null;
            entity.resetProgress();
            return;
        }
        Map enchantmentMap = null;
        if (enchantedBook != null) {
            enchantmentMap = EnchantmentHelper.m_44831_((ItemStack)enchantedBook);
        }
        int level = topTierOnlyEnabled || hasDiamond ? storedEnchantment.m_6586_() : EnchantmentUtilities.getRandomLevel(storedEnchantment.m_44702_(), storedEnchantment.m_6586_());
        boolean shouldTakeDiamond = false;
        if (allowDiamondUpgrades) {
            boolean bl = shouldTakeDiamond = storedEnchantment.m_6586_() > 1;
        }
        if (enchantedBook != null) {
            enchantmentMap.put(storedEnchantment, level);
            EnchantmentHelper.m_44865_((Map)enchantmentMap, (ItemStack)outputBookStack);
        } else {
            EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)storedEnchantment, (Object)level), (ItemStack)outputBookStack);
        }
        ItemStack glueStack = entity.itemHandler.getStackInSlot(0);
        RandomSource random = RandomSource.m_216327_();
        glueStack.m_220157_(manuscriptCount, random, null);
        EnchantedBookGlueItem glueItem = (EnchantedBookGlueItem)glueStack.m_41720_();
        if (glueItem.getDamage(glueStack) == glueItem.getMaxDamage(glueStack)) {
            entity.itemHandler.extractItem(0, 1, false);
            entity.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)ItemInit.EMPTY_GLUE_BOTTLE.get()));
        }
        entity.itemHandler.setStackInSlot(7, outputBookStack);
        entity.itemHandler.extractItem(1, 1, false);
        if (hasDiamond && shouldTakeDiamond) {
            entity.itemHandler.extractItem(2, 1, false);
        }
        for (int x = 3; x < 7; ++x) {
            ItemStack pageStack = entity.itemHandler.getStackInSlot(x);
            if (!pageStack.m_204117_(AMTags.Items.MANUSCRIPT_ITEMS)) continue;
            entity.itemHandler.extractItem(x, 1, false);
        }
        entity.resetProgress();
        entity.chosenEnchantment = null;
        entity.manuscriptCount = -1;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private Enchantment.Rarity getRarityForManuscriptCount(int count) {
        Enchantment.Rarity rarity = Enchantment.Rarity.COMMON;
        switch (count) {
            case 2: {
                rarity = Enchantment.Rarity.UNCOMMON;
                break;
            }
            case 3: {
                rarity = Enchantment.Rarity.RARE;
                break;
            }
            case 4: {
                rarity = Enchantment.Rarity.VERY_RARE;
                break;
            }
        }
        return rarity;
    }
}

