/*
 * Decompiled with CFR 0.152.
 */
package com.mc_goodch.ancient_manuscripts;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.mc_goodch.ancient_manuscripts.config.AMConfigBuilder;
import com.mc_goodch.ancient_manuscripts.config.Blacklist;
import com.mc_goodch.ancient_manuscripts.gui.BindingTableGui;
import com.mc_goodch.ancient_manuscripts.init.BlockEntitiesInit;
import com.mc_goodch.ancient_manuscripts.init.BlockInit;
import com.mc_goodch.ancient_manuscripts.init.ItemInit;
import com.mc_goodch.ancient_manuscripts.init.LootInit;
import com.mc_goodch.ancient_manuscripts.init.MenuTypesInit;
import com.mc_goodch.ancient_manuscripts.init.RecipeInit;
import com.mc_goodch.ancient_manuscripts.init.SoundInit;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ancient_manuscripts")
public class AncientManuscripts {
    public static final String MOD_ID = "ancient_manuscripts";
    public static final String EXAMPLE_MOD_ID = "example_mod_id";
    public static final Logger logger = LogManager.getLogger((String)"ancient_manuscripts");
    public static JsonObject json;
    public static Blacklist[] blacklist;
    private static final String blacklistFileName = "ancient_manuscripts_blacklist.json";

    public AncientManuscripts() {
        AMConfigBuilder.loadConfig(AMConfigBuilder.config, FMLPaths.CONFIGDIR.get().resolve("ancient_manuscripts.toml"));
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ItemInit.register(bus);
        ItemInit.registerTabs(bus);
        LootInit.register(bus);
        BlockInit.register(bus);
        BlockEntitiesInit.register(bus);
        MenuTypesInit.register(bus);
        RecipeInit.register(bus);
        SoundInit.register(bus);
        bus.addListener(this::setup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::serverSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        logger.info("Ancient Manuscripts common setup");
        this.readBlacklistFile();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypesInit.OAK_BINDING_TABLE_MENU.get()), BindingTableGui::new);
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypesInit.DARK_OAK_BINDING_TABLE_MENU.get()), BindingTableGui::new);
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypesInit.SPRUCE_BINDING_TABLE_MENU.get()), BindingTableGui::new);
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypesInit.BIRCH_BINDING_TABLE_MENU.get()), BindingTableGui::new);
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypesInit.ACACIA_BINDING_TABLE_MENU.get()), BindingTableGui::new);
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypesInit.JUNGLE_BINDING_TABLE_MENU.get()), BindingTableGui::new);
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypesInit.MANGROVE_BINDING_TABLE_MENU.get()), BindingTableGui::new);
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypesInit.WARPED_BINDING_TABLE_MENU.get()), BindingTableGui::new);
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypesInit.CRIMSON_BINDING_TABLE_MENU.get()), BindingTableGui::new);
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypesInit.BAMBOO_BINDING_TABLE_MENU.get()), BindingTableGui::new);
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypesInit.CHERRY_BINDING_TABLE_MENU.get()), BindingTableGui::new);
    }

    private void serverSetup(FMLDedicatedServerSetupEvent event) {
    }

    private void readBlacklistFile() {
        JsonReader reader = null;
        try {
            reader = new JsonReader((Reader)new FileReader(FMLPaths.CONFIGDIR.get().resolve(blacklistFileName).toString()));
            for (Blacklist item : blacklist = (Blacklist[])new Gson().fromJson(reader, Blacklist[].class)) {
                if (item.getModId().equals(EXAMPLE_MOD_ID)) continue;
                logger.info("Blacklisted mod id: " + item.getModId());
                for (String enchantment : item.getEnchantments()) {
                    logger.info("Blacklisted enchantment: " + enchantment);
                }
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            this.generateDefaultBlacklistFile();
        }
        catch (NullPointerException e) {
            logger.error("ancient_manuscripts_blacklist.json file is malformed");
            blacklist = null;
        }
        catch (IOException e) {
            logger.error("Cannot read the ancient_manuscripts_blacklist.json file");
        }
    }

    private void generateDefaultBlacklistFile() {
        ArrayList<String> enchantmentList = new ArrayList<String>();
        enchantmentList.add("example_enchantment_name");
        Blacklist newBlacklist = new Blacklist(EXAMPLE_MOD_ID, enchantmentList);
        ArrayList<Blacklist> list = new ArrayList<Blacklist>();
        list.add(newBlacklist);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonStr = gson.toJson(list);
        try {
            FileWriter writer = new FileWriter(FMLPaths.CONFIGDIR.get().resolve(blacklistFileName).toString());
            writer.write(jsonStr);
            writer.close();
            logger.info("Created the default ancient_manuscripts_blacklist.json file");
        }
        catch (IOException e) {
            logger.error("Cannot write the default ancient_manuscripts_blacklist.json file");
        }
    }
}

