/*
 * Decompiled with CFR 0.152.
 */
package croissantnova.sanitydim.entity;

import croissantnova.sanitydim.capability.ISanity;
import croissantnova.sanitydim.capability.SanityProvider;
import croissantnova.sanitydim.entity.EntityRegistry;
import croissantnova.sanitydim.entity.InnerEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class InnerEntitySpawner {
    private static final RandomSource RAND = RandomSource.m_216327_();
    public static int spawnRad = 20;
    public static int detectionRad = 40;
    public static int spawnTimeout = 400;
    public static final float SPAWN_THRESHOLD = 0.75f;
    public static final Map<ServerPlayer, Integer> PLAYER_TO_SPAWN_TIMEOUT = new HashMap<ServerPlayer, Integer>();

    private static int getHeightForSpawning(Level level, BlockPos blockPos, int radius) {
        int i;
        BlockPos.MutableBlockPos mutable = blockPos.m_122032_();
        for (i = 0; i < radius; ++i) {
            if (level.m_8055_((BlockPos)mutable).m_60795_() || !level.m_8055_((BlockPos)mutable.m_122173_(Direction.UP)).m_60795_()) continue;
            return mutable.m_123342_();
        }
        for (i = 0; i < radius; ++i) {
            if (!level.m_8055_((BlockPos)mutable).m_60795_() || level.m_8055_((BlockPos)mutable.m_122173_(Direction.DOWN)).m_60795_()) continue;
            return mutable.m_123342_() - 1;
        }
        return 0;
    }

    public static boolean trySpawnForPlayer(ServerPlayer player) {
        if (player == null || player.m_7500_() || player.m_5833_() || player.m_9236_().m_46791_().equals((Object)Difficulty.PEACEFUL)) {
            return false;
        }
        PLAYER_TO_SPAWN_TIMEOUT.putIfAbsent(player, 0);
        int t = PLAYER_TO_SPAWN_TIMEOUT.get(player);
        if (t > 0) {
            PLAYER_TO_SPAWN_TIMEOUT.put(player, t - 1);
            return false;
        }
        ISanity s = (ISanity)player.getCapability(SanityProvider.CAP).orElse(null);
        if (s == null) {
            return false;
        }
        if (s.getSanity() < 0.75f || InnerEntitySpawner.getInnerEntitiesInRadius(player.m_9236_(), player.m_20183_(), detectionRad).size() >= 3) {
            return false;
        }
        int index = RAND.m_188503_(EntityRegistry.INNER_ENTITIES.size());
        InnerEntity entity = (InnerEntity)EntityRegistry.INNER_ENTITIES.get(index).get().m_20615_(player.m_9236_());
        if (entity == null) {
            return false;
        }
        BlockPos trialPos = (BlockPos)BlockPos.m_235641_((RandomSource)RAND, (int)1, (int)(player.m_20183_().m_123341_() - spawnRad), (int)player.m_20183_().m_123342_(), (int)(player.m_20183_().m_123343_() - spawnRad), (int)(player.m_20183_().m_123341_() + spawnRad), (int)player.m_20183_().m_123342_(), (int)(player.m_20183_().m_123343_() + spawnRad)).iterator().next();
        int h = InnerEntitySpawner.getHeightForSpawning(player.m_9236_(), trialPos, spawnRad);
        if (h == 0) {
            return false;
        }
        trialPos = new BlockPos(trialPos.m_123341_(), h, trialPos.m_123343_());
        entity.m_146884_(new Vec3((double)((float)trialPos.m_123341_() + 0.5f), (double)((float)trialPos.m_123342_() + 0.5f), (double)((float)trialPos.m_123343_() + 0.5f)));
        if (entity.m_6914_((LevelReader)player.m_9236_()) && player.m_9236_().m_45786_((Entity)entity) && ((ServerLevel)player.m_9236_()).m_8860_((Entity)entity)) {
            PLAYER_TO_SPAWN_TIMEOUT.put(player, spawnTimeout);
            return true;
        }
        return false;
    }

    public static List<InnerEntity> getInnerEntitiesInRadius(Level level, BlockPos blockPos, int radius) {
        return level.m_45976_(InnerEntity.class, new AABB(blockPos).m_82400_((double)radius));
    }
}

