/*
 * Decompiled with CFR 0.152.
 */
package croissantnova.sanitydim.config;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import croissantnova.sanitydim.SanityMod;
import croissantnova.sanitydim.config.ConfigBrokenBlockCategory;
import croissantnova.sanitydim.config.ConfigItemCategory;
import croissantnova.sanitydim.config.ConfigManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;

public abstract class DimensionConfig {
    public static final Map<String, Map<ResourceLocation, Object>> configToDimStored = new HashMap<String, Map<ResourceLocation, Object>>();
    public static final Map<ResourceLocation, Map<Integer, ConfigItemCategory>> idToItemCat = new HashMap<ResourceLocation, Map<Integer, ConfigItemCategory>>();
    public static final Map<ResourceLocation, Map<Integer, ConfigBrokenBlockCategory>> idToBrokenBlockCat = new HashMap<ResourceLocation, Map<Integer, ConfigBrokenBlockCategory>>();

    private static void unloadDimension(String dim, Config config) {
        ResourceLocation name = new ResourceLocation(dim);
        block14: for (Map.Entry<String, Map<ResourceLocation, Object>> entry : configToDimStored.entrySet()) {
            String key = entry.getKey();
            Map<ResourceLocation, Object> value = entry.getValue();
            if (!config.contains(key)) continue;
            switch (key) {
                case "sanity.passive.blocks": {
                    value.put(name, ConfigManager.processPassiveBlocks((List)config.get(key)));
                    continue block14;
                }
                case "sanity.active.items": {
                    value.put(name, ConfigManager.processItems((List)config.get(key)));
                    continue block14;
                }
                case "sanity.active.item_categories": {
                    List<Object> list = ConfigManager.processItemCats((List)config.get(key));
                    value.put(name, list);
                    idToItemCat.put(name, ConfigManager.getMapFromItemCats(list));
                    continue block14;
                }
                case "sanity.active.broken_blocks": {
                    value.put(name, ConfigManager.processBrokenBlocks((List)config.get(key)));
                    continue block14;
                }
                case "sanity.active.broken_block_categories": {
                    List<Object> list = ConfigManager.processBrokenBlockCats((List)config.get(key));
                    value.put(name, list);
                    idToBrokenBlockCat.put(name, ConfigManager.getMapFromBrokenBlockCats(list));
                    continue block14;
                }
            }
            value.put(name, config.get(key));
        }
    }

    private static void createExampleConfig(Path dimPath) {
        Path example = Paths.get(dimPath.toString(), "example.toml");
        String lines = "# Dimensions to apply this config to, e.g. minecraft:overworld, minecraft:the_nether, minecraft:the_end\napplied_dimensions = [ \"minecraft:example_dimension1\", \"someothermodid:example_dimension2\" ]\n\n# Anything that is not present in this config will default to whatever is set in default.toml\n[sanity]\n\t[sanity.passive]\n\t\t# Now that's what I call hardcore\n\t\tmonster = -100.0\n";
        try {
            Files.writeString(example, (CharSequence)lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            SanityMod.LOGGER.warn("unable to create example dimension config, refer to github to see one");
        }
    }

    public static void init() {
        DimensionConfig.clear();
        for (Map.Entry<String, ConfigManager.ProxyValueEntry<?>> entry : ConfigManager.proxies.entrySet()) {
            configToDimStored.put(entry.getKey(), new HashMap());
        }
        Path dimPath = Paths.get(FMLPaths.CONFIGDIR.get().toString(), "sanitydim" + File.separator + "dimension");
        try {
            Files.createDirectories(dimPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            SanityMod.LOGGER.warn("unable to create dimension config directory: " + dimPath);
            return;
        }
        try (Stream<Path> paths = Files.walk(dimPath, 1, new FileVisitOption[0]);){
            paths.forEach(path -> {
                if (path.toString().endsWith(".toml") && !path.toString().equals("example.toml")) {
                    FileConfig config = FileConfig.of((Path)path);
                    config.load();
                    List dims = (List)config.get("applied_dimensions");
                    if (dims != null && dims.size() > 0) {
                        SanityMod.LOGGER.info("Applying dimension config " + path.getFileName());
                        for (String dim : dims) {
                            DimensionConfig.unloadDimension(dim, (Config)config);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DimensionConfig.createExampleConfig(dimPath);
    }

    public static void clear() {
        configToDimStored.clear();
        idToItemCat.clear();
        idToBrokenBlockCat.clear();
    }
}

