/*
 * Decompiled with CFR 0.152.
 */
package croissantnova.sanitydim.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import croissantnova.sanitydim.capability.SanityProvider;
import croissantnova.sanitydim.config.DimensionConfig;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class SanityCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sanity").requires(stack -> stack.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).executes(stack -> SanityCommand.setSanity((CommandSourceStack)stack.getSource(), Collections.singleton((ServerPlayer)((CommandSourceStack)stack.getSource()).m_81374_()), FloatArgumentType.getFloat((CommandContext)stack, (String)"value"))))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).executes(stack -> SanityCommand.setSanity((CommandSourceStack)stack.getSource(), EntityArgument.m_91477_((CommandContext)stack, (String)"targets"), FloatArgumentType.getFloat((CommandContext)stack, (String)"value"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)-100.0f, (float)100.0f)).executes(stack -> SanityCommand.addSanity((CommandSourceStack)stack.getSource(), Collections.singleton((ServerPlayer)((CommandSourceStack)stack.getSource()).m_81374_()), FloatArgumentType.getFloat((CommandContext)stack, (String)"value"))))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)-100.0f, (float)100.0f)).executes(stack -> SanityCommand.addSanity((CommandSourceStack)stack.getSource(), EntityArgument.m_91477_((CommandContext)stack, (String)"targets"), FloatArgumentType.getFloat((CommandContext)stack, (String)"value"))))))).then(Commands.m_82127_((String)"config").then(Commands.m_82127_((String)"reload").executes(stack -> SanityCommand.reloadConfig((CommandSourceStack)stack.getSource())))));
    }

    private static int setSanity(CommandSourceStack stack, Collection<? extends ServerPlayer> targets, float value) {
        for (ServerPlayer serverPlayer : targets) {
            serverPlayer.getCapability(SanityProvider.CAP).ifPresent(s -> s.setSanity((100.0f - value) / 100.0f));
        }
        if (targets.size() == 1) {
            stack.m_288197_(() -> Component.m_237110_((String)"commands.sanity.set.success.single", (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).m_5446_(), Float.valueOf(value)}), true);
        } else {
            stack.m_288197_(() -> Component.m_237110_((String)"commands.sanity.set.success.multiple", (Object[])new Object[]{Float.valueOf(value), targets.size()}), true);
        }
        return (int)value;
    }

    private static int addSanity(CommandSourceStack stack, Collection<? extends ServerPlayer> targets, float value) {
        for (ServerPlayer serverPlayer : targets) {
            serverPlayer.getCapability(SanityProvider.CAP).ifPresent(s -> s.setSanity(s.getSanity() - value / 100.0f));
        }
        if (targets.size() == 1) {
            stack.m_288197_(() -> Component.m_237110_((String)"commands.sanity.add.success.single", (Object[])new Object[]{Float.valueOf(value), ((ServerPlayer)targets.iterator().next()).m_5446_()}), true);
        } else {
            stack.m_288197_(() -> Component.m_237110_((String)"commands.sanity.add.success.multiple", (Object[])new Object[]{targets.size(), Float.valueOf(value)}), true);
        }
        return (int)value;
    }

    private static int reloadConfig(CommandSourceStack stack) {
        DimensionConfig.init();
        stack.m_288197_(() -> Component.m_237115_((String)"commands.sanity.config.reload"), true);
        return 1;
    }
}

